/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tickcentral.core;

import com.github.terminatornl.tickcentral.TickCentral;
import com.github.terminatornl.tickcentral.api.TickHub;
import com.github.terminatornl.tickcentral.api.TickInterceptor;
import com.github.terminatornl.tickcentral.core.BlockVerification;
import com.github.terminatornl.tickcentral.core.EntityVerification;
import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.EventBus;
import java.io.File;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.MetadataCollection;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.fml.common.versioning.InvalidVersionSpecificationException;
import net.minecraftforge.fml.common.versioning.VersionRange;

public class ModContainer
implements net.minecraftforge.fml.common.ModContainer,
TickInterceptor {
    private int classVersion = 0;

    public boolean registerBus(EventBus bus, LoadController controller) {
        BlockVerification blockVerification = new BlockVerification();
        TickCentral.LOGGER.info("Testing if transformations have been applied...");
        TickInterceptor origionalExecutor = TickHub.INTERCEPTOR;
        TickHub.INTERCEPTOR = this;
        blockVerification.func_180650_b(null, null, null, null);
        blockVerification.func_180645_a(null, null, null, null);
        blockVerification.func_73660_a();
        blockVerification.KILL_MODE = false;
        blockVerification.ACTIVATED = false;
        try {
            TickHub.trueUpdateTick(blockVerification, null, null, null, null);
        }
        catch (NoSuchMethodError e) {
            TickCentral.LOGGER.fatal("Normal block updates: TrueTick-NOT OKAY!", (Throwable)e);
            BlockVerification.AbortServer();
        }
        if (!blockVerification.ACTIVATED) {
            TickCentral.LOGGER.fatal("Normal block updates: TrueTick-NOT FIRED");
            BlockVerification.AbortServer();
        }
        blockVerification.ACTIVATED = false;
        try {
            TickHub.trueRandomTick(blockVerification, null, null, null, null);
        }
        catch (NoSuchMethodError e) {
            TickCentral.LOGGER.fatal("Random block updates: TrueTick-NOT OKAY!", (Throwable)e);
            BlockVerification.AbortServer();
        }
        if (!blockVerification.ACTIVATED) {
            TickCentral.LOGGER.fatal("Random block updates: TrueTick-NOT FIRED");
            BlockVerification.AbortServer();
        }
        blockVerification.ACTIVATED = false;
        try {
            TickHub.trueUpdate(blockVerification);
        }
        catch (NoSuchMethodError e) {
            TickCentral.LOGGER.fatal("ITickable updates: TrueTick-NOT OKAY!", (Throwable)e);
            BlockVerification.AbortServer();
        }
        if (!blockVerification.ACTIVATED) {
            TickCentral.LOGGER.fatal("ITickable updates: TrueTick-NOT FIRED");
            BlockVerification.AbortServer();
        }
        blockVerification.ACTIVATED = false;
        blockVerification.callInternally();
        EntityVerification entityVerification = new EntityVerification();
        TickHub.INTERCEPTOR = this;
        entityVerification.func_70071_h_();
        entityVerification.KILL_MODE = false;
        entityVerification.ACTIVATED = false;
        try {
            TickHub.trueOnUpdate(entityVerification);
        }
        catch (NoSuchMethodError e) {
            TickCentral.LOGGER.fatal("Entity updates: TrueTick-NOT OKAY!", (Throwable)e);
            EntityVerification.AbortServer();
        }
        if (!entityVerification.ACTIVATED) {
            TickCentral.LOGGER.fatal("Entity updates: TrueTick-NOT FIRED");
            EntityVerification.AbortServer();
        }
        entityVerification.ACTIVATED = false;
        entityVerification.callInternally();
        TickHub.INTERCEPTOR = origionalExecutor;
        TickCentral.LOGGER.info("Success!");
        return true;
    }

    @Override
    public void redirectUpdateTick(Block block, World worldIn, BlockPos pos, IBlockState state, Random random) {
        TickCentral.LOGGER.info("Normal block updates: Redirection-OK");
    }

    @Override
    public void redirectRandomTick(Block block, World worldIn, BlockPos pos, IBlockState state, Random random) {
        TickCentral.LOGGER.info("Random block updates: Redirection-OK");
    }

    @Override
    public void redirectUpdate(ITickable tickable) {
        TickCentral.LOGGER.info("ITickable updates: Redirection-OK");
    }

    @Override
    public void redirectOnUpdate(Entity entity) {
        TickCentral.LOGGER.info("Entity updates: Redirection-OK");
    }

    public String getModId() {
        return "tickcentral";
    }

    public String getName() {
        return "TickCentral";
    }

    public String getVersion() {
        return "2.6";
    }

    public File getSource() {
        return new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getFile());
    }

    public ModMetadata getMetadata() {
        ModMetadata metadata = new ModMetadata();
        metadata.name = "TickCentral";
        metadata.modId = "tickcentral";
        metadata.authorList = new LinkedList();
        metadata.authorList.add("Terminator_NL");
        metadata.description = "A coremod which makes transforming classes without mixin easier, regardless if mixin is installed.";
        return metadata;
    }

    public void bindMetadata(MetadataCollection mc) {
    }

    public void setEnabledState(boolean enabled) {
    }

    public Set<ArtifactVersion> getRequirements() {
        return new HashSet<ArtifactVersion>();
    }

    public List<ArtifactVersion> getDependencies() {
        return new LinkedList<ArtifactVersion>();
    }

    public List<ArtifactVersion> getDependants() {
        return new LinkedList<ArtifactVersion>();
    }

    public String getSortingRules() {
        return "";
    }

    public boolean matches(Object mod) {
        return mod == TickCentral.INSTANCE;
    }

    public Object getMod() {
        return TickCentral.INSTANCE;
    }

    public ArtifactVersion getProcessedVersion() {
        return new DefaultArtifactVersion("2.6");
    }

    public boolean isImmutable() {
        return true;
    }

    public String getDisplayVersion() {
        return "2.6";
    }

    public VersionRange acceptableMinecraftVersionRange() {
        try {
            return VersionRange.createFromVersionSpec((String)"[0,)");
        }
        catch (InvalidVersionSpecificationException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public Certificate getSigningCertificate() {
        return null;
    }

    public Map<String, String> getCustomModProperties() {
        return EMPTY_PROPERTIES;
    }

    public Class<?> getCustomResourcePackClass() {
        return null;
    }

    public Map<String, String> getSharedModDescriptor() {
        return null;
    }

    public ModContainer.Disableable canBeDisabled() {
        return ModContainer.Disableable.NEVER;
    }

    public String getGuiClassName() {
        return null;
    }

    public List<String> getOwnedPackages() {
        return ImmutableList.of();
    }

    public boolean shouldLoadInEnvironment() {
        return true;
    }

    public URL getUpdateUrl() {
        return null;
    }

    public void setClassVersion(int classVersion) {
        this.classVersion = classVersion;
    }

    public int getClassVersion() {
        return this.classVersion;
    }
}

