/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import java.util.HashMap;
import java.util.Map;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismBlocks;
import mekanism.common.MekanismFluids;
import mekanism.common.tile.TileEntityTeleporter;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class RenderTeleporter
extends TileEntitySpecialRenderer<TileEntityTeleporter> {
    private Map<Integer, MekanismRenderer.DisplayInteger> cachedOverlays = new HashMap<Integer, MekanismRenderer.DisplayInteger>();

    public void render(TileEntityTeleporter tileEntity, double x, double y, double z, float partialTick, int destroyStage, float alpha) {
        if (tileEntity.shouldRender) {
            this.push();
            GL11.glColor4f((float)EnumColor.PURPLE.getColor(0), (float)EnumColor.PURPLE.getColor(1), (float)EnumColor.PURPLE.getColor(2), (float)0.75f);
            this.func_147499_a(MekanismRenderer.getBlocksTexture());
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
            Coord4D obj = Coord4D.get(tileEntity).offset(EnumFacing.WEST);
            int type = 0;
            IBlockState s = obj.getBlockState((IBlockAccess)tileEntity.func_145831_w());
            if (s.func_177230_c() == MekanismBlocks.BasicBlock && s.func_177230_c().func_176201_c(s) == 7) {
                type = 1;
            }
            int display = this.getOverlayDisplay((Integer)Integer.valueOf((int)type)).display;
            GL11.glCallList((int)display);
            MekanismRenderer.resetColor();
            this.pop();
        }
    }

    private void pop() {
        GL11.glPopAttrib();
        MekanismRenderer.glowOff();
        MekanismRenderer.blendOff();
        GlStateManager.func_179121_F();
    }

    private void push() {
        GlStateManager.func_179094_E();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)2896);
        MekanismRenderer.glowOn();
        MekanismRenderer.blendOn();
    }

    private MekanismRenderer.DisplayInteger getOverlayDisplay(Integer type) {
        if (this.cachedOverlays.containsKey(type)) {
            return this.cachedOverlays.get(type);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Blocks.field_150348_b;
        toReturn.setTexture(MekanismFluids.Oxygen.getSprite());
        MekanismRenderer.DisplayInteger display = MekanismRenderer.DisplayInteger.createAndStart();
        if (this.cachedOverlays.containsKey(type)) {
            this.cachedOverlays.get(type);
        } else {
            this.cachedOverlays.put(type, display);
        }
        switch (type) {
            case 0: {
                toReturn.minY = 1.0;
                toReturn.maxY = 3.0;
                toReturn.minX = 0.46;
                toReturn.minZ = 0.0;
                toReturn.maxX = 0.54;
                toReturn.maxZ = 1.0;
                break;
            }
            case 1: {
                toReturn.minY = 1.0;
                toReturn.maxY = 3.0;
                toReturn.minX = 0.0;
                toReturn.minZ = 0.46;
                toReturn.maxX = 1.0;
                toReturn.maxZ = 0.54;
            }
        }
        MekanismRenderer.renderObject(toReturn);
        MekanismRenderer.DisplayInteger.endList();
        return display;
    }
}

