/*
 * Decompiled with CFR 0.152.
 */
package forestry.climatology;

import forestry.api.climate.ClimateCapabilities;
import forestry.api.climate.IClimateTransformer;
import forestry.climatology.ModuleClimatology;
import forestry.climatology.items.ItemHabitatScreen;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.TickHelper;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PreviewHandlerClient {
    private final TickHelper tickHelper = new TickHelper();
    private final PreviewRenderer renderer = new PreviewRenderer();

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent tickEvent) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        World world = player.field_70170_p;
        this.tickHelper.onTick();
        if (this.tickHelper.updateOnInterval(100)) {
            ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
            if (stack.func_190926_b() || stack.func_77973_b() != ModuleClimatology.getItems().habitatScreen || !ItemHabitatScreen.isValid(stack, player.field_70170_p) || !ItemHabitatScreen.isPreviewModeActive(stack)) {
                this.renderer.clearPreview();
                return;
            }
            BlockPos currentPos = ItemHabitatScreen.getPosition(stack);
            if (currentPos == null || player.func_70011_f((double)currentPos.func_177958_n(), (double)currentPos.func_177956_o(), (double)currentPos.func_177952_p()) > 128.0) {
                this.renderer.clearPreview();
                return;
            }
            IClimateTransformer transformer = TileUtil.getInterface(world, currentPos, ClimateCapabilities.CLIMATE_TRANSFORMER, null);
            if (transformer == null) {
                this.renderer.clearPreview();
                return;
            }
            this.renderer.updatePreview(currentPos, transformer.getRange(), transformer.isCircular());
        }
    }

    @SubscribeEvent
    public void worldUnloaded(WorldEvent.Unload event) {
        this.renderer.clearPreview();
    }

    private class PreviewRenderer {
        private final Set<BlockPos> previewPositions = new HashSet<BlockPos>();
        private final AxisAlignedBB boundingBox = Block.field_185505_j.func_186664_h(0.125);
        private boolean addedToBus = false;
        @Nullable
        private BlockPos previewOrigin = null;
        private int range = -1;
        private boolean circular;

        private PreviewRenderer() {
        }

        public void setPreview(BlockPos centerPosition, int range, boolean circular) {
            this.previewPositions.clear();
            BlockPos center = new BlockPos(0, 0, 0);
            for (int x = -range; x <= range; ++x) {
                for (int y = -range; y <= range; ++y) {
                    boolean valid;
                    BlockPos position = centerPosition.func_177982_a(x, 0, y);
                    if (circular) {
                        double distance = Math.round(center.func_185332_f(x, 0, y));
                        valid = distance <= (double)range && distance > (double)(range - 1);
                    } else {
                        boolean bl = valid = x == -range || x == range || y == -range || y == range;
                    }
                    if (!valid) continue;
                    this.previewPositions.add(position);
                }
            }
            this.previewOrigin = centerPosition;
            this.range = range;
            this.circular = circular;
            if (!this.addedToBus) {
                this.addedToBus = true;
                MinecraftForge.EVENT_BUS.register((Object)this);
            }
        }

        public boolean isPreviewOrigin(BlockPos pos) {
            return pos.equals((Object)this.previewOrigin);
        }

        @Nullable
        public BlockPos getPreviewOrigin() {
            return this.previewOrigin;
        }

        public void updatePreview(BlockPos centerPosition, int range, boolean circular) {
            if (centerPosition == this.previewOrigin || range != this.range || circular != this.circular) {
                this.setPreview(centerPosition, range, circular);
            }
        }

        public void clearPreview() {
            this.previewOrigin = null;
            this.circular = false;
            this.range = -1;
            this.previewPositions.clear();
            MinecraftForge.EVENT_BUS.unregister((Object)PreviewHandlerClient.this.renderer);
            this.addedToBus = false;
        }

        @SubscribeEvent
        public void onWorldRenderLast(RenderWorldLastEvent event) {
            if (this.previewPositions.isEmpty()) {
                return;
            }
            float partialTicks = event.getPartialTicks();
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            double playerX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
            double playerY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
            double playerZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(-playerX), (double)(-playerY), (double)(-playerZ));
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187441_d((float)6.0f);
            GlStateManager.func_179090_x();
            for (BlockPos position : this.previewPositions) {
                AxisAlignedBB boundingBox = this.boundingBox.func_186670_a(position);
                RenderGlobal.func_189696_b((AxisAlignedBB)boundingBox, (float)0.75f, (float)0.5f, (float)0.0f, (float)0.45f);
            }
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }
}

