/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.api.tileentity.IManoMeasurable;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControlled;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntityVacuumPump
extends TileEntityPneumaticBase
implements IRedstoneControlled,
IManoMeasurable {
    @GuiSynced
    private final IAirHandler vacuumHandler = PneumaticRegistry.getInstance().getAirHandlerSupplier().createTierOneAirHandler(2000);
    public int rotation;
    public int oldRotation;
    private int turnTimer = -1;
    @DescSynced
    public boolean turning = false;
    private int rotationSpeed;
    @GuiSynced
    public int redstoneMode;

    public TileEntityVacuumPump() {
        super(5.0f, 7.0f, 2000, 4);
        this.addApplicableUpgrade(IItemRegistry.EnumUpgrade.SPEED);
    }

    @Override
    public IAirHandler getAirHandler(EnumFacing side) {
        if (side == null || side == this.getInputSide()) {
            return super.getAirHandler(side);
        }
        if (side == this.getVacuumSide()) {
            return this.vacuumHandler;
        }
        return null;
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        this.vacuumHandler.validate(this);
    }

    @Override
    public void onNeighborTileUpdate() {
        super.onNeighborTileUpdate();
        this.vacuumHandler.onNeighborChange();
    }

    public EnumFacing getInputSide() {
        return this.getVacuumSide().func_176734_d();
    }

    public EnumFacing getVacuumSide() {
        return this.getRotation();
    }

    @Override
    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K && this.turnTimer >= 0) {
            --this.turnTimer;
        }
        if (!this.func_145831_w().field_72995_K && this.getAirHandler(this.getInputSide()).getPressure() > 2.0f && this.getAirHandler(this.getVacuumSide()).getPressure() > -1.0f && this.redstoneAllows()) {
            if (!this.func_145831_w().field_72995_K && this.turnTimer == -1) {
                this.turning = true;
            }
            this.getAirHandler(this.getVacuumSide()).addAir((int)(-2.0f * this.getSpeedMultiplierFromUpgrades()));
            this.getAirHandler(this.getInputSide()).addAir((int)(-10.0f * this.getSpeedUsageMultiplierFromUpgrades()));
            this.turnTimer = 40;
        }
        if (this.turnTimer == 0) {
            this.turning = false;
        }
        this.oldRotation = this.rotation;
        if (this.func_145831_w().field_72995_K) {
            this.rotationSpeed = this.turning ? Math.min(this.rotationSpeed + 1, 20) : Math.max(this.rotationSpeed - 1, 0);
            this.rotation += this.rotationSpeed;
        }
        super.func_73660_a();
        this.vacuumHandler.update();
        IAirHandler inputHandler = this.getAirHandler(this.getInputSide());
        List<Pair<EnumFacing, IAirHandler>> teList = inputHandler.getConnectedPneumatics();
        if (teList.size() == 0) {
            inputHandler.airLeak(this.getInputSide());
        }
        if ((teList = this.vacuumHandler.getConnectedPneumatics()).size() == 0) {
            this.vacuumHandler.airLeak(this.getVacuumSide());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTTagCompound vacuum = new NBTTagCompound();
        this.vacuumHandler.writeToNBT(vacuum);
        tag.func_74782_a("vacuum", (NBTBase)vacuum);
        tag.func_74757_a("turning", this.turning);
        tag.func_74768_a("redstoneMode", this.redstoneMode);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.vacuumHandler.readFromNBT(tag.func_74775_l("vacuum"));
        this.turning = tag.func_74767_n("turning");
        this.redstoneMode = tag.func_74762_e("redstoneMode");
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
        }
    }

    @Override
    public void printManometerMessage(EntityPlayer player, List<String> curInfo) {
        curInfo.add(TextFormatting.GREEN + "Input pressure: " + PneumaticCraftUtils.roundNumberTo(this.getAirHandler(this.getInputSide()).getPressure(), 1) + " bar. Vacuum pressure: " + PneumaticCraftUtils.roundNumberTo(this.getAirHandler(this.getVacuumSide()).getPressure(), 1) + " bar.");
    }

    @Override
    public String getName() {
        return Blockss.VACUUM_PUMP.func_149739_a();
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }
}

