/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.tileentity.IHeatExchanger;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.IHeatTinted;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControlled;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class TileEntityThermalCompressor
extends TileEntityPneumaticBase
implements IHeatExchanger,
IHeatTinted,
IRedstoneControlled {
    private static final double AIR_GEN_MULTIPLIER = 0.05;
    private double[] generated = new double[2];
    @GuiSynced
    private final IHeatExchangerLogic[] heatExchangers = new IHeatExchangerLogic[4];
    private final IHeatExchangerLogic connector1;
    private final IHeatExchangerLogic connector2;
    private final IHeatExchangerLogic dummyExchanger;
    @DescSynced
    private int[] heatLevel = new int[4];
    @GuiSynced
    private int redstoneMode;

    public TileEntityThermalCompressor() {
        super(5.0f, 7.0f, 5000, 4);
        for (int i = 0; i < this.heatExchangers.length; ++i) {
            this.heatExchangers[i] = PneumaticRegistry.getInstance().getHeatRegistry().getHeatExchangerLogic();
            this.heatExchangers[i].setThermalCapacity(2.0);
        }
        this.connector1 = this.makeConnector(EnumFacing.NORTH);
        this.connector2 = this.makeConnector(EnumFacing.EAST);
        this.dummyExchanger = PneumaticRegistry.getInstance().getHeatRegistry().getHeatExchangerLogic();
    }

    private IHeatExchangerLogic makeConnector(EnumFacing side) {
        IHeatExchangerLogic connector = PneumaticRegistry.getInstance().getHeatRegistry().getHeatExchangerLogic();
        connector.setThermalResistance(ConfigHandler.machineProperties.thermalCompressorThermalResistance);
        connector.addConnectedExchanger(this.heatExchangers[side.func_176736_b()]);
        connector.addConnectedExchanger(this.heatExchangers[side.func_176734_d().func_176736_b()]);
        return connector;
    }

    @Override
    protected void initializeIfHeatExchanger() {
        super.initializeIfHeatExchanger();
        for (int i = 0; i < this.heatExchangers.length; ++i) {
            this.initializeHeatExchanger(this.heatExchangers[i], EnumFacing.func_176731_b((int)i));
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            for (IHeatExchangerLogic heatExchanger : this.heatExchangers) {
                heatExchanger.update();
            }
            if (this.redstoneAllows()) {
                this.connector1.setThermalResistance(ConfigHandler.machineProperties.thermalCompressorThermalResistance);
                this.connector2.setThermalResistance(ConfigHandler.machineProperties.thermalCompressorThermalResistance);
            } else {
                this.connector1.setThermalResistance(ConfigHandler.machineProperties.thermalCompressorThermalResistance * 100.0);
                this.connector2.setThermalResistance(ConfigHandler.machineProperties.thermalCompressorThermalResistance * 100.0);
            }
            this.connector1.update();
            this.connector2.update();
            if (this.redstoneAllows()) {
                this.generatePressure(0);
                this.generatePressure(1);
            }
            for (int i = 0; i < 4; ++i) {
                this.heatLevel[i] = HeatUtil.getHeatLevelForTemperature(this.heatExchangers[i].getTemperature());
            }
        }
    }

    private void generatePressure(int side) {
        double diff = Math.abs(this.heatExchangers[side].getTemperature() - this.heatExchangers[side + 2].getTemperature());
        int n = side;
        this.generated[n] = this.generated[n] + diff * 0.05;
        if (this.generated[side] > 1.0) {
            int toAdd = (int)this.generated[side];
            this.addAir(toAdd);
            int n2 = side;
            this.generated[n2] = this.generated[n2] - (double)toAdd;
        }
    }

    @Override
    public boolean isConnectedTo(EnumFacing side) {
        return side.func_176740_k() == EnumFacing.Axis.Y;
    }

    @Override
    public String getName() {
        return Blockss.THERMAL_COMPRESSOR.func_149739_a();
    }

    @Override
    public IHeatExchangerLogic getHeatExchangerLogic(EnumFacing side) {
        if (side == null) {
            return this.dummyExchanger;
        }
        return side.func_176740_k() == EnumFacing.Axis.Y ? null : this.heatExchangers[side.func_176736_b()];
    }

    @Override
    public int getHeatLevelForTintIndex(int tintIndex) {
        if (tintIndex >= 0 && tintIndex <= 3) {
            return this.heatLevel[tintIndex];
        }
        return 10;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        for (int i = 0; i < 4; ++i) {
            NBTTagCompound t1 = new NBTTagCompound();
            this.heatExchangers[i].writeToNBT(t1);
            tag.func_74782_a("side" + i, (NBTBase)t1);
        }
        tag.func_74768_a("redstoneMode", this.redstoneMode);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        for (int i = 0; i < 4; ++i) {
            this.heatExchangers[i].readFromNBT(tag.func_74775_l("side" + i));
        }
        this.redstoneMode = tag.func_74762_e("redstoneMode");
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public void handleGUIButtonPress(int guiID, EntityPlayer player) {
        if (guiID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
        }
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }
}

