/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.semiblock;

import com.google.common.collect.HashBiMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.api.event.SemiblockEvent;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketAddSemiBlock;
import me.desht.pneumaticcraft.common.network.PacketDescription;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.network.PacketRemoveSemiBlock;
import me.desht.pneumaticcraft.common.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.common.semiblock.ISemiBlockItem;
import me.desht.pneumaticcraft.common.semiblock.ItemSemiBlockBase;
import me.desht.pneumaticcraft.common.util.NBTUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.StreamUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.Validate;

@Mod.EventBusSubscriber
public class SemiBlockManager {
    private final Map<Chunk, Map<BlockPos, List<ISemiBlock>>> semiBlocks = new HashMap<Chunk, Map<BlockPos, List<ISemiBlock>>>();
    private final List<ISemiBlock> addingBlocks = new LinkedList<ISemiBlock>();
    private final Map<Chunk, Set<EntityPlayer>> syncList = new HashMap<Chunk, Set<EntityPlayer>>();
    private final Set<Chunk> chunksMarkedForRemoval = new HashSet<Chunk>();
    private static final int SYNC_DISTANCE_SQ = 4096;
    private static final int SYNC_DISTANCE_SQ5 = 4761;
    private static final int SYNC_DISTANCE_SQ10 = 5476;
    private static final HashBiMap<String, Class<? extends ISemiBlock>> registeredTypes = HashBiMap.create();
    private static final HashBiMap<Class<? extends ISemiBlock>, ItemSemiBlockBase> semiBlockToItems = HashBiMap.create();
    private static final SemiBlockManager INSTANCE = new SemiBlockManager();
    private static final SemiBlockManager CLIENT_INSTANCE = new SemiBlockManager();

    private static SemiBlockManager getServerInstance() {
        return INSTANCE;
    }

    public static void registerEventHandler(boolean isClient) {
        MinecraftForge.EVENT_BUS.register((Object)(isClient ? CLIENT_INSTANCE : INSTANCE));
    }

    private static SemiBlockManager getClientOldInstance() {
        return CLIENT_INSTANCE;
    }

    public static SemiBlockManager getInstance(World world) {
        return world.field_72995_K ? CLIENT_INSTANCE : INSTANCE;
    }

    static void registerSemiBlock(String key, Class<? extends ISemiBlock> semiBlock) {
        SemiBlockManager.registerSemiBlock(key, semiBlock, ItemSemiBlockBase.class);
    }

    static void registerSemiBlock(String key, Class<? extends ISemiBlock> semiBlock, Class<? extends ItemSemiBlockBase> itemClass) {
        Validate.isTrue((!registeredTypes.containsKey((Object)key) ? 1 : 0) != 0, (String)("Duplicate registration key: " + key), (Object[])new Object[0]);
        registeredTypes.put((Object)key, semiBlock);
        try {
            Constructor<? extends ItemSemiBlockBase> ctor = itemClass.getDeclaredConstructor(String.class);
            semiBlockToItems.put(semiBlock, (Object)itemClass.cast(ctor.newInstance(key)));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Log.error("Failed to register semiblock " + key + " of class " + semiBlock.getCanonicalName());
            e.printStackTrace();
        }
    }

    static ItemSemiBlockBase getItemForSemiBlock(ISemiBlock semiBlock) {
        return (ItemSemiBlockBase)semiBlockToItems.get(semiBlock.getClass());
    }

    public static Class<? extends ISemiBlock> getSemiBlockForItem(ItemSemiBlockBase item) {
        return (Class)semiBlockToItems.inverse().get((Object)item);
    }

    public static String getKeyForSemiBlock(ISemiBlock semiBlock) {
        return SemiBlockManager.getKeyForSemiBlock(semiBlock.getClass());
    }

    public static String getKeyForSemiBlock(Class<? extends ISemiBlock> semiBlock) {
        return (String)registeredTypes.inverse().get(semiBlock);
    }

    public static ISemiBlock getSemiBlockForKey(String key) {
        try {
            Class clazz = (Class)registeredTypes.get((Object)key);
            if (clazz != null) {
                return (ISemiBlock)clazz.newInstance();
            }
            Log.warning("Semi Block with id \"" + key + "\" isn't registered!");
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @SubscribeEvent
    public static void onItemRegistration(RegistryEvent.Register<Item> event) {
        for (ItemSemiBlockBase item : semiBlockToItems.values()) {
            Itemss.registerItem((IForgeRegistry<Item>)event.getRegistry(), item);
        }
    }

    @SubscribeEvent
    public void onChunkUnLoad(ChunkEvent.Unload event) {
        if (!event.getWorld().field_72995_K) {
            this.chunksMarkedForRemoval.add(event.getChunk());
        }
    }

    @SubscribeEvent
    public void onChunkSave(ChunkDataEvent.Save event) {
        Map<BlockPos, List<ISemiBlock>> map = this.semiBlocks.get(event.getChunk());
        if (map != null && map.size() > 0) {
            NBTTagList tagList = new NBTTagList();
            for (Map.Entry<BlockPos, List<ISemiBlock>> entry : map.entrySet()) {
                for (ISemiBlock semiBlock : entry.getValue()) {
                    NBTTagCompound t = new NBTTagCompound();
                    semiBlock.writeToNBT(t);
                    NBTUtil.setPos(t, (Vec3i)entry.getKey());
                    t.func_74778_a("type", SemiBlockManager.getKeyForSemiBlock(semiBlock));
                    tagList.func_74742_a((NBTBase)t);
                }
            }
            event.getData().func_74782_a("SemiBlocks", (NBTBase)tagList);
        }
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkDataEvent.Load event) {
        try {
            if (!event.getWorld().field_72995_K && event.getData().func_74764_b("SemiBlocks")) {
                PneumaticCraftRepressurized.proxy.addScheduledTask(() -> {
                    Map<BlockPos, List<ISemiBlock>> map = this.getOrCreateMap(event.getChunk());
                    map.clear();
                    NBTTagList tagList = event.getData().func_150295_c("SemiBlocks", 10);
                    for (int i = 0; i < tagList.func_74745_c(); ++i) {
                        NBTTagCompound t = tagList.func_150305_b(i);
                        ISemiBlock semiBlock = SemiBlockManager.getSemiBlockForKey(t.func_74779_i("type"));
                        if (semiBlock == null) continue;
                        semiBlock.readFromNBT(t);
                        this.addSemiBlock(event.getWorld(), NBTUtil.getPos(t), semiBlock, event.getChunk());
                    }
                }, true);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        for (ISemiBlock semiBlock : this.addingBlocks) {
            Chunk chunk2 = semiBlock.getWorld().func_175726_f(semiBlock.getPos());
            this.addPendingBlock(chunk2, semiBlock);
            chunk2.func_76630_e();
            for (EntityPlayer player : this.syncList.get(chunk2)) {
                NetworkHandler.sendTo(new PacketAddSemiBlock(semiBlock), (EntityPlayerMP)player);
                PacketDescription descPacket = semiBlock.getDescriptionPacket();
                if (descPacket == null) continue;
                NetworkHandler.sendTo(descPacket, (EntityPlayerMP)player);
            }
        }
        this.addingBlocks.clear();
        for (Chunk removingChunk : this.chunksMarkedForRemoval) {
            if (removingChunk.func_177410_o()) continue;
            this.semiBlocks.remove(removingChunk);
            this.syncList.remove(removingChunk);
        }
        this.chunksMarkedForRemoval.clear();
        HashMap<Chunk, Set> toRemove = new HashMap<Chunk, Set>();
        this.semiBlocks.forEach((chunk, posMap) -> {
            List<BlockPos> removePos = this.update((Map<BlockPos, List<ISemiBlock>>)posMap);
            if (!removePos.isEmpty()) {
                toRemove.computeIfAbsent((Chunk)chunk, c -> new HashSet()).addAll(removePos);
            }
        });
        toRemove.forEach((chunk, posSet) -> posSet.forEach(pos -> this.semiBlocks.get(chunk).remove(pos)));
        this.semiBlocks.values().removeIf(Map::isEmpty);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (this == SemiBlockManager.getServerInstance()) {
            SemiBlockManager.getClientOldInstance().onClientTick(event);
        } else {
            EntityPlayer player = PneumaticCraftRepressurized.proxy.getClientPlayer();
            if (player != null) {
                Iterator<Object> iterator = this.addingBlocks.iterator();
                while (iterator.hasNext()) {
                    ISemiBlock semiBlock = iterator.next();
                    Chunk chunk = semiBlock.getWorld().func_175726_f(semiBlock.getPos());
                    if (chunk.func_76621_g()) continue;
                    this.addPendingBlock(chunk, semiBlock);
                    iterator.remove();
                }
                iterator = this.semiBlocks.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    if (PneumaticCraftUtils.distBetweenSq(player.field_70165_t, 0.0, player.field_70161_v, ((Chunk)entry.getKey()).field_76635_g * 16 - 8, 0.0, ((Chunk)entry.getKey()).field_76647_h * 16 - 8) > 5476.0) {
                        iterator.remove();
                        continue;
                    }
                    this.update((Map)entry.getValue());
                }
            } else {
                this.semiBlocks.clear();
            }
        }
    }

    private void addPendingBlock(Chunk chunk, ISemiBlock semiBlock) {
        Map<BlockPos, List<ISemiBlock>> map = this.getOrCreateMap(chunk);
        List semiBlocksForPos = map.computeIfAbsent(semiBlock.getPos(), k -> new ArrayList());
        semiBlocksForPos.add(semiBlock);
    }

    private List<BlockPos> update(Map<BlockPos, List<ISemiBlock>> map) {
        ArrayList<BlockPos> toRemove = new ArrayList<BlockPos>();
        map.forEach((pos, semiblocks) -> {
            Iterator iter = semiblocks.iterator();
            while (iter.hasNext()) {
                ISemiBlock semiBlock = (ISemiBlock)iter.next();
                if (semiBlock.isInvalid()) {
                    iter.remove();
                    continue;
                }
                semiBlock.update();
            }
            if (semiblocks.isEmpty()) {
                toRemove.add((BlockPos)pos);
            }
        });
        return toRemove;
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.world.field_72995_K) {
            this.syncWithPlayers(event.world);
        }
    }

    private void syncWithPlayers(World world) {
        List players = world.field_73010_i;
        for (Map.Entry<Chunk, Set<EntityPlayer>> entry : this.syncList.entrySet()) {
            Chunk chunk = entry.getKey();
            if (chunk == null) continue;
            Set<EntityPlayer> syncedPlayers = entry.getValue();
            int chunkX = chunk.field_76635_g * 16 - 8;
            int chunkZ = chunk.field_76647_h * 16 - 8;
            for (EntityPlayer player : players) {
                if (chunk.func_177412_p() == world) {
                    double dist = PneumaticCraftUtils.distBetweenSq(player.field_70165_t, 0.0, player.field_70161_v, chunkX, 0.0, chunkZ);
                    if (dist < 4096.0) {
                        if (!syncedPlayers.add(player) || !this.semiBlocks.containsKey(chunk)) continue;
                        for (List<ISemiBlock> semiBlockList : this.semiBlocks.get(chunk).values()) {
                            for (ISemiBlock semiBlock : semiBlockList) {
                                if (semiBlock.isInvalid()) continue;
                                NetworkHandler.sendTo(new PacketAddSemiBlock(semiBlock), (EntityPlayerMP)player);
                                PacketDescription descPacket = semiBlock.getDescriptionPacket();
                                if (descPacket == null) continue;
                                NetworkHandler.sendTo(descPacket, (EntityPlayerMP)player);
                            }
                        }
                        continue;
                    }
                    if (!(dist > 4761.0)) continue;
                    syncedPlayers.remove(player);
                    continue;
                }
                syncedPlayers.remove(player);
            }
        }
    }

    @SubscribeEvent
    public void onInteraction(PlayerInteractEvent.RightClickBlock event) {
        ItemStack curItem = event.getEntityPlayer().func_184586_b(event.getHand());
        if (!(curItem.func_77973_b() instanceof ISemiBlockItem)) {
            return;
        }
        if (!event.getWorld().field_72995_K) {
            ISemiBlock block;
            boolean success = this.interact(event, curItem, event.getPos());
            if (!success && event.getFace() != null) {
                success = this.interact(event, curItem, event.getPos().func_177972_a(event.getFace()));
            }
            if (!success && (block = ((ISemiBlockItem)curItem.func_77973_b()).getSemiBlock(event.getWorld(), null, curItem)).getGuiID() != null) {
                event.getEntityPlayer().openGui((Object)PneumaticCraftRepressurized.instance, block.getGuiID().ordinal(), event.getWorld(), event.getPos().func_177958_n(), event.getPos().func_177956_o(), event.getPos().func_177952_p());
                success = true;
            }
            if (success) {
                event.setCanceled(true);
            }
        } else {
            event.setCancellationResult(EnumActionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    private boolean interact(PlayerInteractEvent.RightClickBlock event, ItemStack curItem, BlockPos pos) {
        ISemiBlock newBlock = ((ISemiBlockItem)curItem.func_77973_b()).getSemiBlock(event.getWorld(), pos, curItem);
        newBlock.initialize(event.getWorld(), pos);
        newBlock.prePlacement(event.getEntityPlayer(), curItem, event.getFace());
        Stream<ISemiBlock> existingSemiblocks = this.getSemiBlocks(event.getWorld(), pos);
        List collidingBlocks = existingSemiblocks.filter(s -> !s.canCoexistInSameBlock(newBlock)).collect(Collectors.toList());
        if (!collidingBlocks.isEmpty()) {
            for (ISemiBlock collidingBlock : collidingBlocks) {
                if (event.getEntityPlayer().field_71075_bZ.field_75098_d) {
                    this.removeSemiBlock(collidingBlock);
                    continue;
                }
                this.breakSemiBlock(collidingBlock, event.getEntityPlayer());
            }
            return true;
        }
        if (newBlock.canPlace(event.getFace())) {
            this.addSemiBlock(event.getWorld(), pos, newBlock);
            newBlock.onPlaced(event.getEntityPlayer(), curItem, event.getFace());
            if (!event.getEntityPlayer().field_71075_bZ.field_75098_d) {
                curItem.func_190918_g(1);
            }
            NetworkHandler.sendToAllAround(new PacketPlaySound(SoundEvents.field_187772_dn, SoundCategory.BLOCKS, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (SoundType.field_185853_f.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185853_f.func_185847_b() * 0.8f, false), event.getWorld());
            return true;
        }
        return false;
    }

    private Map<BlockPos, List<ISemiBlock>> getOrCreateMap(Chunk chunk) {
        Map<BlockPos, List<ISemiBlock>> map = this.semiBlocks.get(chunk);
        if (map == null) {
            map = new HashMap<BlockPos, List<ISemiBlock>>();
            this.semiBlocks.put(chunk, map);
            this.syncList.put(chunk, new HashSet());
        }
        return map;
    }

    void breakSemiBlock(ISemiBlock semiBlock) {
        this.breakSemiBlock(semiBlock, null);
    }

    public void breakSemiBlock(ISemiBlock semiBlock, EntityPlayer player) {
        if (!semiBlock.isInvalid()) {
            World world = semiBlock.getWorld();
            BlockPos pos = semiBlock.getPos();
            NonNullList drops = NonNullList.func_191196_a();
            semiBlock.addDrops((NonNullList<ItemStack>)drops);
            for (ItemStack stack : drops) {
                EntityItem item = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
                world.func_72838_d((Entity)item);
                if (player == null) continue;
                item.func_70100_b_(player);
            }
            this.removeSemiBlock(semiBlock);
        }
    }

    public void removeSemiBlock(ISemiBlock semiBlock) {
        Validate.notNull((Object)semiBlock);
        int index = semiBlock.getIndex();
        semiBlock.invalidate();
        World world = semiBlock.getWorld();
        BlockPos pos = semiBlock.getPos();
        Chunk chunk = world.func_175726_f(pos);
        List<ISemiBlock> currentBlocks = this.getOrCreateMap(chunk).get(pos);
        currentBlocks.forEach(s -> s.onSemiBlockRemovedFromThisPos(semiBlock));
        for (EntityPlayer player : this.syncList.get(chunk)) {
            NetworkHandler.sendTo(new PacketRemoveSemiBlock(semiBlock, index), (EntityPlayerMP)player);
        }
        MinecraftForge.EVENT_BUS.post((Event)new SemiblockEvent.BreakEvent(world, pos));
        chunk.func_76630_e();
    }

    public void addSemiBlock(World world, BlockPos pos, ISemiBlock semiBlock) {
        this.addSemiBlock(world, pos, semiBlock, world.func_175726_f(pos));
    }

    private void addSemiBlock(World world, BlockPos pos, ISemiBlock semiBlock, Chunk chunk) {
        Validate.notNull((Object)semiBlock);
        if (!registeredTypes.containsValue(semiBlock.getClass())) {
            throw new IllegalStateException("ISemiBlock \"" + semiBlock + "\" was not registered!");
        }
        semiBlock.initialize(world, pos);
        this.addingBlocks.add(semiBlock);
        MinecraftForge.EVENT_BUS.post((Event)new SemiblockEvent.PlaceEvent(world, pos));
        chunk.func_76630_e();
    }

    public <T extends ISemiBlock> T getSemiBlock(Class<T> clazz, World world, BlockPos pos) {
        return (T)((ISemiBlock)this.getSemiBlocks(clazz, world, pos).findFirst().orElse(null));
    }

    <T extends ISemiBlock> Stream<T> getSemiBlocks(Class<T> clazz, World world, BlockPos pos) {
        return StreamUtils.ofType(clazz, this.getSemiBlocks(world, pos));
    }

    public List<ISemiBlock> getSemiBlocksAsList(World world, BlockPos pos) {
        return this.getSemiBlocks(world, pos).collect(Collectors.toList());
    }

    public <T extends ISemiBlock> List<T> getSemiBlocksAsList(Class<T> clazz, World world, BlockPos pos) {
        return this.getSemiBlocks(clazz, world, pos).collect(Collectors.toList());
    }

    public Stream<ISemiBlock> getSemiBlocks(World world, BlockPos pos) {
        List<ISemiBlock> semiblocks;
        Stream<ISemiBlock> stream = null;
        Chunk chunk = world.func_175726_f(pos);
        Map<BlockPos, List<ISemiBlock>> map = this.semiBlocks.get(chunk);
        if (map != null && (semiblocks = map.get(pos)) != null) {
            stream = semiblocks.stream().filter(semiBlock -> !semiBlock.isInvalid());
        }
        Stream<ISemiBlock> addingStream = this.addingBlocks.stream().filter(semiBlock -> semiBlock.getWorld() == world && semiBlock.getPos().equals((Object)pos) && !semiBlock.isInvalid());
        if (stream == null) {
            return addingStream;
        }
        return Stream.concat(stream, addingStream);
    }

    public Stream<ISemiBlock> getSemiBlocksInArea(World world, AxisAlignedBB aabb) {
        ArrayList<Chunk> applicableChunks = new ArrayList<Chunk>();
        int minX = (int)aabb.field_72340_a;
        int minY = (int)aabb.field_72338_b;
        int minZ = (int)aabb.field_72339_c;
        int maxX = (int)aabb.field_72336_d;
        int maxY = (int)aabb.field_72337_e;
        int maxZ = (int)aabb.field_72334_f;
        for (int x = minX; x < maxX + 16; x += 16) {
            for (int z = minZ; z < maxZ + 16; z += 16) {
                Chunk chunk2 = world.func_175726_f(new BlockPos(x, 0, z));
                applicableChunks.add(chunk2);
            }
        }
        Stream<Map> chunkMaps = applicableChunks.stream().map(chunk -> this.getSemiBlocks().get(chunk)).filter(Objects::nonNull);
        Stream semiBlocksPerPos = chunkMaps.flatMap(map -> map.values().stream());
        Stream existingSemiBlocksInArea = semiBlocksPerPos.flatMap(Collection::stream);
        Stream allSemiBlocksInArea = Stream.concat(existingSemiBlocksInArea, this.addingBlocks.stream());
        return allSemiBlocksInArea.filter(s -> !s.isInvalid() && minX <= s.getPos().func_177958_n() && s.getPos().func_177958_n() <= maxX && minY <= s.getPos().func_177956_o() && s.getPos().func_177956_o() <= maxY && minZ <= s.getPos().func_177952_p() && s.getPos().func_177952_p() <= maxZ);
    }

    public Map<Chunk, Map<BlockPos, List<ISemiBlock>>> getSemiBlocks() {
        return this.semiBlocks;
    }

    public void clearAll() {
        this.semiBlocks.clear();
    }
}

