/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.handler;

import asmodeuscore.core.utils.worldengine.WE_Biome;
import asmodeuscore.core.utils.worldengine.WE_ChunkProvider;
import asmodeuscore.core.utils.worldengine.WE_WorldProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ColorBlockHandler {
    private static List<Block> blocks = new ArrayList<Block>();
    private static List<Block> leaves = new ArrayList<Block>();
    private static List<Block> water_blocks = new ArrayList<Block>();
    private static Map<Block, Integer> color_blocks = new HashMap<Block, Integer>();
    public static World world;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerBlockColourHandlers(ColorHandlerEvent.Block event) {
        BlockColors blockColors = event.getBlockColors();
        IBlockColor grassColourHandler = (state, blockAccess, pos, tintIndex) -> {
            if (blockAccess != null && pos != null) {
                WE_ChunkProvider chunk;
                if (world != null && ColorBlockHandler.world.field_73011_w instanceof WE_WorldProvider && (chunk = ((WE_WorldProvider)ColorBlockHandler.world.field_73011_w).chunk_provider) != null) {
                    return WE_Biome.getBiomeAt((WE_ChunkProvider)chunk, (long)((long)pos.func_177958_n()), (long)((long)pos.func_177952_p())).biomeBlockGrassColor;
                }
                return BiomeColorHelper.func_180286_a((IBlockAccess)blockAccess, (BlockPos)pos);
            }
            return ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
        };
        for (Block block : blocks) {
            blockColors.func_186722_a(grassColourHandler, new Block[]{block});
        }
        IBlockColor leavesColourHandler = (state, blockAccess, pos, tintIndex) -> {
            if (blockAccess != null && pos != null) {
                WE_ChunkProvider chunk;
                if (world != null && ColorBlockHandler.world.field_73011_w instanceof WE_WorldProvider && (chunk = ((WE_WorldProvider)ColorBlockHandler.world.field_73011_w).chunk_provider) != null) {
                    return WE_Biome.getBiomeAt((WE_ChunkProvider)chunk, (long)((long)pos.func_177958_n()), (long)((long)pos.func_177952_p())).biomeBlockLeavesColor;
                }
                return BiomeColorHelper.func_180287_b((IBlockAccess)blockAccess, (BlockPos)pos);
            }
            return ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
        };
        for (Block block : leaves) {
            blockColors.func_186722_a(leavesColourHandler, new Block[]{block});
        }
        for (Map.Entry<Block, Integer> entry : color_blocks.entrySet()) {
            IBlockColor colorHandler = (state, blockAccess, pos, tintIndex) -> (Integer)color_blocks.getValue();
            blockColors.func_186722_a(colorHandler, new Block[]{entry.getKey()});
        }
        IBlockColor iBlockColor = (state, blockAccess, pos, tintIndex) -> {
            if (blockAccess != null && pos != null) {
                WE_ChunkProvider chunk;
                if (world != null && ColorBlockHandler.world.field_73011_w instanceof WE_WorldProvider && (chunk = ((WE_WorldProvider)ColorBlockHandler.world.field_73011_w).chunk_provider) != null) {
                    return WE_Biome.getBiomeAt((WE_ChunkProvider)chunk, (long)((long)pos.func_177958_n()), (long)((long)pos.func_177952_p())).biomeBlockWaterColor;
                }
                return BiomeColorHelper.func_180288_c((IBlockAccess)blockAccess, (BlockPos)pos);
            }
            return ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
        };
        for (Block block : water_blocks) {
            blockColors.func_186722_a(iBlockColor, new Block[]{block});
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerItemColourHandlers(ColorHandlerEvent.Item event) {
        BlockColors blockColors = event.getBlockColors();
        ItemColors itemColors = event.getItemColors();
        IItemColor itemBlockColourHandler = (stack, tintIndex) -> {
            IBlockState state = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
            return blockColors.func_186724_a(state, null, null, tintIndex);
        };
        for (Block block : blocks) {
            itemColors.func_186731_a(itemBlockColourHandler, new Block[]{block});
        }
    }

    public static void addBlock(Block block) {
        blocks.add(block);
    }

    public static void addLeavesBlock(Block block) {
        leaves.add(block);
    }

    public static void addBlockWithColor(Block block, int color) {
        color_blocks.put(block, color);
    }

    public static void addWaterBlock(Block block) {
        water_blocks.add(block);
    }
}

