/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.config;

import ic2.core.IC2;
import ic2.core.platform.config.ConfigDefaults;
import ic2.core.platform.config.ConfigEntry;
import ic2.core.platform.config.components.IConfigCallback;
import ic2.core.platform.config.components.IConfigChecker;
import ic2.core.platform.config.components.IConfigNotify;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class IC2Config {
    Configuration config;
    ConfigDefaults defaults;
    Map<String, Number> numbers = new HashMap<String, Number>();
    Map<String, Boolean> flags = new HashMap<String, Boolean>();
    Map<String, String> text = new HashMap<String, String>();
    private Map<String, ConfigEntry> entryMap = new LinkedHashMap<String, ConfigEntry>();
    private List<ConfigEntry> afterConfigCall = new ArrayList<ConfigEntry>();
    private List<ConfigEntry> customEntries = new ArrayList<ConfigEntry>();
    private List<IConfigNotify> reloadNotifies = new ArrayList<IConfigNotify>();
    private boolean loaded = false;
    private boolean postLoad = false;

    public IC2Config(File file) {
        try {
            this.config = new Configuration(file);
        }
        catch (Exception e) {
            IC2.log.warn("Error while trying to access configuration! " + e);
        }
        this.defaults = new ConfigDefaults(this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void load() {
        if (this.config != null && !this.loaded) {
            List<ConfigEntry> entries = this.defaults.getDefaults();
            for (ConfigEntry entry : entries) {
                this.handleEntry(entry);
            }
            for (ConfigEntry entry : this.customEntries) {
                this.handleEntry(entry);
            }
            if (this.afterConfigCall.size() > 0) {
                for (ConfigEntry callEntry : this.afterConfigCall) {
                    IConfigCallback callback = callEntry.getCallback();
                    if (callback == null) continue;
                    callback.afterConfigLoaded(callEntry, this);
                }
                this.afterConfigCall.clear();
            }
            this.loaded = true;
            this.config.save();
        }
    }

    public void reload() {
        this.loaded = false;
        IC2.log.warn("IC2 Config gets Reloaded");
        this.load();
        for (IConfigNotify notify : this.reloadNotifies) {
            notify.onConfigReloaded(this);
        }
    }

    public void postLoad() {
        if (!this.postLoad) {
            this.postLoad = true;
            this.loaded = false;
            this.load();
            for (IConfigNotify notify : this.reloadNotifies) {
                notify.onConfigReloaded(this);
            }
        }
    }

    private void handleEntry(ConfigEntry entry) {
        if (entry == null) {
            return;
        }
        IConfigChecker validater = entry.getConfigChecker();
        this.entryMap.put(entry.getKey(), entry);
        if (entry.getCallback() != null) {
            this.afterConfigCall.add(entry);
        }
        switch (entry.getType()) {
            case Boolean: {
                boolean flagResult;
                boolean bl = flagResult = entry.isHiddenConfig() ? entry.getDefaultFlag() : Boolean.parseBoolean(this.config.get(entry.getCategory(), entry.getConfigKey(), entry.getDefaultFlag(), entry.getComment()).setRequiresMcRestart(entry.requireGameRestart()).setRequiresWorldRestart(entry.requireWorldRestart()).getString());
                if (validater != null) {
                    flagResult = validater.validateResult(flagResult);
                }
                this.flags.put(entry.getKey(), flagResult);
                if (entry.isHiddenConfig()) break;
                this.config.get(entry.getCategory(), entry.getConfigKey(), entry.getDefaultFlag(), entry.getComment()).set(flagResult);
                break;
            }
            case Float: {
                float floatResult;
                float f = floatResult = entry.isHiddenConfig() ? entry.getDefaultNumber().floatValue() : Float.parseFloat(this.config.get(entry.getCategory(), entry.getConfigKey(), (double)entry.getDefaultNumber().floatValue(), entry.getComment()).setRequiresMcRestart(entry.requireGameRestart()).setRequiresWorldRestart(entry.requireWorldRestart()).getString());
                if (validater != null) {
                    floatResult = validater.validateResult(Float.valueOf(floatResult)).floatValue();
                }
                this.numbers.put(entry.getKey(), Float.valueOf(floatResult));
                if (entry.isHiddenConfig()) break;
                this.config.get(entry.getCategory(), entry.getConfigKey(), (double)entry.getDefaultNumber().floatValue(), entry.getComment()).set((double)floatResult);
                break;
            }
            case Integer: {
                int intResult;
                int n = intResult = entry.isHiddenConfig() ? entry.getDefaultNumber().intValue() : Integer.parseInt(this.config.get(entry.getCategory(), entry.getConfigKey(), entry.getDefaultNumber().intValue(), entry.getComment()).setRequiresMcRestart(entry.requireGameRestart()).setRequiresWorldRestart(entry.requireWorldRestart()).getString());
                if (validater != null) {
                    intResult = validater.validateResult(intResult);
                }
                this.numbers.put(entry.getKey(), intResult);
                if (entry.isHiddenConfig()) break;
                this.config.get(entry.getCategory(), entry.getConfigKey(), entry.getDefaultNumber().intValue(), entry.getComment()).set(intResult);
                break;
            }
            case String: {
                String textResult;
                String string = textResult = entry.isHiddenConfig() ? entry.getDefaultText() : this.config.get(entry.getCategory(), entry.getConfigKey(), entry.getDefaultText(), entry.getComment()).setRequiresMcRestart(entry.requireGameRestart()).setRequiresWorldRestart(entry.requireWorldRestart()).getString();
                if (validater != null) {
                    textResult = validater.validateResult(textResult);
                }
                this.text.put(entry.getKey(), textResult);
                if (entry.isHiddenConfig()) break;
                this.config.get(entry.getCategory(), entry.getConfigKey(), entry.getDefaultText(), entry.getComment()).set(textResult);
            }
        }
    }

    public void addCustomConfig(ConfigEntry par1) {
        this.customEntries.add(par1);
    }

    public void addConfigNotify(IConfigNotify par1) {
        this.reloadNotifies.add(par1);
    }

    public String getText(String key) {
        String result = this.text.get(key);
        if (result != null) {
            return result;
        }
        return null;
    }

    public int getInt(String key) {
        Number result = this.numbers.get(key);
        if (result != null) {
            return result.intValue();
        }
        return 0;
    }

    public float getFloat(String key) {
        Number result = this.numbers.get(key);
        if (result != null) {
            return result.floatValue();
        }
        return 0.0f;
    }

    public boolean getFlag(String key) {
        Boolean result = this.flags.get(key);
        if (result != null) {
            return result;
        }
        return false;
    }

    public boolean canLoadPlugin(String id) {
        Boolean result = this.flags.get(id);
        if (result != null) {
            return result;
        }
        result = Boolean.parseBoolean(this.config.get("plugins", id, true).getString());
        this.flags.put(id, result);
        return result;
    }

    public void setValue(String key, int value) {
        ConfigEntry entry = this.entryMap.get(key);
        if (entry == null) {
            return;
        }
        IConfigChecker validater = entry.getConfigChecker();
        if (validater != null) {
            value = validater.validateResult(value);
        }
        this.config.get(entry.getCategory(), entry.getConfigKey(), entry.getDefaultNumber().intValue()).set(value);
        this.numbers.put(key, value);
        this.config.save();
    }

    public void setValue(String key, float value) {
        ConfigEntry entry = this.entryMap.get(key);
        if (entry == null) {
            return;
        }
        IConfigChecker validater = entry.getConfigChecker();
        if (validater != null) {
            value = validater.validateResult(Float.valueOf(value)).floatValue();
        }
        this.config.get(entry.getCategory(), entry.getConfigKey(), (double)entry.getDefaultNumber().floatValue()).set((double)value);
        this.numbers.put(key, Float.valueOf(value));
        this.config.save();
    }

    public void setValue(String key, boolean value) {
        ConfigEntry entry = this.entryMap.get(key);
        if (entry == null) {
            return;
        }
        IConfigChecker validater = entry.getConfigChecker();
        if (validater != null) {
            value = validater.validateResult(value);
        }
        this.config.get(entry.getCategory(), entry.getConfigKey(), entry.getDefaultFlag()).set(value);
        this.flags.put(key, value);
        this.config.save();
    }

    public void setValue(String key, String value) {
        ConfigEntry entry = this.entryMap.get(key);
        if (entry == null) {
            return;
        }
        IConfigChecker validater = entry.getConfigChecker();
        if (validater != null) {
            value = validater.validateResult(value);
        }
        this.config.get(entry.getCategory(), entry.getConfigKey(), entry.getDefaultText()).set(value);
        this.text.put(key, value);
        this.config.save();
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isPostLoading() {
        return this.postLoad;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public Set<String> getAllCategories() {
        LinkedHashSet<String> categories = new LinkedHashSet<String>();
        for (ConfigEntry entry : this.entryMap.values()) {
            if (entry.isHiddenConfig()) continue;
            categories.add(entry.getCategory());
        }
        return categories;
    }

    public Map<String, ConfigEntry> getConfigMap() {
        return new LinkedHashMap<String, ConfigEntry>(this.entryMap);
    }

    @SubscribeEvent
    public void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent evt) {
        if (evt.getModID().equalsIgnoreCase("ic2")) {
            this.reload();
        }
    }

    public static enum ConfigType {
        Boolean,
        String,
        Integer,
        Float;

    }
}

