/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.inv.inventories;

import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.management.AccessRule;
import ic2.core.item.inv.container.ContainerSlotAccessModifier;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;

public class InventorySlotAccessModifier
implements IHasGui {
    public boolean isOffHand;
    public ItemStack stack;
    public List<Integer> slots = new ArrayList<Integer>();
    public Map<Integer, AccessRule> masterRules = new HashMap<Integer, AccessRule>();
    public Map<Integer, Map<EnumFacing, AccessRule>> rules = new HashMap<Integer, Map<EnumFacing, AccessRule>>();
    public int offset = 0;
    public boolean disableRemoval;
    public boolean disableAddition;

    public InventorySlotAccessModifier(ItemStack item, EnumHand hand) {
        this.isOffHand = hand == EnumHand.OFF_HAND;
        this.stack = item;
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(item);
        this.disableRemoval = nbt.func_74767_n("Removal");
        this.disableAddition = nbt.func_74767_n("Addition");
        NBTTagList list = nbt.func_150295_c("Data", 10);
        AccessRule[] possibleRules = AccessRule.values();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            int slot = data.func_74762_e("ID");
            this.slots.add(slot);
            this.masterRules.put(slot, possibleRules[data.func_74762_e("Master")]);
            NBTTagList sides = data.func_150295_c("Rules", 7);
            EnumMap<EnumFacing, AccessRule> ruleMap = new EnumMap<EnumFacing, AccessRule>(EnumFacing.class);
            for (int x = 0; x < sides.func_74745_c(); ++x) {
                byte[] array = ((NBTTagByteArray)sides.func_179238_g(x)).func_150292_c();
                ruleMap.put(EnumFacing.field_82609_l[array[0]], possibleRules[array[1]]);
            }
            this.rules.put(slot, ruleMap);
        }
        Collections.sort(this.slots);
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerSlotAccessModifier(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !player.field_70128_L;
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }
}

