/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.entity.explosion;

import com.google.common.base.Optional;
import com.mojang.authlib.GameProfile;
import ic2.core.IC2;
import ic2.core.entity.explosion.EntityDynamite;
import ic2.core.entity.explosion.ExplosionIC2;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class EntityIC2Explosive
extends Entity {
    public DamageSource damageSource;
    public GameProfile igniter;
    public int fuse = 80;
    public float explosivePower = 4.0f;
    public float dropRate = 0.3f;
    public float damageVsEntities = 1.0f;
    public static final DataParameter<Optional<IBlockState>> renderBlock = EntityDataManager.func_187226_a(EntityDynamite.class, (DataSerializer)DataSerializers.field_187197_g);

    public EntityIC2Explosive(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.98f, 0.98f);
    }

    public EntityIC2Explosive(World worldIn, double x, double y, double z, int fuselength, float power, float rate, float damage, IBlockState block, DamageSource source) {
        this(worldIn);
        this.func_70107_b(x, y, z);
        this.func_70105_a(0.98f, 0.98f);
        float f = (float)(Math.random() * (Math.PI * 2));
        this.field_70159_w = -((float)Math.sin(f)) * 0.02f;
        this.field_70181_x = 0.2f;
        this.field_70179_y = -((float)Math.cos(f)) * 0.02f;
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.fuse = fuselength;
        this.explosivePower = power;
        this.dropRate = rate;
        this.damageVsEntities = damage;
        if (block != null) {
            this.field_70180_af.func_187227_b(renderBlock, (Object)Optional.of((Object)block));
        }
        this.damageSource = source;
        if (this.damageSource == null) {
            this.damageSource = DamageSource.func_94539_a((Explosion)new Explosion(worldIn, (Entity)this, x, y, z, power, false, false));
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(renderBlock, (Object)Optional.of((Object)Blocks.field_150346_d.func_176223_P()));
    }

    public EntityIC2Explosive setIgniter(EntityPlayer player) {
        return player == null ? this : this.setIgniter(player.func_146103_bH());
    }

    public EntityIC2Explosive setIgniter(GameProfile pro) {
        this.igniter = pro;
        return this;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70181_x -= (double)0.04f;
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= (double)0.98f;
        this.field_70181_x *= (double)0.98f;
        this.field_70179_y *= (double)0.98f;
        if (this.field_70122_E) {
            this.field_70159_w *= (double)0.7f;
            this.field_70179_y *= (double)0.7f;
            this.field_70181_x *= -0.5;
        }
        --this.fuse;
        if (this.fuse <= 0) {
            this.func_70106_y();
            if (IC2.platform.isSimulating()) {
                this.onExploding();
            }
        } else {
            this.func_70072_I();
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public void onExploding() {
        ExplosionIC2 explosion = new ExplosionIC2(this.field_70170_p, this, new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v), this.explosivePower, this.dropRate, this.damageVsEntities, this.damageSource).setIgniter(this.igniter);
        Optional state = (Optional)this.field_70180_af.func_187225_a(renderBlock);
        explosion.isBeacon = state.isPresent() && ((IBlockState)state.get()).func_177230_c() == Blocks.field_150461_bJ;
        explosion.doExplosion();
    }

    protected void func_70037_a(NBTTagCompound tagCompund) {
        this.fuse = tagCompund.func_74762_e("Fuse");
    }

    protected void func_70014_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("Fuse", this.fuse);
    }

    public float func_70047_e() {
        return 0.0f;
    }
}

