/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop.crops;

import ic2.api.crops.CropProperties;
import ic2.api.crops.ICropTile;
import ic2.core.block.crop.crops.CropCardBase;
import ic2.core.platform.registry.Ic2Items;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CropMalachite
extends CropCardBase {
    public CropMalachite() {
        super(new CropProperties(6, 2, 0, 0, 1, 0));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int state) {
        if (state == 4) {
            return this.getSprite("bc")[84];
        }
        return this.getSprite("bc")[31 + state];
    }

    @Override
    public String getDiscoveredBy() {
        return "Speiger";
    }

    @Override
    public String getId() {
        return "Malachite";
    }

    @Override
    public int getMaxSize() {
        return 4;
    }

    @Override
    public String[] getAttributes() {
        return new String[]{"Orange", "Leaves", "Metal"};
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        return Ic2Items.copperDust.func_77946_l();
    }

    @Override
    public double dropGainChance() {
        return super.dropGainChance() / 2.0;
    }

    @Override
    public int getGrowthDuration(ICropTile cropTile) {
        if (cropTile.getCurrentSize() == 3) {
            return 2000;
        }
        return 800;
    }

    @Override
    public int getSizeAfterHarvest(ICropTile cropTile) {
        return 2;
    }

    @Override
    public int getOptimalHarvestSize(ICropTile cropTile) {
        return 4;
    }

    @Override
    public boolean canGrow(ICropTile cropTile) {
        return cropTile.getCurrentSize() < 3 || cropTile.getCurrentSize() == 3 && (cropTile.isBlockBelow("oreCopper") || cropTile.isBlockBelow("blockCopper"));
    }

    @Override
    public boolean canBeHarvested(ICropTile cropTile) {
        return cropTile.getCurrentSize() == 4;
    }
}

