/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.contexts;

import me.lucko.luckperms.api.context.ContextCalculator;
import me.lucko.luckperms.api.context.MutableContextSet;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.permission.Subject;

public class WorldCalculator
implements ContextCalculator<Subject> {
    private final LuckPermsPlugin plugin;

    public WorldCalculator(LuckPermsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public @NonNull MutableContextSet giveApplicableContext(@NonNull Subject subject, @NonNull MutableContextSet accumulator) {
        CommandSource source = subject.getCommandSource().orElse(null);
        if (source == null || !(source instanceof Player)) {
            return accumulator;
        }
        Player p = (Player)source;
        String world = p.getWorld().getName().toLowerCase();
        while (!accumulator.has("world", world)) {
            accumulator.add("world", world);
            world = this.plugin.getConfiguration().get(ConfigKeys.WORLD_REWRITES).getOrDefault(world, world).toLowerCase();
        }
        return accumulator;
    }
}

