/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.verbose;

import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.api.Tristate;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.common.plugin.scheduler.SchedulerAdapter;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.utils.RepeatingTask;
import me.lucko.luckperms.common.verbose.CheckData;
import me.lucko.luckperms.common.verbose.CheckOrigin;
import me.lucko.luckperms.common.verbose.VerboseFilter;
import me.lucko.luckperms.common.verbose.VerboseListener;

public class VerboseHandler
extends RepeatingTask {
    private final Map<UUID, VerboseListener> listeners = new ConcurrentHashMap<UUID, VerboseListener>();
    private final Queue<CheckData> queue = new ConcurrentLinkedQueue<CheckData>();
    private boolean listening = false;

    public VerboseHandler(SchedulerAdapter scheduler) {
        super(scheduler, 100L, TimeUnit.MILLISECONDS);
    }

    public void offerCheckData(CheckOrigin checkOrigin, String checkTarget, ContextSet checkContext, String permission, Tristate result) {
        if (!this.listening) {
            return;
        }
        StackTraceElement[] trace = new Exception().getStackTrace();
        this.queue.offer(new CheckData(checkOrigin, checkTarget, checkContext.makeImmutable(), trace, permission, result));
    }

    public void registerListener(Sender sender, VerboseFilter filter, boolean notify) {
        this.listeners.put(sender.getUuid(), new VerboseListener(sender, filter, notify));
        this.listening = true;
    }

    public VerboseListener unregisterListener(UUID uuid) {
        this.flush();
        return this.listeners.remove(uuid);
    }

    @Override
    protected void tick() {
        this.listeners.values().removeIf(l -> !l.getNotifiedSender().isValid());
        this.flush();
        this.listening = !this.listeners.isEmpty();
    }

    public synchronized void flush() {
        CheckData e;
        while ((e = this.queue.poll()) != null) {
            for (VerboseListener listener : this.listeners.values()) {
                listener.acceptData(e);
            }
        }
    }
}

