/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation.sql.connection.file;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.Properties;
import java.util.function.Function;
import me.lucko.luckperms.common.dependencies.Dependency;
import me.lucko.luckperms.common.dependencies.classloader.IsolatedClassLoader;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.storage.implementation.sql.connection.file.FlatfileConnectionFactory;
import me.lucko.luckperms.common.storage.implementation.sql.connection.file.NonClosableConnection;

public class SQLiteConnectionFactory
extends FlatfileConnectionFactory {
    private final Method createConnectionMethod;
    private NonClosableConnection connection;

    public SQLiteConnectionFactory(LuckPermsPlugin plugin, Path file) {
        super(file);
        Path data = file.getParent().resolve("luckperms.sqlite");
        if (Files.exists(data, new LinkOption[0])) {
            try {
                Files.move(data, file, new CopyOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        IsolatedClassLoader classLoader = plugin.getDependencyManager().obtainClassLoaderWith(EnumSet.of(Dependency.SQLITE_DRIVER));
        try {
            Class<?> jdcbClass = classLoader.loadClass("org.sqlite.JDBC");
            this.createConnectionMethod = jdcbClass.getMethod("createConnection", String.class, Properties.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getImplementationName() {
        return "SQLite";
    }

    private Connection createConnection(String url) throws SQLException {
        try {
            return (Connection)this.createConnectionMethod.invoke(null, url, new Properties());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        Connection connection;
        if ((this.connection == null || this.connection.isClosed()) && (connection = this.createConnection("jdbc:sqlite:" + this.file.toString())) != null) {
            this.connection = NonClosableConnection.wrap(connection);
        }
        if (this.connection == null) {
            throw new SQLException("Unable to get a connection.");
        }
        return this.connection;
    }

    @Override
    public void shutdown() throws Exception {
        if (this.connection != null) {
            this.connection.shutdown();
        }
    }

    @Override
    public Function<String, String> getStatementProcessor() {
        return s -> s.replace("'", "");
    }
}

