/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.node.utils;

import java.util.Objects;
import java.util.Optional;
import me.lucko.luckperms.api.LocalizedNode;
import me.lucko.luckperms.api.Tristate;

public final class InheritanceInfo {
    private final Tristate result;
    private final String location;

    public static InheritanceInfo of(LocalizedNode node) {
        Objects.requireNonNull(node, "node");
        return new InheritanceInfo(node.getTristate(), node.getLocation());
    }

    public static InheritanceInfo empty() {
        return new InheritanceInfo(Tristate.UNDEFINED, null);
    }

    private InheritanceInfo(Tristate result, String location) {
        this.result = result;
        this.location = location;
    }

    public Optional<String> getLocation() {
        return Optional.ofNullable(this.location);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InheritanceInfo)) {
            return false;
        }
        InheritanceInfo other = (InheritanceInfo)o;
        return this.result == other.result && this.getLocation().equals(other.getLocation());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.result.hashCode();
        result = result * 59 + this.getLocation().hashCode();
        return result;
    }

    public String toString() {
        return "InheritanceInfo(result=" + (Object)((Object)this.result) + ", location=" + this.getLocation() + ")";
    }

    public Tristate getResult() {
        return this.result;
    }
}

