/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.metastacking;

import java.util.Map;
import java.util.Optional;
import me.lucko.luckperms.api.ChatMetaType;
import me.lucko.luckperms.api.LocalizedNode;
import me.lucko.luckperms.api.metastacking.MetaStackElement;
import me.lucko.luckperms.common.metastacking.MetaStack;
import me.lucko.luckperms.common.metastacking.MetaStackEntry;

final class SimpleMetaStackEntry
implements MetaStackEntry {
    private final MetaStack parentStack;
    private final MetaStackElement element;
    private final ChatMetaType type;
    private Map.Entry<Integer, String> current = null;

    public SimpleMetaStackEntry(MetaStack parentStack, MetaStackElement element, ChatMetaType type) {
        this.parentStack = parentStack;
        this.element = element;
        this.type = type;
    }

    @Override
    public Optional<Map.Entry<Integer, String>> getCurrentValue() {
        return Optional.ofNullable(this.current);
    }

    @Override
    public boolean accumulateNode(LocalizedNode node) {
        if (this.element.shouldAccumulate(node, this.type, this.current)) {
            this.current = this.type.getEntry(node);
            return true;
        }
        return false;
    }

    @Override
    public MetaStack getParentStack() {
        return this.parentStack;
    }

    @Override
    public MetaStackElement getElement() {
        return this.element;
    }

    public ChatMetaType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleMetaStackEntry)) {
            return false;
        }
        SimpleMetaStackEntry that = (SimpleMetaStackEntry)o;
        return this.getElement().equals(that.getElement()) && this.getType() == that.getType() && this.current.equals(that.current);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getElement().hashCode();
        result = result * 59 + this.getType().hashCode();
        result = result * 59 + this.current.hashCode();
        return result;
    }

    public String toString() {
        return "SimpleMetaStackEntry(parentStack=" + this.getParentStack() + ", element=" + this.getElement() + ", type=" + (Object)((Object)this.getType()) + ", current=" + this.current + ")";
    }
}

