/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.graph;

import com.google.common.collect.AbstractIterator;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import me.lucko.luckperms.common.graph.Graph;
import me.lucko.luckperms.common.graph.TraversalAlgorithm;

public final class GraphTraversers {
    public static <N> Iterable<N> traverseUsing(TraversalAlgorithm algorithm, Graph<N> graph, N startNode) {
        Objects.requireNonNull(algorithm, "algorithm");
        switch (algorithm) {
            case BREADTH_FIRST: {
                return GraphTraversers.breadthFirst(graph, startNode);
            }
            case DEPTH_FIRST_PRE_ORDER: {
                return GraphTraversers.depthFirstPreOrder(graph, startNode);
            }
            case DEPTH_FIRST_POST_ORDER: {
                return GraphTraversers.depthFirstPostOrder(graph, startNode);
            }
        }
        throw new AssertionError();
    }

    public static <N> Iterable<N> breadthFirst(Graph<N> graph, N startNode) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(startNode, "startNode");
        return () -> new BreadthFirstIterator<Object>(graph, startNode);
    }

    public static <N> Iterable<N> depthFirstPreOrder(Graph<N> graph, N startNode) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(startNode, "startNode");
        return () -> new DepthFirstIterator<Object>(graph, startNode, Order.PRE_ORDER);
    }

    public static <N> Iterable<N> depthFirstPostOrder(Graph<N> graph, N startNode) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(startNode, "startNode");
        return () -> new DepthFirstIterator<Object>(graph, startNode, Order.POST_ORDER);
    }

    private GraphTraversers() {
    }

    private static enum Order {
        PRE_ORDER,
        POST_ORDER;

    }

    private static final class DepthFirstIterator<N>
    extends AbstractIterator<N> {
        private final Graph<N> graph;
        private final Deque<NodeAndSuccessors> stack = new ArrayDeque<NodeAndSuccessors>();
        private final Set<N> visited = new HashSet<N>();
        private final Order order;

        DepthFirstIterator(Graph<N> graph, N root, Order order) {
            this.graph = graph;
            this.stack.push(this.withSuccessors(root));
            this.order = order;
        }

        protected N computeNext() {
            NodeAndSuccessors node;
            boolean produceNode;
            do {
                if (this.stack.isEmpty()) {
                    return (N)this.endOfData();
                }
                node = this.stack.getFirst();
                boolean firstVisit = this.visited.add(node.node);
                boolean lastVisit = !node.successorIterator.hasNext();
                boolean bl = produceNode = firstVisit && this.order == Order.PRE_ORDER || lastVisit && this.order == Order.POST_ORDER;
                if (lastVisit) {
                    this.stack.pop();
                    continue;
                }
                Object successor = node.successorIterator.next();
                if (this.visited.contains(successor)) continue;
                this.stack.push(this.withSuccessors(successor));
            } while (!produceNode);
            return node.node;
        }

        NodeAndSuccessors withSuccessors(N node) {
            return new NodeAndSuccessors(node, this.graph.successors(node));
        }

        private final class NodeAndSuccessors {
            final N node;
            final Iterator<? extends N> successorIterator;

            NodeAndSuccessors(N node, Iterable<? extends N> successors) {
                this.node = node;
                this.successorIterator = successors.iterator();
            }
        }
    }

    private static final class BreadthFirstIterator<N>
    implements Iterator<N> {
        private final Graph<N> graph;
        private final Queue<N> queue = new ArrayDeque<N>();
        private final Set<N> visited = new HashSet<N>();

        BreadthFirstIterator(Graph<N> graph, N root) {
            this.graph = graph;
            this.queue.add(root);
            this.visited.add(root);
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public N next() {
            N current = this.queue.remove();
            for (N neighbor : this.graph.successors(current)) {
                if (!this.visited.add(neighbor)) continue;
                this.queue.add(neighbor);
            }
            return current;
        }
    }
}

