/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.track;

import java.util.List;
import me.lucko.luckperms.api.LogEntry;
import me.lucko.luckperms.api.event.cause.DeletionCause;
import me.lucko.luckperms.common.actionlog.ExtendedLogEntry;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SingleCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.command.tabcomplete.TabCompletions;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.utils.Predicates;

public class DeleteTrack
extends SingleCommand {
    public DeleteTrack(LocaleManager locale) {
        super(CommandSpec.DELETE_TRACK.localize(locale), "DeleteTrack", CommandPermission.DELETE_TRACK, Predicates.not(1));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, List<String> args, String label) {
        if (args.isEmpty()) {
            this.sendUsage(sender, label);
            return CommandResult.INVALID_ARGS;
        }
        String trackName = args.get(0).toLowerCase();
        Track track = plugin.getStorage().loadTrack(trackName).join().orElse(null);
        if (track == null) {
            Message.TRACK_LOAD_ERROR.send(sender, new Object[0]);
            return CommandResult.LOADING_ERROR;
        }
        try {
            plugin.getStorage().deleteTrack(track, DeletionCause.COMMAND).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            Message.DELETE_ERROR.send(sender, track.getName());
            return CommandResult.FAILURE;
        }
        Message.DELETE_SUCCESS.send(sender, trackName);
        ExtendedLogEntry.build().actor(sender).actedName(trackName).type(LogEntry.Type.TRACK).action("delete").build().submit(plugin, sender);
        return CommandResult.SUCCESS;
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, List<String> args) {
        return TabCompleter.create().at(0, TabCompletions.tracks(plugin)).complete(args);
    }
}

