/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.assignments;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.script.ScriptEngine;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.api.StandardNodeEquality;
import me.lucko.luckperms.api.Tristate;
import me.lucko.luckperms.common.model.NodeMapType;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.node.factory.LegacyNodeFactory;
import me.lucko.luckperms.common.utils.Scripting;

public class AssignmentExpression {
    private final List<Token> expression;

    public static AssignmentExpression compile(String expression) {
        if (expression == null) {
            return null;
        }
        return new AssignmentExpression(expression);
    }

    private AssignmentExpression(String expression) {
        this.expression = AssignmentExpression.generateExpression(expression);
    }

    public boolean eval(PermissionHolder holder, Tristate tristate) throws IllegalArgumentException {
        ScriptEngine engine = Scripting.getScriptEngine();
        if (engine == null) {
            throw new NullPointerException("script engine");
        }
        Predicate<Node> checker = node -> holder.hasPermission(NodeMapType.ENDURING, (Node)node, StandardNodeEquality.IGNORE_VALUE_OR_IF_TEMPORARY) == tristate;
        String exp = this.expression.stream().map(t -> t.forExpression(checker)).collect(Collectors.joining()).replace("&", "&&").replace("|", "||");
        try {
            String result = engine.eval(exp).toString();
            if (!result.equals("true") && !result.equals("false")) {
                throw new IllegalArgumentException();
            }
            return Boolean.parseBoolean(result);
        }
        catch (Throwable t2) {
            throw new IllegalArgumentException(exp, t2);
        }
    }

    private static List<Token> generateExpression(String input) {
        ImmutableList.Builder exp = ImmutableList.builder();
        while (true) {
            int start = input.indexOf("<");
            int end = input.indexOf(">");
            if (start == -1 || end == -1) break;
            if (start != 0) {
                StringToken before = new StringToken(input.substring(0, start));
                exp.add((Object)before);
            }
            String match = input.substring(start, end + 1);
            String matchContent = match.substring(1, match.length() - 1);
            PermissionToken permission = new PermissionToken(matchContent);
            exp.add((Object)permission);
            input = input.substring(end + 1);
        }
        if (!input.isEmpty()) {
            exp.add((Object)new StringToken(input));
        }
        return exp.build();
    }

    private static final class PermissionToken
    implements Token {
        private final String permission;
        private final Node node;

        private PermissionToken(String permission) {
            this.permission = permission;
            this.node = LegacyNodeFactory.fromLegacyString(permission, true);
        }

        @Override
        public String forExpression(Predicate<Node> checker) {
            return Boolean.toString(checker.test(this.node));
        }

        public String toString() {
            return "<" + this.permission + ">";
        }
    }

    private static final class StringToken
    implements Token {
        private final String string;

        private StringToken(String string) {
            this.string = string;
        }

        @Override
        public String forExpression(Predicate<Node> checker) {
            return this.string;
        }

        public String toString() {
            return this.string;
        }
    }

    private static interface Token {
        public String forExpression(Predicate<Node> var1);
    }
}

