/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.actionlog;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.UUID;
import me.lucko.luckperms.api.LogEntry;
import me.lucko.luckperms.common.actionlog.ExtendedLogEntry;

public final class LogEntryJsonSerializer {
    public static JsonObject serialize(LogEntry logEntry) {
        JsonObject data = new JsonObject();
        data.add("actor", (JsonElement)new JsonPrimitive(logEntry.getActor().toString()));
        data.add("actorName", (JsonElement)new JsonPrimitive(logEntry.getActorName()));
        data.add("type", (JsonElement)new JsonPrimitive(logEntry.getType().name()));
        if (logEntry.getActed().isPresent()) {
            data.add("acted", (JsonElement)new JsonPrimitive(logEntry.getActed().get().toString()));
        }
        data.add("actedName", (JsonElement)new JsonPrimitive(logEntry.getActedName()));
        data.add("action", (JsonElement)new JsonPrimitive(logEntry.getAction()));
        return data;
    }

    public static ExtendedLogEntry deserialize(JsonElement element) {
        Preconditions.checkArgument((boolean)element.isJsonObject());
        JsonObject data = element.getAsJsonObject();
        ExtendedLogEntry.Builder builder = ExtendedLogEntry.build();
        builder.actor(UUID.fromString(data.get("actor").getAsString()));
        builder.actorName(data.get("actorName").getAsString());
        builder.type(LogEntry.Type.valueOf(data.get("type").getAsString()));
        if (data.has("acted")) {
            builder.actor(UUID.fromString(data.get("acted").getAsString()));
        }
        builder.actedName(data.get("actedName").getAsString());
        builder.action(data.get("action").getAsString());
        return builder.build();
    }

    private LogEntryJsonSerializer() {
    }
}

