/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.infos;

import pregenerator.base.api.misc.IRenderHelper;
import pregenerator.base.api.network.IReadableBuffer;
import pregenerator.base.api.network.IWriteableBuffer;
import pregenerator.impl.client.infos.InfoEntry;
import pregenerator.impl.storage.PregenTask;

public class GenerationType
extends InfoEntry {
    int type;

    public GenerationType() {
        this.register();
    }

    @Override
    public String getName() {
        return "Processing Type";
    }

    @Override
    public void write(IWriteableBuffer buf) {
        PregenTask task = this.getProcessor().getTask();
        buf.writeByte(task != null ? task.getPostType() : 0);
    }

    @Override
    public void read(IReadableBuffer buf) {
        this.type = buf.readByte();
    }

    @Override
    public int currentValue() {
        return 0;
    }

    @Override
    public int maxValue() {
        return 0;
    }

    @Override
    public void render(int x, int y, float progress, int width, IRenderHelper helper) {
        int wid = width - 25;
        helper.renderText(x - wid, y, width, "Gen-Type: " + this.getType());
    }

    private String getType() {
        switch (this.type) {
            case 1: {
                return "Terrain & Post Processing";
            }
            case 2: {
                return "Post Processing Only";
            }
            case 3: {
                return "Terrain & Blocking Post";
            }
            case 4: {
                return "Retrogen";
            }
        }
        return "Terrain Only";
    }
}

