/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util.helpers;

import ic2.api.classic.util.IWorldTickCallback;
import ic2.core.IC2;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class ChunkUpdater {
    static Map<World, Map<ChunkPos, ChunkMap>> chunkMaps = new HashMap<World, Map<ChunkPos, ChunkMap>>();

    public static void onWorldUnloaded(World world) {
        Map<ChunkPos, ChunkMap> map = chunkMaps.remove(world);
        if (map == null) {
            return;
        }
        for (ChunkMap value : map.values()) {
            value.clear();
        }
    }

    public static void onChunkUnload(Chunk chunk) {
        Map<ChunkPos, ChunkMap> chunks = chunkMaps.get(chunk.func_177412_p());
        if (chunks == null) {
            return;
        }
        if (chunks.isEmpty()) {
            chunkMaps.remove(chunk.func_177412_p());
            return;
        }
        ChunkMap map = chunks.remove(new ChunkPos(chunk.field_76635_g, chunk.field_76647_h));
        if (chunks.isEmpty()) {
            chunkMaps.remove(chunk.func_177412_p());
        }
        if (map != null) {
            map.clear();
        }
    }

    public static void onChunkUnWatched(Chunk chunk) {
        Map<ChunkPos, ChunkMap> chunks = chunkMaps.get(chunk.func_177412_p());
        if (chunks == null || chunks.isEmpty()) {
            return;
        }
        ChunkMap map = chunks.remove(new ChunkPos(chunk.field_76635_g, chunk.field_76647_h));
        if (chunks.isEmpty()) {
            return;
        }
        chunk.func_177427_f(true);
    }

    public static void addWatcher(World world, BlockPos pos) {
        ChunkMap chunk;
        Map<ChunkPos, ChunkMap> chunks = chunkMaps.get(world);
        if (chunks == null) {
            chunks = new LinkedHashMap<ChunkPos, ChunkMap>();
            chunkMaps.put(world, chunks);
            IC2.callbacks.addCallback(world, new ChunkTicker(), 600);
        }
        if ((chunk = chunks.get(new ChunkPos(pos))) == null) {
            chunk = new ChunkMap();
            chunks.put(new ChunkPos(pos), chunk);
        }
        chunk.add(pos);
    }

    public static void removeWatcher(World world, BlockPos pos) {
        Map<ChunkPos, ChunkMap> chunks = chunkMaps.get(world);
        if (chunks == null) {
            return;
        }
        if (chunks.isEmpty()) {
            chunkMaps.remove(world);
            return;
        }
        ChunkMap map = chunks.get(new ChunkPos(pos));
        if (map == null) {
            return;
        }
        map.remove(pos);
        if (map.isEmpty()) {
            chunks.remove(new ChunkPos(pos));
            if (chunks.isEmpty()) {
                chunkMaps.remove(world);
            }
        }
    }

    public static class ChunkTicker
    implements IWorldTickCallback {
        @Override
        public ActionResult<Integer> tickCallback(World world) {
            try {
                Map<ChunkPos, ChunkMap> map = chunkMaps.get(world);
                if (map != null) {
                    Iterator<Map.Entry<ChunkPos, ChunkMap>> iter = map.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry<ChunkPos, ChunkMap> entry = iter.next();
                        if (entry.getValue().isEmpty()) {
                            iter.remove();
                            continue;
                        }
                        ChunkPos chunk = entry.getKey();
                        world.func_72964_e(chunk.field_77276_a, chunk.field_77275_b).func_177427_f(true);
                    }
                    return new ActionResult(EnumActionResult.PASS, (Object)500);
                }
            }
            catch (Exception e) {
                return new ActionResult(EnumActionResult.FAIL, (Object)0);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)0);
        }
    }

    public static class ChunkMap {
        protected Set<BlockPos> loadedTiles = new HashSet<BlockPos>();

        public void add(BlockPos pos) {
            this.loadedTiles.add(pos);
        }

        public void remove(BlockPos pos) {
            this.loadedTiles.remove(pos);
        }

        public boolean isEmpty() {
            return this.loadedTiles.isEmpty();
        }

        public void clear() {
            this.loadedTiles.clear();
        }
    }
}

