/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network.packets.server;

import ic2.api.classic.network.ICustomNetworkTileEventListener;
import ic2.api.classic.network.INetworkFieldData;
import ic2.api.classic.network.adv.NetworkField;
import ic2.core.IC2;
import ic2.core.network.NetworkManager;
import ic2.core.network.buffers.InputBuffer;
import ic2.core.network.buffers.OutputBuffer;
import ic2.core.network.packets.IC2Packet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileCustomEventPacket
extends IC2Packet {
    String id;
    INetworkFieldData data;
    int dimID;
    BlockPos pos;

    public TileCustomEventPacket() {
    }

    public TileCustomEventPacket(TileEntity par1, String id, INetworkFieldData data) {
        this.dimID = par1.func_145831_w().field_73011_w.getDimension();
        this.pos = par1.func_174877_v();
        this.id = id;
        this.data = data;
    }

    @Override
    public void read(ByteBuf par1) {
        InputBuffer buffer = new InputBuffer(par1);
        this.dimID = buffer.readInt();
        this.pos = BlockPos.func_177969_a((long)buffer.readLong());
        this.id = buffer.readString(NetworkField.BitLevel.Bit16);
        try {
            Class<? extends INetworkFieldData> clz = NetworkManager.idToClass.get(this.id);
            if (clz != null) {
                this.data = clz.newInstance();
                InputBuffer subBuffer = new InputBuffer(buffer.getSubBuffer());
                this.data.read(subBuffer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void write(ByteBuf par1) {
        OutputBuffer buffer = new OutputBuffer(par1);
        buffer.writeInt(this.dimID);
        buffer.writeLong(this.pos.func_177986_g());
        buffer.writeString(this.id, NetworkField.BitLevel.Bit16);
        OutputBuffer subBuffer = new OutputBuffer(Unpooled.buffer());
        this.data.write(subBuffer);
        buffer.writeBytes(subBuffer.getBuf().array());
    }

    @Override
    public void handlePacket(EntityPlayer par1) {
        World world = IC2.platform.getWorld(this.dimID);
        if (world == null) {
            throw new RuntimeException("Packet Has been sended wrong");
        }
        TileEntity tile = world.func_175625_s(this.pos);
        if (tile == null) {
            return;
        }
        if (this.data == null || !(tile instanceof ICustomNetworkTileEventListener)) {
            throw new RuntimeException("Packet contains Incorrect Data: " + this.data);
        }
        ((ICustomNetworkTileEventListener)tile).onNetworkEvent(par1, this.data);
    }
}

