/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop;

import ic2.api.classic.crops.ClassicBaseSeed;
import ic2.api.classic.crops.ClassicCrops;
import ic2.api.classic.crops.IClassicCropTile;
import ic2.api.classic.crops.ICropProvider;
import ic2.api.classic.crops.ICropSoil;
import ic2.api.classic.crops.IFarmland;
import ic2.api.classic.crops.ISeedCrop;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.tile.IInfoTile;
import ic2.api.crops.BaseSeed;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.api.item.ElectricItem;
import ic2.api.network.INetworkDataProvider;
import ic2.api.network.INetworkUpdateListener;
import ic2.core.IC2;
import ic2.core.block.base.util.info.CropProbeComponent;
import ic2.core.block.crop.Ic2Crops;
import ic2.core.block.crop.misc.CropDifficulty;
import ic2.core.block.crop.renders.CropEntry;
import ic2.core.block.crop.renders.CropQuadStorage;
import ic2.core.item.crop.ItemCropSeed;
import ic2.core.item.inv.inventories.CropAnalyzerInventory;
import ic2.core.network.NetworkManager;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.util.helpers.ChunkUpdater;
import ic2.core.util.helpers.FilteredList;
import ic2.core.util.helpers.ToolHelper;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityCrop
extends TileEntity
implements IClassicCropTile,
IInfoTile,
ITickable,
INetworkDataProvider,
INetworkUpdateListener {
    @NetworkField(index=0)
    public CropCard card;
    @NetworkField(index=1)
    public boolean upgraded;
    @NetworkField(index=2)
    public int size;
    @NetworkField(index=3)
    public NBTTagCompound customNBT = new NBTTagCompound();
    public static int tickRate = 256;
    public int ticker = 0;
    public boolean dirty = false;
    public boolean created = false;
    public UUID breeder;
    public byte humidity = (byte)-1;
    public byte nutrients = (byte)-1;
    public byte airQuality = (byte)-1;
    public byte scanLevel = 0;
    public IFarmland land = null;
    private int growthPoints = 0;
    private int nutrientStorage = 0;
    private int waterStorage = 0;
    private int exStorage = 0;
    private byte statGrowth = 0;
    private byte statGain = 0;
    private byte statResistance = 0;
    private boolean overgrowth = false;
    private boolean restored = false;
    private int overgrowthTicks = 0;
    private int backup = 200;
    boolean manual;
    static Map<Block, List<Block>> blockStorage = new HashMap<Block, List<Block>>();
    @SideOnly(value=Side.CLIENT)
    protected CropQuadStorage storage;
    private List<IInfoTile.InfoComponent> components = new ArrayList<IInfoTile.InfoComponent>();
    private final boolean isServer;
    private boolean loaded = false;
    public CropDifficulty difficulty = new CropDifficulty();

    public TileEntityCrop() {
        this.isServer = IC2.platform.isSimulating();
        for (CropProbeComponent.CropInfoType com : CropProbeComponent.CropInfoType.values()) {
            this.components.add(new CropProbeComponent(this, com));
        }
    }

    public NetworkManager getNetwork() {
        return IC2.network.get(this.isServer);
    }

    public boolean isSimulating() {
        return this.isServer;
    }

    public boolean isRendering() {
        return !this.isServer;
    }

    @Override
    public List<IInfoTile.InfoComponent> getComponents() {
        return this.components;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.card = ClassicCrops.instance.getCropCard(new ResourceLocation(nbt.func_74779_i("CropID")));
        this.size = nbt.func_74771_c("Size");
        this.statGrowth = nbt.func_74771_c("statGrowth");
        this.statGain = nbt.func_74771_c("statGain");
        this.statResistance = nbt.func_74771_c("statResistance");
        this.customNBT = nbt.func_74775_l("customData");
        this.growthPoints = nbt.func_74762_e("growthPoints");
        this.nutrientStorage = nbt.func_74762_e("nutrientStorage");
        this.waterStorage = nbt.func_74762_e("waterStorage");
        this.upgraded = nbt.func_74767_n("upgraded");
        this.scanLevel = nbt.func_74771_c("scanLevel");
        this.overgrowth = nbt.func_74767_n("Overgrowth");
        this.restored = nbt.func_74767_n("Restored");
        this.breeder = null;
        if (nbt.func_186855_b("Breeder")) {
            this.breeder = nbt.func_186857_a("Breeder");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74778_a("CropID", new ResourceLocation(this.card == null ? "empty" : this.card.getOwner() + ":" + this.card.getId()).toString());
        nbt.func_74768_a("Size", this.size);
        nbt.func_74774_a("statGrowth", this.statGrowth);
        nbt.func_74774_a("statGain", this.statGain);
        nbt.func_74774_a("statResistance", this.statResistance);
        nbt.func_74782_a("customData", (NBTBase)this.customNBT);
        nbt.func_74768_a("growthPoints", this.growthPoints);
        nbt.func_74768_a("nutrientStorage", this.nutrientStorage);
        nbt.func_74768_a("waterStorage", this.waterStorage);
        nbt.func_74757_a("upgraded", this.upgraded);
        nbt.func_74774_a("scanLevel", this.scanLevel);
        nbt.func_74757_a("Overgrowth", this.overgrowth);
        nbt.func_74757_a("Restored", this.restored);
        if (this.breeder != null) {
            nbt.func_186854_a("Breeder", this.breeder);
        }
        return nbt;
    }

    public void func_73660_a() {
        boolean server = this.isSimulating();
        if (!this.created && server) {
            this.getNetwork().requestInitialData(this);
            this.created = true;
            this.backup = 0;
        }
        if (server && (!this.overgrowth || this.overgrowth && (this.overgrowthTicks > 0 || this.restored))) {
            ++this.ticker;
            if (this.ticker % tickRate == 0 || this.overgrowthTicks > 0) {
                if (this.overgrowthTicks > 0) {
                    --this.overgrowthTicks;
                }
                this.tick();
            }
        }
        if (this.dirty) {
            this.dirty = false;
            if (server) {
                this.getNetwork().requestInitialData(this);
            } else {
                this.storage = null;
                this.getCurrentEntry();
                this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
                this.field_145850_b.func_175679_n(this.func_174877_v());
            }
        }
        if (this.backup > 0) {
            --this.backup;
            if (this.backup <= 0) {
                this.getNetwork().requestInitialData(this);
            }
        }
    }

    void tick() {
        int tickrate;
        int n = tickrate = this.overgrowth && !this.restored ? 8 : 256;
        if (this.ticker % (tickrate * 4) == 0) {
            this.humidity = this.updateHumidity();
        }
        if (this.ticker % (tickrate * 3) == 0) {
            this.nutrients = this.updateNutrients();
        }
        if (this.ticker % (tickrate * 2) == 0) {
            this.airQuality = this.updateAirQuality();
        }
        if (!(this.card != null || this.upgraded && this.attemptCrossing())) {
            if (IC2.random.nextInt(this.difficulty.getWeedChance()) != 0 || this.hasEx()) {
                if (this.exStorage > 0 && IC2.random.nextInt(10) == 0) {
                    --this.exStorage;
                }
                return;
            }
            this.reset();
            this.card = Crops.weed;
            this.size = 1;
        }
        this.card.tick(this);
        if (this.card == null) {
            return;
        }
        if (this.card.canGrow(this) && this.size < this.card.getMaxSize()) {
            this.growthPoints += this.calculateGrowth();
            if (this.card != null && this.growthPoints >= this.card.getGrowthDuration(this)) {
                this.growthPoints = 0;
                boolean canPerform = this.card.isRedstoneSignalEmitter(this);
                ++this.size;
                if (canPerform != this.card.isRedstoneSignalEmitter(this)) {
                    this.updateNeighbors(true);
                }
                this.dirty = true;
                if (this.size >= this.card.getMaxSize() && this.scanLevel == 0) {
                    this.scanLevel = 1;
                }
            } else if (this.card == null) {
                return;
            }
        } else if (this.size > this.card.getMaxSize()) {
            this.size = this.card.getMaxSize();
            this.dirty = true;
        }
        if (this.nutrientStorage > 0) {
            --this.nutrientStorage;
        }
        if (this.waterStorage > 0) {
            --this.waterStorage;
        }
        if (this.card.isWeed(this) && IC2.random.nextInt(this.difficulty.getWeedChance()) - this.statGrowth <= 2) {
            this.generateWeed();
        }
    }

    public int calculateGrowth() {
        int have;
        int base = 3 + IC2.random.nextInt(7) + this.statGrowth;
        int need = (this.card.getProperties().getTier() - 1) * 4 + this.statGrowth + this.statGain + this.statResistance;
        if (need < 0) {
            need = 0;
        }
        if ((have = this.card.getWeightInfluences(this, this.getTerrainHumidity(), this.getTerrainNutrients(), this.getTerrainAirQuality()) * 5) >= need) {
            base = base * (100 + (have - need)) / 100;
        } else {
            int neg = (need - have) * 4;
            if (neg > 100 && IC2.random.nextInt(32) > this.statResistance) {
                this.reset();
                base = 0;
            } else if ((base = base * (100 - neg) / 100) < 0) {
                base = 0;
            }
        }
        return this.difficulty.getCropGrowth(base);
    }

    public boolean attemptCrossing() {
        EntityPlayerMP player;
        int i;
        if (IC2.random.nextInt(3) != 0) {
            return false;
        }
        ArrayList<ICropProvider> attempt = new ArrayList<ICropProvider>();
        int cropsThere = 0;
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            cropsThere += this.askCropJoinCross(this.func_174877_v().func_177972_a(facing), attempt);
        }
        if (attempt.size() < 2) {
            if (attempt.size() > 0 && attempt.size() == cropsThere) {
                this.copyCrop((ICropProvider)attempt.get(0));
                return true;
            }
            return false;
        }
        FilteredList<CropCard> cards = new FilteredList<CropCard>(Crops.instance.getCrops());
        cards.remove(Crops.weed);
        int[] ratios = new int[cards.size()];
        int total = 0;
        for (i = 0; i < cards.size(); ++i) {
            CropCard card = (CropCard)cards.get(i);
            if (!card.canGrow(this)) continue;
            for (int j = 0; j < attempt.size(); ++j) {
                int chance = TileEntityCrop.calculateRatioFor(card, ((ICropProvider)attempt.get(j)).getCrop());
                int n = i;
                ratios[n] = ratios[n] + chance;
                total += chance;
            }
        }
        total = IC2.random.nextInt(total);
        for (i = 0; i < ratios.length; ++i) {
            if (ratios[i] > 0 && ratios[i] > total) {
                total = i;
                break;
            }
            total -= ratios[i];
        }
        if (total >= cards.size()) {
            return false;
        }
        this.upgraded = false;
        this.card = (CropCard)cards.get(total);
        this.dirty = true;
        this.size = 1;
        this.statGrowth = 0;
        this.statResistance = 0;
        this.statGain = 0;
        this.customNBT = new NBTTagCompound();
        byte[] value = this.difficulty.getCropStats(attempt);
        this.statGrowth = value[0];
        this.statResistance = value[1];
        this.statGain = value[2];
        if (!(this.breeder == null || this.overgrowth && IC2.random.nextInt(256) != 0 || (player = IC2.platform.getServer().func_184103_al().func_177451_a(this.breeder)) == null)) {
            IC2.achievements.issueStat((EntityPlayer)player, "cropBreeder");
        }
        return true;
    }

    public void copyCrop(ICropProvider prov) {
        this.upgraded = false;
        this.card = prov.getCrop();
        this.dirty = true;
        this.size = 1;
        this.statGrowth = (byte)MathHelper.func_76125_a((int)prov.getStatGrowth(), (int)0, (int)31);
        this.statResistance = (byte)MathHelper.func_76125_a((int)prov.getStatResistance(), (int)0, (int)31);
        this.statGain = (byte)MathHelper.func_76125_a((int)prov.getStatGain(), (int)0, (int)31);
        this.scanLevel = (byte)prov.getScanningLevel();
    }

    public static int calculateRatioFor(CropCard a, CropCard b) {
        int i;
        if (a == b) {
            return 500;
        }
        int value = 0;
        int[] aStats = a.getProperties().getAllProperties();
        int[] bStats = b.getProperties().getAllProperties();
        for (i = 0; i < 5; ++i) {
            int c = Math.abs(aStats[i] - bStats[i]);
            switch (c) {
                default: {
                    --value;
                }
                case 0: {
                    value += 2;
                }
                case 1: {
                    ++value;
                }
                case 2: 
            }
        }
        for (i = 0; i < a.getAttributes().length; ++i) {
            for (int j = 0; j < b.getAttributes().length; ++j) {
                if (!a.getAttributes()[i].equalsIgnoreCase(b.getAttributes()[j])) continue;
                value += 5;
            }
        }
        if (b.getProperties().getTier() < a.getProperties().getTier() - 1) {
            value -= 2 * (a.getProperties().getTier() - b.getProperties().getTier());
        }
        if (b.getProperties().getTier() - 3 > a.getProperties().getTier()) {
            value -= b.getProperties().getTier() - a.getProperties().getTier();
        }
        if (value < 0) {
            value = 0;
        }
        return value;
    }

    public int askCropJoinCross(BlockPos pos, List<ICropProvider> list) {
        if (!this.field_145850_b.func_175667_e(pos)) {
            return 0;
        }
        TileEntity tile = this.field_145850_b.func_175625_s(pos);
        if (!(tile instanceof ICropProvider)) {
            return 0;
        }
        ICropProvider other = (ICropProvider)tile;
        CropCard card = other.getCrop();
        if (card == null) {
            return 0;
        }
        if (!card.canGrow(this) || !other.canCrossBreed()) {
            return 0;
        }
        int base = this.difficulty.getBreedingDifficulty();
        if (other.getStatGrowth() >= 16) {
            ++base;
        }
        if (other.getStatGrowth() >= 30) {
            ++base;
        }
        if (other.getStatResistance() >= 28) {
            base += 27 - other.getStatResistance();
        }
        if (base >= IC2.random.nextInt(20)) {
            list.add(other);
        }
        return 1;
    }

    public void generateWeed() {
        Block block;
        TileEntity tile;
        BlockPos offset = this.func_174877_v();
        boolean stop = false;
        EnumFacing last = null;
        while (!stop) {
            stop = last != null;
            int rand = IC2.random.nextInt(4);
            EnumFacing dir = last;
            if (dir == (last = EnumFacing.field_176754_o[stop ? 3 - rand : rand]) || dir == last.func_176734_d()) break;
            offset = offset.func_177972_a(last);
        }
        if ((tile = this.field_145850_b.func_175625_s(offset)) instanceof TileEntityCrop) {
            TileEntityCrop crop = (TileEntityCrop)tile;
            if (crop.card == null || !crop.card.isWeed(crop) && IC2.random.nextInt(32) >= crop.statResistance && !crop.hasEx()) {
                byte newGrowth = this.statGrowth;
                if (crop.statGrowth > newGrowth) {
                    newGrowth = crop.statGrowth;
                }
                if (newGrowth < 31 && IC2.random.nextBoolean()) {
                    newGrowth = (byte)(newGrowth + 1);
                }
                crop.reset();
                crop.card = Ic2Crops.weed;
                crop.setCurrentSize(1);
                crop.statGrowth = newGrowth;
                if (this.overgrowth) {
                    crop.overgrowth = true;
                    crop.overgrowthTicks = 1000;
                }
            }
        } else if (this.field_145850_b.func_175623_d(offset) && ((block = this.field_145850_b.func_180495_p(offset.func_177977_b()).func_177230_c()) == Blocks.field_150346_d || block == Blocks.field_150349_c || block == Blocks.field_150458_ak)) {
            this.field_145850_b.func_175656_a(offset.func_177977_b(), Blocks.field_150349_c.func_176223_P());
            this.field_145850_b.func_175656_a(offset, Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.GRASS));
        }
    }

    public boolean hasEx() {
        if (this.exStorage > 0) {
            this.exStorage -= 5;
            return true;
        }
        return false;
    }

    @Override
    public List<String> getNetworkedFields() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("card");
        list.add("size");
        list.add("upgraded");
        list.add("customNBT");
        return list;
    }

    @Override
    public void onNetworkUpdate(String field) {
        this.dirty = true;
        this.backup = 0;
        this.land = null;
    }

    @Override
    public CropCard getCrop() {
        return this.card;
    }

    @Override
    public void setCrop(CropCard cropCard) {
        this.card = cropCard;
        this.getNetwork().updateTileEntityField(this, "card");
    }

    @Override
    public int getCurrentSize() {
        return this.size;
    }

    @Override
    public void setCurrentSize(int newSize) {
        this.size = newSize;
        this.getNetwork().updateTileEntityField(this, "size");
    }

    @Override
    public int getStatGrowth() {
        return this.statGrowth;
    }

    @Override
    public void setStatGrowth(int growth) {
        this.statGrowth = (byte)growth;
    }

    @Override
    public int getStatGain() {
        return this.statGain;
    }

    @Override
    public void setStatGain(int gain) {
        this.statGain = (byte)gain;
    }

    @Override
    public int getStatResistance() {
        return this.statResistance;
    }

    @Override
    public void setStatResistance(int resistance) {
        this.statResistance = (byte)resistance;
    }

    @Override
    public int getStorageNutrients() {
        return this.nutrientStorage;
    }

    @Override
    public void setStorageNutrients(int storageNutrient) {
        this.nutrientStorage = storageNutrient;
    }

    @Override
    public int getStorageWater() {
        return this.waterStorage;
    }

    @Override
    public void setStorageWater(int storageWater) {
        this.waterStorage = storageWater;
    }

    @Override
    public int getStorageWeedEX() {
        return this.exStorage;
    }

    @Override
    public void setStorageWeedEX(int storageWeedEX) {
        this.exStorage = storageWeedEX;
    }

    @Override
    public int getScanLevel() {
        return this.scanLevel;
    }

    @Override
    public int getScanningLevel() {
        return this.scanLevel;
    }

    @Override
    public void setScanLevel(int scan) {
        this.scanLevel = (byte)scan;
    }

    @Override
    public int getGrowthPoints() {
        return this.growthPoints;
    }

    @Override
    public void setGrowthPoints(int points) {
        this.growthPoints = points;
    }

    @Override
    public boolean isCrossingBase() {
        return this.upgraded;
    }

    @Override
    public void setCrossingBase(boolean crossingBase) {
        this.upgraded = crossingBase;
        this.getNetwork().updateTileEntityField(this, "upgraded");
    }

    @Override
    public NBTTagCompound getCustomData() {
        return this.customNBT;
    }

    @Override
    public int getTerrainHumidity() {
        if (this.humidity == -1) {
            this.humidity = this.updateHumidity();
        }
        return this.humidity;
    }

    public byte updateHumidity() {
        ICropSoil soil;
        int value = ClassicCrops.instance.getHumidityBiomeBonus(this.field_145850_b.func_180494_b(this.func_174877_v()));
        value += this.getFarmland().getHumidity(this.field_145850_b, this.func_174877_v().func_177977_b());
        for (int i = 2; i < 5 && (soil = ClassicCrops.instance.getSoil(this.field_145850_b.func_180495_p(this.func_174877_v().func_177979_c(i)))) != null; ++i) {
            value += soil.getHumidityEffect(this.func_145831_w(), this.func_174877_v().func_177979_c(i));
        }
        if (this.waterStorage >= 5) {
            value += 2;
        }
        return (byte)MathHelper.func_76125_a((int)(value += (this.waterStorage + 24) / 25), (int)0, (int)20);
    }

    @Override
    public int getTerrainNutrients() {
        if (this.nutrients == -1) {
            this.nutrients = this.updateNutrients();
        }
        return this.nutrients;
    }

    public byte updateNutrients() {
        ICropSoil soil;
        int value = ClassicCrops.instance.getNutrientBiomeBonus(this.field_145850_b.func_180494_b(this.func_174877_v()));
        value += this.getFarmland().getNutrients(this.field_145850_b, this.func_174877_v().func_177977_b());
        for (int i = 2; i < 5 && (soil = ClassicCrops.instance.getSoil(this.field_145850_b.func_180495_p(this.func_174877_v().func_177979_c(i)))) != null; ++i) {
            value += soil.getNutrientEffect(this.func_145831_w(), this.func_174877_v().func_177979_c(i));
        }
        return (byte)MathHelper.func_76125_a((int)(value += (this.nutrientStorage + 19) / 20), (int)0, (int)20);
    }

    @Override
    public int getTerrainAirQuality() {
        if (this.airQuality == -1) {
            this.airQuality = this.updateAirQuality();
        }
        return this.airQuality;
    }

    public byte updateAirQuality() {
        BlockPos pos = this.func_174877_v();
        int value = 0;
        int height = (pos.func_177956_o() - 64) / 15;
        if (height < 0) {
            height = 0;
        }
        if (height > 5) {
            height = 5;
        }
        value += height;
        int fresh = 9;
        for (int x = pos.func_177958_n() - 1; x < pos.func_177958_n() + 1 && fresh > 0; ++x) {
            for (int z = pos.func_177952_p() - 1; z < pos.func_177952_p() + 1 && fresh > 0; ++z) {
                BlockPos target = new BlockPos(x, pos.func_177956_o(), z);
                if (!this.field_145850_b.func_175677_d(target, false) && !(this.field_145850_b.func_175625_s(target) instanceof TileEntityCrop)) continue;
                --fresh;
            }
        }
        value += fresh / 2;
        if (this.field_145850_b.func_175710_j(pos.func_177984_a())) {
            value += 2;
        }
        if (value > 10) {
            value = 10;
        }
        return (byte)value;
    }

    @Override
    public BlockPos getLocation() {
        return this.func_174877_v();
    }

    @Override
    public BlockPos getPosition() {
        return this.func_174877_v();
    }

    @Override
    public World getWorldObj() {
        return this.field_145850_b;
    }

    @Override
    public int getLightLevel() {
        return this.func_145831_w().func_175671_l(this.func_174877_v());
    }

    public void calcTrampling() {
        if (!this.isSimulating()) {
            return;
        }
        if (IC2.random.nextInt(100) == 0 && IC2.random.nextInt(40) > this.statResistance) {
            this.reset();
            if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177977_b()).func_177230_c() == Blocks.field_150458_ak) {
                this.field_145850_b.func_175656_a(this.func_174877_v().func_177977_b(), Blocks.field_150346_d.func_176223_P());
            }
        }
    }

    @Override
    public boolean pick() {
        int i;
        if (this.card == null) {
            return false;
        }
        boolean bonus = this.card.canBeHarvested(this);
        float firstChance = this.card.dropSeedChance(this);
        for (int i2 = 0; i2 < this.statResistance; ++i2) {
            firstChance *= 1.1f;
        }
        int drop = 0;
        if (bonus) {
            if (IC2.random.nextFloat() <= (firstChance + 1.0f) * 0.8f) {
                ++drop;
            }
            float chance = this.card.dropSeedChance(this) + (float)this.statGrowth / 100.0f;
            if (!this.manual) {
                chance *= 0.8f;
            }
            for (i = 23; i < this.statGain; ++i) {
                chance *= 0.95f;
            }
            if (IC2.random.nextFloat() <= chance) {
                ++drop;
            }
        } else if (IC2.random.nextFloat() <= firstChance * 1.5f) {
            ++drop;
        }
        ItemStack[] result = new ItemStack[drop];
        for (i = 0; i < drop; ++i) {
            result[i] = this.card.getSeeds(this);
        }
        this.reset();
        if (this.isSimulating() && result.length > 0) {
            for (i = 0; i < result.length; ++i) {
                if (result[i].func_77973_b() != Ic2Items.cropSeed.func_77973_b()) {
                    result[i].func_77982_d(null);
                }
                StackUtil.dropAsEntity(this.func_145831_w(), this.func_174877_v(), result[i]);
            }
        }
        return true;
    }

    @Override
    public boolean performManualHarvest() {
        this.manual = true;
        List<ItemStack> list = this.performHarvest();
        this.manual = false;
        if (list == null || list.isEmpty()) {
            return false;
        }
        if (this.isRendering()) {
            return true;
        }
        for (ItemStack stack : list) {
            StackUtil.dropAsEntity(this.func_145831_w(), this.func_174877_v(), stack);
        }
        return true;
    }

    @Override
    public List<ItemStack> performHarvest() {
        if (this.card == null || !this.card.canBeHarvested(this)) {
            return null;
        }
        double chance = this.card.dropGainChance();
        for (int i = 0; i < this.statGain; ++i) {
            chance *= this.manual ? 1.1 : 1.03;
        }
        chance -= IC2.random.nextDouble();
        int drops = 0;
        while (chance > 0.0) {
            ++drops;
            chance -= IC2.random.nextDouble();
        }
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        ISeedCrop seed = this.card instanceof ISeedCrop ? (ISeedCrop)((Object)this.card) : null;
        boolean dropSeed = seed == null ? false : seed.doDropSeeds(this);
        for (int i = 0; i < drops; ++i) {
            ItemStack[] result;
            ItemStack[] itemStackArray;
            if (dropSeed) {
                ItemStack[] itemStackArray2 = new ItemStack[1];
                itemStackArray = itemStackArray2;
                itemStackArray2[0] = seed.getSeed(this);
            } else {
                itemStackArray = result = this.card.getGains(this);
            }
            if (result == null || result.length <= 0) continue;
            for (int x = 0; x < result.length; ++x) {
                ItemStack entry = result[x];
                if (IC2.random.nextInt(100) <= this.statGain) {
                    entry.func_190917_f(1);
                }
                results.add(entry.func_77946_l());
            }
        }
        boolean canPerform = this.card.isRedstoneSignalEmitter(this);
        this.size = this.card.getSizeAfterHarvest(this);
        if (canPerform != this.card.isRedstoneSignalEmitter(this)) {
            this.updateNeighbors(true);
        }
        this.dirty = true;
        return results;
    }

    @Override
    public void reset() {
        this.card = null;
        this.size = 0;
        this.customNBT = new NBTTagCompound();
        this.dirty = true;
        this.statGain = 0;
        this.statResistance = 0;
        this.statGrowth = 0;
        this.nutrients = (byte)-1;
        this.airQuality = (byte)-1;
        this.humidity = (byte)-1;
        this.growthPoints = 0;
        this.upgraded = false;
        this.scanLevel = 0;
        this.updateNeighbors(true);
    }

    @Override
    public void updateState() {
        this.dirty = true;
    }

    public void updateNeighbors(boolean needSelf) {
        if (needSelf) {
            this.field_145850_b.func_190524_a(this.func_174877_v(), this.func_145838_q(), this.func_174877_v());
        }
        for (EnumFacing side : EnumFacing.field_82609_l) {
            BlockPos newPos = this.func_174877_v().func_177972_a(side);
            if (!this.field_145850_b.func_175667_e(newPos)) continue;
            this.field_145850_b.func_190524_a(newPos, this.func_145838_q(), this.func_174877_v());
        }
    }

    @Override
    public boolean isBlockBelow(Block block) {
        int max;
        List<Block> list = this.getOreDict(block);
        int n = max = this.card == null ? 4 : this.card.getRootsLength(this);
        if (max < 4) {
            max = 4;
        }
        for (int i = 1; i < max; ++i) {
            BlockPos pos = this.func_174877_v().func_177979_c(i);
            if (this.field_145850_b.func_175623_d(pos) || !list.contains(this.field_145850_b.func_180495_p(pos).func_177230_c())) continue;
            return true;
        }
        return false;
    }

    public List<Block> getOreDict(Block par1) {
        if (blockStorage.containsKey(par1)) {
            return blockStorage.get(par1);
        }
        ItemStack item = new ItemStack(par1);
        FilteredList<Block> results = new FilteredList<Block>();
        int[] ints = OreDictionary.getOreIDs((ItemStack)item);
        if (ints != null && ints.length > 0) {
            Block block;
            boolean anyMatch = false;
            block0: for (int id : ints) {
                if (anyMatch) break;
                for (ItemStack cu : OreDictionary.getOres((String)OreDictionary.getOreName((int)id))) {
                    if (cu.func_190926_b() || (block = Block.func_149634_a((Item)cu.func_77973_b())) != par1) continue;
                    anyMatch = true;
                    continue block0;
                }
            }
            if (anyMatch) {
                for (int id : ints) {
                    for (ItemStack cu : OreDictionary.getOres((String)OreDictionary.getOreName((int)id))) {
                        if (cu.func_190926_b() || (block = Block.func_149634_a((Item)cu.func_77973_b())) == Blocks.field_150350_a) continue;
                        ((ArrayList)results).add(block);
                    }
                }
            } else {
                ((ArrayList)results).add(par1);
            }
        } else {
            ((ArrayList)results).add(par1);
        }
        if (!blockStorage.containsKey(par1)) {
            blockStorage.put(par1, results);
        }
        return results;
    }

    @Override
    public boolean isBlockBelow(String oreDictionaryName) {
        int max;
        NonNullList list = OreDictionary.getOres((String)oreDictionaryName);
        if (list.isEmpty()) {
            return false;
        }
        int n = max = this.card == null ? 4 : this.card.getRootsLength(this);
        if (max < 4) {
            max = 4;
        }
        for (int i = 1; i < max; ++i) {
            BlockPos down = this.func_174877_v().func_177979_c(i);
            if (this.field_145850_b.func_175623_d(down)) continue;
            IBlockState state = this.field_145850_b.func_180495_p(down);
            ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
            for (ItemStack item : list) {
                if (item.func_77973_b() != stack.func_77973_b() || item.func_77960_j() != Short.MAX_VALUE && item.func_77960_j() != stack.func_77960_j()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ItemStack generateSeeds(CropCard crop, int growth, int gain, int resistance, int scan) {
        return ItemCropSeed.generateItemStack(crop, growth, gain, resistance, scan);
    }

    @Override
    public IFarmland getFarmland() {
        if (this.land == null) {
            this.land = ClassicCrops.instance.getFarmland(this.field_145850_b.func_180495_p(this.func_174877_v().func_177977_b()));
        }
        return this.land;
    }

    public void onNeighbourChange() {
        this.land = null;
        this.getFarmland();
        if (this.card == null) {
            return;
        }
        this.card.onNeighbourChange(this);
    }

    public void onBlockDestroyed() {
        if (this.card == null) {
            return;
        }
        this.card.onBlockDestroyed(this);
    }

    public int getEmittdLight() {
        if (this.card == null) {
            return 0;
        }
        return this.card.getEmittedLight(this);
    }

    public boolean onRightClick(EntityPlayer player, EnumHand hand) {
        if (IC2.platform.isRendering()) {
            return true;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b()) {
            if (this.card == null) {
                if (!this.upgraded && StackUtil.isStackEqual(stack, Ic2Items.cropStick)) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    this.upgraded = true;
                    this.dirty = true;
                    this.breeder = player.func_110124_au();
                    return true;
                }
                if (this.applyBaseSeed(stack, player, hand)) {
                    return true;
                }
            }
            if (!this.overgrowth && StackUtil.isStackEqual(stack, Ic2Items.overgrowthFertilizer)) {
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                IC2.achievements.issueStat(player, "overgrowthFertilierUsed");
                this.overgrowth = true;
                this.overgrowthTicks = 6000;
                return true;
            }
            if (this.overgrowth && this.overgrowthTicks <= 0 && !this.restored && StackUtil.isStackEqual(stack, Ic2Items.reviveFertilizer)) {
                this.restored = true;
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                IC2.achievements.issueStat(player, "restoringFertilizerUsed");
                return true;
            }
            if (stack.func_77973_b() == Ic2Items.cropAnalyzer.func_77973_b()) {
                if (this.isSimulating()) {
                    if (player.func_70093_af()) {
                        if (this.scanLevel >= 4 || this.card == null) {
                            IC2.platform.messagePlayer(player, Ic2InfoLang.cropMaxScan);
                        } else if (this.scanLevel < 4 && ElectricItem.manager.use(stack, CropAnalyzerInventory.neededEnergy[this.scanLevel], (EntityLivingBase)player)) {
                            this.scanLevel = (byte)(this.scanLevel + 1);
                            IC2.platform.messagePlayer(player, Ic2InfoLang.cropScanIncrease, this.scanLevel);
                        } else {
                            IC2.platform.messagePlayer(player, Ic2InfoLang.cropScanIncreaseFailed);
                        }
                    } else if (this.card == null || this.size <= 0 || this.scanLevel < 1 && this.size < this.card.getMaxSize()) {
                        IC2.platform.messagePlayer(player, Ic2InfoLang.cropUnknown, TextFormatting.WHITE);
                        IC2.platform.messagePlayer(player, Ic2InfoLang.cropNutrient, this.nutrientStorage, 100, TextFormatting.DARK_GREEN);
                        IC2.platform.messagePlayer(player, Ic2InfoLang.cropWater, this.waterStorage, 200, TextFormatting.BLUE);
                        IC2.platform.messagePlayer(player, Ic2InfoLang.cropWeedEx, this.exStorage, 150, TextFormatting.RED);
                        IC2.platform.messagePlayer(player, Ic2InfoLang.cropNutrientPoints, this.getTerrainNutrients(), TextFormatting.DARK_GREEN);
                        IC2.platform.messagePlayer(player, Ic2InfoLang.cropHumidityPoints, this.getTerrainHumidity(), TextFormatting.GREEN);
                        IC2.platform.messagePlayer(player, Ic2InfoLang.cropAirPoints, this.getTerrainAirQuality(), TextFormatting.BLUE);
                    } else {
                        IC2.platform.messagePlayer(player, Ic2InfoLang.cropName, new TextComponentTranslation(this.card.getUnlocalizedName(), new Object[0]), this.card.getDiscoveredBy(), TextFormatting.WHITE);
                        IC2.platform.messagePlayer(player, Ic2InfoLang.cropSize, this.size, this.card.getMaxSize(), TextFormatting.GREEN);
                        IC2.platform.messagePlayer(player, Ic2InfoLang.cropNutrient, this.nutrientStorage, 200, TextFormatting.DARK_GREEN);
                        IC2.platform.messagePlayer(player, Ic2InfoLang.cropWater, this.waterStorage, 100, TextFormatting.BLUE);
                        IC2.platform.messagePlayer(player, Ic2InfoLang.cropWeedEx, this.exStorage, 150, TextFormatting.RED);
                        IC2.platform.messagePlayer(player, Ic2InfoLang.cropGrowthPoints, this.growthPoints, this.card.getGrowthDuration(this), TextFormatting.GREEN);
                        IC2.platform.messagePlayer(player, Ic2InfoLang.cropNutrientPoints, this.getTerrainNutrients(), TextFormatting.DARK_GREEN);
                        IC2.platform.messagePlayer(player, Ic2InfoLang.cropHumidityPoints, this.getTerrainHumidity(), TextFormatting.GREEN);
                        IC2.platform.messagePlayer(player, Ic2InfoLang.cropAirPoints, this.getTerrainAirQuality(), TextFormatting.BLUE);
                        IC2.platform.messagePlayer(player, Ic2InfoLang.cropGrowStat, this.getStatGrowth(), TextFormatting.GREEN);
                        IC2.platform.messagePlayer(player, Ic2InfoLang.cropGainStat, this.getStatGain(), TextFormatting.YELLOW);
                        IC2.platform.messagePlayer(player, Ic2InfoLang.cropResistanceStat, this.getStatResistance(), TextFormatting.BLUE);
                    }
                }
                return true;
            }
            if (stack.func_77973_b() == Items.field_151131_as || StackUtil.isStackEqual(stack, Ic2Items.waterCell)) {
                if (this.waterStorage < 10) {
                    this.waterStorage = 10;
                }
                return stack.func_77973_b() == Items.field_151131_as;
            }
            if (stack.func_77973_b() == Items.field_151014_N || stack.func_77973_b() == Items.field_151081_bc || stack.func_77973_b() == Items.field_151080_bb) {
                if (this.nutrientStorage <= 50) {
                    this.nutrientStorage += 25;
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    return true;
                }
                return false;
            }
            if (StackUtil.isStackEqual(stack, new ItemStack(Items.field_151100_aR, 1, 15)) || StackUtil.isStackEqual(stack, Ic2Items.fertilizer)) {
                if (this.applyFertilizer(true)) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    return true;
                }
            } else {
                if (stack.func_77973_b() == Ic2Items.hydrationCell.func_77973_b()) {
                    return this.applyManualHydration(stack, player, hand);
                }
                if (stack.func_77973_b() == Ic2Items.weedEx.func_77973_b() && this.applyWeedEx(true)) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_77972_a(1, (EntityLivingBase)player);
                    }
                    return true;
                }
            }
        }
        return this.card != null && this.card.onRightClick(this, player);
    }

    public boolean applyWeedEx(boolean manual) {
        boolean trigger;
        if (this.exStorage >= 100 && manual || this.exStorage >= 150) {
            return false;
        }
        this.exStorage += 50;
        boolean bl = trigger = this.field_145850_b.field_73012_v.nextInt(3) == 0;
        if (manual) {
            boolean bl2 = trigger = this.field_145850_b.field_73012_v.nextInt(5) == 0;
        }
        if (this.card != null && this.exStorage >= 75 && trigger) {
            switch (this.field_145850_b.field_73012_v.nextInt(5)) {
                case 0: {
                    if (this.statGrowth > 0) {
                        this.statGrowth = (byte)(this.statGrowth - 1);
                    }
                }
                case 1: {
                    if (this.statGain <= 0) break;
                    this.statGain = (byte)(this.statGain - 1);
                }
            }
            if (this.statResistance > 0) {
                this.statResistance = (byte)(this.statResistance - 1);
            }
        }
        return true;
    }

    public boolean applyManualHydration(ItemStack stack, EntityPlayer entity, EnumHand hand) {
        if (this.waterStorage >= 200) {
            return false;
        }
        int apply = 200 - this.waterStorage;
        int free = ToolHelper.getFreeDamage(stack);
        if (apply > free) {
            apply = free;
        }
        ToolHelper.damageItem(stack, apply, (EntityLivingBase)entity);
        if (ToolHelper.getFreeDamage(stack) <= 0) {
            stack.func_190918_g(1);
        }
        this.waterStorage += apply;
        this.humidity = (byte)-1;
        return true;
    }

    public boolean applyAutomatedHyrdation(ItemStack stack) {
        if (this.waterStorage >= 180) {
            return false;
        }
        int apply = 180 - this.waterStorage;
        int free = ToolHelper.getFreeDamage(stack);
        if (apply > free) {
            apply = free + 1;
        }
        if (ToolHelper.damageItem(stack, apply, null)) {
            stack.func_190918_g(1);
        }
        this.waterStorage += apply;
        return true;
    }

    public boolean applyFertilizer(boolean manual) {
        if (this.nutrientStorage > 100) {
            return false;
        }
        this.nutrientStorage += manual ? 100 : 90;
        if (manual) {
            this.nutrients = (byte)-1;
        }
        return true;
    }

    private boolean applyBaseSeed(ItemStack stack, EntityPlayer player, EnumHand hand) {
        ClassicBaseSeed seed = ClassicCrops.instance.getClassicBaseSeed(stack);
        if (seed != null) {
            if (stack.func_190916_E() < seed.stackSize) {
                IC2.platform.messagePlayer(player, Ic2Lang.toLittleItems);
                return false;
            }
            if (this.tryPlantSeed(seed, 1)) {
                if (!player.field_71075_bZ.field_75098_d) {
                    if (stack.func_77973_b().hasContainerItem(stack)) {
                        stack = stack.func_77973_b().getContainerItem(stack);
                    } else {
                        stack.func_190918_g(seed.stackSize);
                    }
                }
                return true;
            }
            IC2.platform.messagePlayer(player, Ic2Lang.cantPlantHere);
        }
        return false;
    }

    public boolean tryPlantSeed(BaseSeed seed, int scan) {
        if (this.card != null || seed.crop == null || seed.crop == Crops.weed || this.upgraded) {
            return false;
        }
        if (!seed.crop.canGrow(this)) {
            return false;
        }
        this.reset();
        this.card = seed.crop;
        this.size = seed.size;
        this.statGrowth = (byte)MathHelper.func_76125_a((int)seed.statGrowth, (int)0, (int)31);
        this.statGain = (byte)MathHelper.func_76125_a((int)seed.statGain, (int)0, (int)31);
        this.statResistance = (byte)MathHelper.func_76125_a((int)seed.statResistance, (int)0, (int)31);
        this.scanLevel = (byte)scan;
        this.dirty = true;
        return true;
    }

    public boolean onLeftClick(EntityPlayer player) {
        if (this.card != null) {
            return this.card.onLeftClick(this, player);
        }
        if (this.upgraded) {
            this.upgraded = false;
            this.dirty = true;
            if (this.isSimulating()) {
                StackUtil.dropAsEntity(this.func_145831_w(), this.func_174877_v(), Ic2Items.cropStick.func_77946_l());
            }
        }
        return false;
    }

    public int getRedstone() {
        if (this.card == null || !this.card.isRedstoneSignalEmitter(this)) {
            return 0;
        }
        return this.card.getEmittedRedstoneSignal(this);
    }

    @SideOnly(value=Side.CLIENT)
    public CropQuadStorage getCurrentEntry() {
        if (this.storage == null) {
            this.storage = Ic2Crops.instance.getStorage(this.getEntry());
        }
        return this.storage;
    }

    private CropEntry getEntry() {
        if (this.card == null) {
            return new CropEntry(null, this.upgraded ? 1 : 0);
        }
        return new CropEntry(this.card, this.size);
    }

    public void onEntityColide(Entity entity) {
        if (this.card == null) {
            return;
        }
        if (this.card.onEntityCollision(this, entity)) {
            this.calcTrampling();
        }
    }

    @Override
    public boolean canCrossBreed() {
        if (this.card == null) {
            return false;
        }
        return this.card.canCross(this);
    }

    public World func_145831_w() {
        return this.getWorldObj();
    }

    public void onLoaded() {
        if (this.isRendering()) {
            this.getNetwork().requestInitialData(this);
        } else {
            ChunkUpdater.addWatcher(this.func_145831_w(), this.func_174877_v());
        }
        this.loaded = true;
    }

    public void onUnloaded() {
        this.loaded = false;
        if (this.isSimulating()) {
            ChunkUpdater.removeWatcher(this.func_145831_w(), this.func_174877_v());
        }
    }

    public void func_145843_s() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.func_145843_s();
    }

    public void onChunkUnload() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.onChunkUnload();
    }

    public void onLoad() {
        if (!this.loaded) {
            this.onLoaded();
        }
    }
}

