/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.tileentity.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class GateAccessData {
    static final String GATEACCESSLIST = "gateaccesslist";
    public static final String ADDRESS = "address";
    private static final String IACCESS = "iaccess";
    private static final String OACCESS = "oaccess";
    private String address;
    private boolean iaccess;
    private boolean oaccess;

    public GateAccessData(String address, boolean iaccess, boolean oaccess) {
        this.address = address;
        this.iaccess = iaccess;
        this.oaccess = oaccess;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public boolean hasIncomingAccess() {
        return this.iaccess;
    }

    public void setIncomingAccess(boolean value) {
        this.iaccess = value;
    }

    public boolean hasOutgoingAccess() {
        return this.oaccess;
    }

    public void setOutgoingAccess(boolean value) {
        this.oaccess = value;
    }

    public static void updateAddress(NBTTagCompound compound, String address, boolean iaccess, boolean oaccess, int command) {
        Preconditions.checkNotNull((Object)compound);
        ArrayList<GateAccessData> gateAccessData = new ArrayList<GateAccessData>();
        NBTTagList list = compound.func_150295_c(GATEACCESSLIST, 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound gateCompound = list.func_150305_b(i);
            String compoundEntryAddress = gateCompound.func_74779_i(ADDRESS);
            if (!compoundEntryAddress.equalsIgnoreCase(address)) continue;
            gateCompound.func_74778_a(ADDRESS, address);
            gateCompound.func_74757_a(IACCESS, iaccess);
            gateCompound.func_74757_a(OACCESS, oaccess);
        }
        if (command == 1) {
            gateAccessData.add(new GateAccessData(address, iaccess, oaccess));
        }
        GateAccessData.writeAddresses(compound, gateAccessData);
    }

    public static List<GateAccessData> getGateAccessList(NBTTagCompound compound) {
        Preconditions.checkNotNull((Object)compound);
        if (!compound.func_74764_b(GATEACCESSLIST)) {
            // empty if block
        }
        ArrayList<GateAccessData> gateAccessData = new ArrayList<GateAccessData>();
        NBTTagList list = compound.func_150295_c(GATEACCESSLIST, 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound addressCompound = list.func_150305_b(i);
            String address = addressCompound.func_74779_i(ADDRESS);
            boolean iaccess = addressCompound.func_74767_n(IACCESS);
            boolean oaccess = addressCompound.func_74767_n(OACCESS);
            gateAccessData.add(new GateAccessData(address, iaccess, oaccess));
        }
        return gateAccessData;
    }

    public static NBTTagCompound writeAddresses(NBTTagCompound compound, List<GateAccessData> gateAccessData) {
        Preconditions.checkNotNull((Object)compound);
        Preconditions.checkNotNull(gateAccessData);
        if (gateAccessData.size() == 0) {
            ArrayList arrayList = Lists.newArrayList();
        }
        if (gateAccessData.size() >= 0) {
            NBTTagList list = new NBTTagList();
            for (GateAccessData data : gateAccessData) {
                NBTTagCompound addressCompound = new NBTTagCompound();
                addressCompound.func_74778_a(ADDRESS, data.getAddress());
                addressCompound.func_74757_a(IACCESS, data.hasIncomingAccess());
                addressCompound.func_74757_a(OACCESS, data.hasOutgoingAccess());
                list.func_74742_a((NBTBase)addressCompound);
            }
            compound.func_74782_a(GATEACCESSLIST, (NBTBase)list);
        }
        return compound;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GateAccessData that = (GateAccessData)o;
        return Objects.equals(this.address, that.address);
    }

    public int hashCode() {
        return Objects.hash(this.address);
    }
}

