/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autosave.handlers.java.util;

import info.loenwind.autosave.Registry;
import info.loenwind.autosave.exceptions.NoHandlerFoundException;
import info.loenwind.autosave.handlers.util.HandleGenericType;
import info.loenwind.autosave.util.NBTAction;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public abstract class HandleMap<T extends Map>
extends HandleGenericType<T> {
    protected HandleMap(Class<? extends T> clazz) throws NoHandlerFoundException {
        this(clazz, Registry.GLOBAL_REGISTRY, new Type[0]);
    }

    protected HandleMap(Class<? extends T> clazz, Registry registry, Type ... types) throws NoHandlerFoundException {
        super(clazz, registry, types);
    }

    @Override
    public boolean store(Registry registry, Set<NBTAction> phase, NBTTagCompound nbt, Type type, String name, T object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        NBTTagList tag = new NBTTagList();
        for (Map.Entry e : object.entrySet()) {
            NBTTagCompound etag = new NBTTagCompound();
            Object key = e.getKey();
            if (key != null) {
                this.storeRecursive(0, registry, phase, etag, "key", key);
            } else {
                etag.func_74757_a("key-", true);
            }
            Object val = e.getValue();
            if (val != null) {
                this.storeRecursive(1, registry, phase, etag, "val", val);
            } else {
                etag.func_74757_a("val-", true);
            }
            tag.func_74742_a((NBTBase)etag);
        }
        nbt.func_74782_a(name, (NBTBase)tag);
        return true;
    }

    @Override
    @Nullable
    public T read(Registry registry, Set<NBTAction> phase, NBTTagCompound nbt, Type type, String name, @Nullable T object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        if (nbt.func_74764_b(name)) {
            if (object == null) {
                object = this.createMap();
            } else {
                object.clear();
            }
            NBTTagList tag = nbt.func_150295_c(name, 10);
            for (int i = 0; i < tag.func_74745_c(); ++i) {
                NBTTagCompound etag = tag.func_150305_b(i);
                Object key = etag.func_74767_n("key-") ? null : this.readRecursive(0, registry, phase, etag, "key", null);
                Object val = etag.func_74767_n("val-") ? null : this.readRecursive(1, registry, phase, etag, "val", null);
                object.put(key, val);
            }
        }
        return object;
    }

    protected abstract T createMap();
}

