/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.cmdscheduler.command.create;

import com.google.inject.Inject;
import com.mcsimonflash.sponge.cmdcontrol.core.CmdUtils;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.argument.Arguments;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.command.Aliases;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.command.Command;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.command.Permission;
import com.mcsimonflash.sponge.cmdscheduler.command.create.Create;
import com.mcsimonflash.sponge.cmdscheduler.schedule.CronSchedule;
import com.mcsimonflash.sponge.cmdscheduler.schedule.Units;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.text.Text;

@Aliases(value={"cron"})
@Permission(value="cmdscheduler.command.create.cron.base")
public class Cron
extends Command {
    @Inject
    private Cron(Command.Settings settings) {
        super(settings.usage(CmdUtils.usage((String)"/cmdscheduler create cron ", (Text)CmdUtils.info((String)"Cron", (String)"Creates a new task with a cron schedule.\n", (String)"", (String)"cron\n", (String)"cmdscheduler.command.create.cron.base"), (Text[])new Text[]{Create.NAME_ARG, CmdUtils.arg((boolean)false, (String)"-schedule", (Text)CmdUtils.info((String)"Schedule", (String)"The cron schedule of the task.\n", (String)"Cron Schedule (in the form ms s m h d mo)\n", (String)"-schedule, -sc", (String)"")), CmdUtils.arg((boolean)false, (String)"-months", (Text)CmdUtils.info((String)"Months", (String)"The months schedule.\n", (String)"Modifier (in range 1-12)\n", (String)"-months, -mo", (String)"")), CmdUtils.arg((boolean)false, (String)"-days", (Text)CmdUtils.info((String)"Days", (String)"The days schedule.\n", (String)"Modifier (in range 1-31)\n", (String)"-days, -d", (String)"")), CmdUtils.arg((boolean)false, (String)"-hours", (Text)CmdUtils.info((String)"Hours", (String)"The hours schedule.\n", (String)"Modifier (in range 0-23)\n", (String)"-hours, -h", (String)"")), CmdUtils.arg((boolean)false, (String)"-minutes", (Text)CmdUtils.info((String)"Minutes", (String)"The minutes schedule.\n", (String)"Modifier (in range 0-59)\n", (String)"-minutes, -m", (String)"")), CmdUtils.arg((boolean)false, (String)"-seconds", (Text)CmdUtils.info((String)"Seconds", (String)"The seconds schedule.\n", (String)"Modifier (in range 0-59)\n", (String)"-seconds, -s", (String)"")), CmdUtils.arg((boolean)false, (String)"-milliseconds", (Text)CmdUtils.info((String)"Milliseconds", (String)"The milliseconds schedule.\n", (String)"Modifier (in range 0-999)\n", (String)"-milliseconds, -ms", (String)"")), Create.ASYNC_FLAG, Create.START_FLAG, Create.COMMAND_ARG})).elements(new CommandElement[]{Arguments.string().toElement("name"), Arguments.flags().flag(new String[]{"start"}).flag((CommandElement)Arguments.tristate().toElement("async"), new String[]{"async", "a"}).flag((CommandElement)Arguments.string().toElement("schedule"), new String[]{"schedule", "sc"}).flag((CommandElement)Arguments.string().toElement("months"), new String[]{"months", "mo"}).flag((CommandElement)Arguments.string().toElement("days"), new String[]{"days", "d"}).flag((CommandElement)Arguments.string().toElement("hours"), new String[]{"hours", "h"}).flag((CommandElement)Arguments.string().toElement("minutes"), new String[]{"minutes", "m"}).flag((CommandElement)Arguments.string().toElement("seconds"), new String[]{"seconds", "s"}).flag((CommandElement)Arguments.string().toElement("milliseconds"), new String[]{"milliseconds", "ms"}).build(), Arguments.command().toElement("command")}));
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        return Create.create(src, args, Cron::apply);
    }

    private static CronSchedule apply(CommandContext args) {
        CronSchedule.Builder builder = CronSchedule.builder();
        if (args.hasAny("schedule")) {
            builder.schedule((String)args.getOne("schedule").get());
        } else {
            for (Units unit : Units.values()) {
                args.getOne(unit.name().toLowerCase()).ifPresent(m -> builder.setUnit(unit, (String)m));
            }
        }
        return builder.build();
    }
}

