/*
 * Decompiled with CFR 0.152.
 */
package net.moddedminecraft.mmcreboot.commands;

import java.util.ArrayList;
import net.moddedminecraft.mmcreboot.Config.Messages;
import net.moddedminecraft.mmcreboot.Main;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;

public class RebootHelp
implements CommandExecutor {
    private final Main plugin;

    public RebootHelp(Main instance) {
        this.plugin = instance;
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        this.showHelp(src);
        return CommandResult.success();
    }

    void showHelp(CommandSource sender) {
        PaginationService paginationService = (PaginationService)Sponge.getServiceManager().provide(PaginationService.class).get();
        ArrayList<Text> contents = new ArrayList<Text>();
        contents.add(this.plugin.fromLegacy(Messages.getHelpHelp()));
        if (sender.hasPermission("mmcreboot.reboot.now")) {
            contents.add(this.plugin.fromLegacy(Messages.getHelpNow()));
        }
        if (sender.hasPermission("mmcreboot.reboot.start")) {
            contents.add(this.plugin.fromLegacy(Messages.getHelpStart()));
        }
        if (sender.hasPermission("mmcreboot.reboot.cancel")) {
            contents.add(this.plugin.fromLegacy(Messages.getHelpCancel()));
        }
        if (sender.hasPermission("mmcreboot.reboot.vote")) {
            contents.add(this.plugin.fromLegacy(Messages.getHelpVote()));
        }
        if (sender.hasPermission("mmcreboot.reboot.time")) {
            contents.add(this.plugin.fromLegacy(Messages.getHelpTime()));
        }
        contents.add(this.plugin.fromLegacy(Messages.getHelpVoteYea()));
        contents.add(this.plugin.fromLegacy(Messages.getHelpVoteNo()));
        paginationService.builder().title(this.plugin.fromLegacy("&6MMCReboot Help")).contents(contents).header(this.plugin.fromLegacy(Messages.getHelpHeader())).padding((Text)Text.of((String)"=")).sendTo((MessageReceiver)sender);
    }
}

