/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.energy;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class ThermoelectricHandler {
    public static HashMap<IngredientStack, Integer> temperatureMap = new HashMap();

    public static void registerSource(IngredientStack source, int value) {
        temperatureMap.put(source, value);
    }

    public static void registerSourceInKelvin(String source, int value) {
        ThermoelectricHandler.registerSource(new IngredientStack(source), value);
    }

    public static void registerSourceInCelsius(String source, int value) {
        ThermoelectricHandler.registerSource(new IngredientStack(source), value + 273);
    }

    public static void registerSourceInFarenheit(String source, int value) {
        ThermoelectricHandler.registerSource(new IngredientStack(source), (int)Math.round((double)(value - 32) / 1.8 + 273.0));
    }

    public static int getTemperature(Block block, int meta) {
        ItemStack stack = new ItemStack(block, 1, meta);
        if (!stack.func_190926_b()) {
            for (Map.Entry<IngredientStack, Integer> entry : temperatureMap.entrySet()) {
                if (!entry.getKey().matchesItemStackIgnoringSize(stack)) continue;
                return entry.getValue();
            }
        }
        return -1;
    }

    public static Map<String, Integer> getThermalValuesSorted(boolean inverse) {
        HashMap<String, Integer> existingMap = new HashMap<String, Integer>();
        for (IngredientStack ingr : temperatureMap.keySet()) {
            ItemStack example = ingr.getExampleStack();
            if (example.func_190926_b()) continue;
            existingMap.put(example.func_82833_r(), temperatureMap.get(ingr));
        }
        return ApiUtils.sortMap(existingMap, inverse);
    }
}

