/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.missile;

import com.builtbroken.jlib.data.vector.IPos3D;
import icbm.classic.ICBMClassic;
import icbm.classic.api.caps.IEMPReceiver;
import icbm.classic.api.explosion.IExplosiveContainer;
import icbm.classic.api.explosion.ILauncherContainer;
import icbm.classic.api.explosion.IMissile;
import icbm.classic.config.ConfigDebug;
import icbm.classic.config.ConfigMissile;
import icbm.classic.content.explosive.Explosive;
import icbm.classic.content.explosive.Explosives;
import icbm.classic.content.explosive.handlers.Explosion;
import icbm.classic.content.missile.CapabilityEmpMissile;
import icbm.classic.content.missile.MissileFlightType;
import icbm.classic.content.missile.MissileTrackerHandler;
import icbm.classic.lib.emp.CapabilityEMP;
import icbm.classic.lib.radar.RadarRegistry;
import icbm.classic.lib.transform.vector.Pos;
import icbm.classic.prefab.entity.EntityProjectile;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityMissile
extends EntityProjectile
implements IEntityAdditionalSpawnData,
IExplosiveContainer,
IMissile {
    public static final float MISSILE_SPEED = 2.0f;
    public Explosives explosiveID = Explosives.CONDENSED;
    public int maxHeight = 200;
    public Pos targetPos = null;
    public Pos launcherPos = null;
    public boolean isExploding = false;
    public boolean destroyNextTick = false;
    public boolean destroyWithFullExplosion = false;
    public boolean explodeNextTick = false;
    public int targetHeight = 0;
    public double deltaPathX;
    public double deltaPathY;
    public double deltaPathZ;
    public double flatDistance;
    public float missileFlightTime;
    public float acceleration;
    public int protectionTime = 2;
    public Entity lockedTarget;
    public boolean didTargetLockBefore = false;
    public int trackingVar = -1;
    public MissileFlightType missileType = MissileFlightType.PAD_LAUNCHER;
    public Pos motionVector = new Pos();
    public double lockHeight = 3.0;
    public boolean wasSimulated = false;
    private final HashSet<Entity> ignoreEntity = new HashSet();
    public NBTTagCompound nbtData = new NBTTagCompound();
    public IEMPReceiver capabilityEMP;
    final int maxPreLaunchSmokeTimer = 50;
    public int preLaunchSmokeTimer = 50;
    public int launcherHasAirBelow = -1;
    LinkedList<Pos> lastSmokePos = new LinkedList();

    public EntityMissile(World w) {
        super(w);
        this.func_70105_a(0.5f, 0.5f);
        this.inAirKillTime = 144000;
        this.field_70178_ae = true;
        this.field_70158_ak = true;
    }

    public EntityMissile(World w, double x, double y, double z, float yaw, float pitch, float speed) {
        super(w, x, y, z, yaw, pitch, speed, 1.0f);
        this.func_70105_a(0.5f, 0.5f);
        this.inAirKillTime = 144000;
        this.field_70178_ae = true;
        this.field_70158_ak = true;
    }

    public EntityMissile(EntityLivingBase entity) {
        super(entity.field_70170_p, entity, 2.0f);
        this.func_70105_a(0.5f, 0.5f);
        this.launcherPos = new Pos((Entity)entity);
        this.inAirKillTime = 144000;
        this.field_70178_ae = true;
        this.field_70158_ak = true;
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEMP.EMP) {
            if (this.capabilityEMP == null) {
                this.capabilityEMP = new CapabilityEmpMissile(this);
            }
            return (T)this.capabilityEMP;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEMP.EMP || super.hasCapability(capability, facing);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_72321_a(5.0, 5.0, 5.0);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * EntityMissile.func_184183_bd()) * d0;
    }

    public String getEntityName() {
        return this.explosiveID.handler.getMissileName();
    }

    public void writeSpawnData(ByteBuf additionalMissileData) {
        additionalMissileData.writeInt(this.explosiveID.ordinal());
        additionalMissileData.writeInt(this.missileType.ordinal());
    }

    public void readSpawnData(ByteBuf additionalMissileData) {
        this.explosiveID = Explosives.get(additionalMissileData.readInt());
        this.missileType = MissileFlightType.values()[additionalMissileData.readInt()];
    }

    @Override
    public void launch(Pos target) {
        if (this.ticksInAir <= 0) {
            this.ticksInAir = 2;
        }
        this.sourceOfProjectile = new Pos((IPos3D)this);
        this.targetPos = target;
        int n = this.targetHeight = this.targetPos != null ? this.targetPos.yi() : 0;
        if (this.explosiveID != null && this.explosiveID.handler instanceof Explosion) {
            ((Explosion)this.explosiveID.handler).launch(this);
        }
        this.recalculatePath();
        this.updateMotion();
        RadarRegistry.add(this);
        if (ConfigDebug.DEBUG_MISSILE_LAUNCHES) {
            if (target != null) {
                ICBMClassic.logger().info("Launching " + this.getEntityName() + " (" + this.func_145782_y() + ") from " + this.sourceOfProjectile.xi() + ", " + this.sourceOfProjectile.yi() + ", " + this.sourceOfProjectile.zi() + " to " + this.targetPos.xi() + ", " + this.targetPos.yi() + ", " + this.targetPos.zi());
            } else {
                ICBMClassic.logger().info("Launching " + this.getEntityName() + " (" + this.func_145782_y() + ") from " + this.sourceOfProjectile.xi() + ", " + this.sourceOfProjectile.yi() + ", " + this.sourceOfProjectile.zi());
            }
        }
    }

    @Override
    public void launch(Pos target, int height) {
        this.lockHeight = height;
        this.launch(target);
    }

    public EntityMissile ignore(Entity entity) {
        this.ignoreEntity.add(entity);
        return this;
    }

    public void recalculatePath() {
        if (this.targetPos != null) {
            this.deltaPathX = this.targetPos.x() - this.sourceOfProjectile.x();
            this.deltaPathY = this.targetPos.y() - this.sourceOfProjectile.y();
            this.deltaPathZ = this.targetPos.z() - this.sourceOfProjectile.z();
            if (this.missileType == MissileFlightType.PAD_LAUNCHER) {
                this.flatDistance = this.sourceOfProjectile.toVector2().distance(this.targetPos.toVector2());
                this.maxHeight = 160 + (int)(this.flatDistance * 3.0);
                this.missileFlightTime = (float)Math.max(100.0, 2.0 * this.flatDistance) - (float)this.ticksInAir;
                if (!this.wasSimulated) {
                    this.acceleration = (float)this.maxHeight * 2.0f / (this.missileFlightTime * this.missileFlightTime);
                }
            } else if (this.missileType.movesDirectly) {
                this.func_70186_c(this.deltaPathX, this.deltaPathY, this.deltaPathZ, 2.0f, 0.0f);
            }
        }
    }

    @Override
    public void func_70088_a() {
    }

    public boolean func_70067_L() {
        return true;
    }

    @Override
    protected void updateMotion() {
        if (this.wasSimulated) {
            this.preLaunchSmokeTimer = 0;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.preLaunchSmokeTimer <= 0 || this.missileType != MissileFlightType.PAD_LAUNCHER) {
                if (this.ticksInAir <= 0) {
                    this.ticksInAir = 2;
                }
                if (this.ticksInAir >= 0 && this.missileType == MissileFlightType.PAD_LAUNCHER) {
                    if (this.lockHeight > 0.0) {
                        this.field_70181_x = ConfigMissile.LAUNCH_SPEED * (float)this.ticksInAir * ((float)this.ticksInAir / 2.0f);
                        this.field_70159_w = 0.0;
                        this.field_70179_y = 0.0;
                        this.lockHeight -= this.field_70181_x;
                        if (this.lockHeight <= 0.0) {
                            this.field_70181_x = this.acceleration * (this.missileFlightTime / 2.0f);
                            this.field_70159_w = this.deltaPathX / (double)this.missileFlightTime;
                            this.field_70179_y = this.deltaPathZ / (double)this.missileFlightTime;
                        }
                    } else {
                        this.field_70181_x -= (double)this.acceleration;
                        this.field_70125_A = (float)(Math.atan(this.field_70181_x / Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) * 180.0 / Math.PI);
                        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
                    }
                    if (this.shouldSimulate()) {
                        MissileTrackerHandler.simulateMissile(this);
                    }
                }
                --this.protectionTime;
            } else {
                this.field_70181_x = 0.015f;
                this.lockHeight -= this.field_70181_x;
                this.field_70163_u = this.launcherPos.y() + (double)2.2f;
                this.field_70127_C = 90.0f;
                this.field_70125_A = 90.0f;
                this.spawnMissileSmoke();
                this.ticksInAir = 0;
            }
        }
        if (this.preLaunchSmokeTimer > 0) {
            --this.preLaunchSmokeTimer;
        }
        this.spawnMissileSmoke();
        if (this.explosiveID != null && this.explosiveID.handler instanceof Explosion) {
            ((Explosion)this.explosiveID.handler).update(this);
        }
        super.updateMotion();
    }

    protected boolean shouldSimulate() {
        return this.launcherPos != null && this.func_184188_bt().size() <= 0 && this.targetPos.distance(this.launcherPos) > 50.0 && !this.wasSimulated && (this.field_70163_u >= (double)ConfigMissile.SIMULATION_START_HEIGHT || this.field_70181_x <= 0.0 && this.ticksInAir > 100);
    }

    @Override
    protected void decreaseMotion() {
        if (this.missileType != MissileFlightType.PAD_LAUNCHER && this.ticksInAir > 1000) {
            super.decreaseMotion();
        }
    }

    @Override
    protected void onImpactTile() {
        this.doExplosion();
    }

    @Override
    protected void onImpactEntity(Entity entityHit, float velocity) {
        if (!this.field_70170_p.field_72995_K && entityHit.func_184187_bx() != this) {
            super.onImpactEntity(entityHit, velocity);
            this.doExplosion();
        }
    }

    @Override
    public ILauncherContainer getLauncher() {
        TileEntity tileEntity;
        if (this.launcherPos != null && (tileEntity = this.launcherPos.getTileEntity((IBlockAccess)this.field_70170_p)) != null && tileEntity instanceof ILauncherContainer && !tileEntity.func_145837_r()) {
            return (ILauncherContainer)tileEntity;
        }
        return null;
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (this.explosiveID != null && ((Explosion)this.explosiveID.handler).onInteract(this, player, hand)) {
            return true;
        }
        if (!(this.field_70170_p.field_72995_K || this.func_184187_bx() != null && this.func_184187_bx() != player)) {
            player.func_184220_m((Entity)this);
            return true;
        }
        return false;
    }

    public double func_70042_X() {
        if (this.missileFlightTime <= 0.0f && this.missileType == MissileFlightType.PAD_LAUNCHER) {
            return this.field_70131_O;
        }
        if (this.missileType == MissileFlightType.CRUISE_LAUNCHER) {
            return this.field_70131_O / 10.0f;
        }
        return (double)(this.field_70131_O / 2.0f) + this.field_70181_x;
    }

    private void spawnMissileSmoke() {
        block5: {
            block6: {
                Pos position;
                block7: {
                    if (!this.field_70170_p.field_72995_K) break block5;
                    if (this.missileType != MissileFlightType.PAD_LAUNCHER) break block6;
                    if (!(this.field_70181_x > -1.0) || !this.field_70170_p.field_72995_K || !(this.field_70181_x > -1.0)) break block5;
                    if (this.launcherHasAirBelow == -1) {
                        BlockPos bp = new BlockPos(Math.signum(this.field_70165_t) * Math.floor(Math.abs(this.field_70165_t)), this.field_70163_u - 3.0, Math.signum(this.field_70161_v) * Math.floor(Math.abs(this.field_70161_v)));
                        this.launcherHasAirBelow = this.field_70170_p.func_175623_d(bp) ? 1 : 0;
                    }
                    position = new Pos((IPos3D)this);
                    double distance = -1.2f;
                    double y = Math.sin(Math.toRadians(this.field_70125_A)) * distance;
                    double dH = Math.cos(Math.toRadians(this.field_70125_A)) * distance;
                    double x = Math.sin(Math.toRadians(this.field_70177_z)) * dH;
                    double z = Math.cos(Math.toRadians(this.field_70177_z)) * dH;
                    position = (Pos)position.add(x, y, z);
                    if (this.preLaunchSmokeTimer <= 0 || this.ticksInAir > 50) break block7;
                    if (this.launcherHasAirBelow != 1) break block5;
                    position = (Pos)position.sub(0.0, 2.0, 0.0);
                    Pos velocity = (Pos)new Pos(0.0, -1.0, 0.0).addRandom(this.field_70170_p.field_73012_v, 0.5);
                    for (int i = 0; i < 10; ++i) {
                        ICBMClassic.proxy.spawnSmoke(this.field_70170_p, position, velocity.x(), velocity.y(), velocity.z(), 1.0f, 1.0f, 1.0f, 8.0f, 180);
                        position.multiply(1.0 - 0.025 * Math.random(), 1.0 - 0.025 * Math.random(), 1.0 - 0.025 * Math.random());
                    }
                    break block5;
                }
                this.lastSmokePos.add(position);
                Pos lastPos = null;
                if (this.lastSmokePos.size() > 5) {
                    lastPos = this.lastSmokePos.get(0);
                    this.lastSmokePos.remove(0);
                }
                ICBMClassic.proxy.spawnSmoke(this.field_70170_p, position, -this.field_70159_w * 0.75, -this.field_70181_x * 0.75, -this.field_70179_y * 0.75, 1.0f, 0.75f, 0.0f, 5.0f, 10);
                if (this.ticksInAir <= 5 || lastPos == null) break block5;
                for (int i = 0; i < 10; ++i) {
                    ICBMClassic.proxy.spawnSmoke(this.field_70170_p, lastPos, -this.field_70159_w * 0.5, -this.field_70181_x * 0.5, -this.field_70179_y * 0.5, 1.0f, 1.0f, 1.0f, (int)Math.max(1.0, 6.0 * (1.0 / (1.0 + this.field_70163_u / 100.0))), 240);
                    position.multiply(1.0 - 0.025 * Math.random(), 1.0 - 0.025 * Math.random(), 1.0 - 0.025 * Math.random());
                }
                break block5;
            }
            Pos position = new Pos((IPos3D)this);
            double distance = -1.2f;
            double y = Math.sin(Math.toRadians(this.field_70125_A)) * distance;
            double dH = Math.cos(Math.toRadians(this.field_70125_A)) * distance;
            double x = Math.sin(Math.toRadians(this.field_70177_z)) * dH;
            double z = Math.cos(Math.toRadians(this.field_70177_z)) * dH;
            position = (Pos)position.add(x, y, z);
            for (int i = 0; i < 10; ++i) {
                ICBMClassic.proxy.spawnSmoke(this.field_70170_p, position, -this.field_70159_w * 0.5, -this.field_70181_x * 0.5, -this.field_70179_y * 0.5, 1.0f, 1.0f, 1.0f, (int)Math.max(1.0, 6.0 * (1.0 / (1.0 + this.field_70163_u / 100.0))), 240);
                position.multiply(1.0 - 0.025 * Math.random(), 1.0 - 0.025 * Math.random(), 1.0 - 0.025 * Math.random());
            }
        }
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        if (this.ignoreEntity.contains(entity)) {
            return null;
        }
        return this.func_174813_aQ();
    }

    @Override
    public Pos getPredictedPosition(int t) {
        Pos position = new Pos((IPos3D)this);
        double tempMotionY = this.field_70181_x;
        if (this.ticksInAir > 20) {
            for (int i = 0; i < t; ++i) {
                position = this.missileType.movesDirectly ? (Pos)position.add(this.motionVector) : (Pos)position.add(this.field_70159_w, tempMotionY - (double)this.acceleration, this.field_70179_y);
            }
        }
        return position;
    }

    @Override
    public void triggerExplosion() {
        this.explodeNextTick = true;
    }

    @Override
    public void destroyMissile(boolean fullExplosion) {
        this.destroyNextTick = true;
        this.destroyWithFullExplosion = fullExplosion;
    }

    @Override
    public boolean isExploding() {
        return this.isExploding;
    }

    public void func_70106_y() {
        if (!this.field_70170_p.field_72995_K) {
            RadarRegistry.remove(this);
        }
        super.func_70106_y();
    }

    @Override
    public void doExplosion() {
        this.func_184210_p();
        this.func_184226_ay();
        try {
            if (!this.isExploding) {
                this.isExploding = true;
                this.func_70106_y();
                if (!this.field_70170_p.field_72995_K) {
                    if (this.explosiveID == null) {
                        this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f, true);
                    } else {
                        this.explosiveID.handler.createExplosion(this.field_70170_p, new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v), this, 1.0f);
                    }
                }
                ICBMClassic.logger().info(this.getEntityName() + " (" + this.func_145782_y() + ") exploded in " + (int)this.field_70165_t + ", " + (int)this.field_70163_u + ", " + (int)this.field_70161_v);
            }
        }
        catch (Exception e) {
            ICBMClassic.logger().error("EntityMissile#normalExplode() - Unexpected error while triggering explosive on missile", (Throwable)e);
        }
    }

    @Override
    public void dropMissileAsItem() {
        if (!this.isExploding && !this.field_70170_p.field_72995_K) {
            EntityItem entityItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(ICBMClassic.itemMissile, 1, this.explosiveID.ordinal()));
            float var13 = 0.05f;
            Random random = new Random();
            entityItem.field_70159_w = (float)random.nextGaussian() * var13;
            entityItem.field_70181_x = (float)random.nextGaussian() * var13 + 0.2f;
            entityItem.field_70179_y = (float)random.nextGaussian() * var13;
            this.field_70170_p.func_72838_d((Entity)entityItem);
        }
        this.func_70106_y();
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.targetPos = new Pos(nbt.func_74775_l("target"));
        this.launcherPos = new Pos(nbt.func_74775_l("launcherPos"));
        this.acceleration = nbt.func_74760_g("acceleration");
        this.targetHeight = nbt.func_74762_e("targetHeight");
        this.explosiveID = Explosives.get(nbt.func_74762_e("explosiveID"));
        this.ticksInAir = nbt.func_74762_e("ticksInAir");
        this.lockHeight = nbt.func_74769_h("lockHeight");
        this.missileType = MissileFlightType.get(nbt.func_74762_e("missileType"));
        this.preLaunchSmokeTimer = nbt.func_74762_e("preLaunchSmokeTimer");
        this.nbtData = nbt.func_74775_l("additionalMissileData");
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.targetPos != null) {
            nbt.func_74782_a("target", (NBTBase)this.targetPos.toNBT());
        }
        if (this.launcherPos != null) {
            nbt.func_74782_a("launcherPos", (NBTBase)this.launcherPos.toNBT());
        }
        nbt.func_74776_a("acceleration", this.acceleration);
        nbt.func_74768_a("explosiveID", this.explosiveID.ordinal());
        nbt.func_74768_a("targetHeight", this.targetHeight);
        nbt.func_74768_a("ticksInAir", this.ticksInAir);
        nbt.func_74780_a("lockHeight", this.lockHeight);
        nbt.func_74768_a("missileType", this.missileType.ordinal());
        nbt.func_74768_a("preLaunchSmokeTimer", this.preLaunchSmokeTimer);
        nbt.func_74782_a("additionalMissileData", (NBTBase)this.nbtData);
    }

    @Override
    public int getTicksInAir() {
        return this.ticksInAir;
    }

    @Override
    public Explosive getExplosiveType() {
        return this.explosiveID.handler;
    }

    @Override
    public NBTTagCompound getExplosiveData() {
        return this.nbtData;
    }
}

