/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.explosive.handlers.missiles;

import icbm.classic.content.explosive.blast.BlastTNT;
import icbm.classic.content.explosive.handlers.missiles.Missile;
import icbm.classic.content.items.ItemTracker;
import icbm.classic.content.missile.EntityMissile;
import icbm.classic.content.missile.MissileFlightType;
import icbm.classic.lib.transform.vector.Pos;
import icbm.classic.prefab.tile.EnumTier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class MissileHoming
extends Missile {
    public MissileHoming() {
        super("homing", EnumTier.ONE);
        this.hasBlock = false;
    }

    @Override
    public void launch(EntityMissile missileObj) {
        WorldServer worldServer;
        Entity trackingEntity;
        if (!missileObj.field_70170_p.field_72995_K && (trackingEntity = (worldServer = (WorldServer)missileObj.field_70170_p).func_73045_a(missileObj.trackingVar)) != null) {
            if (trackingEntity == missileObj) {
                missileObj.doExplosion();
            }
            missileObj.targetPos = new Pos(trackingEntity);
        }
    }

    @Override
    public void update(EntityMissile missileObj) {
        World world;
        Entity trackingEntity;
        if ((float)missileObj.getTicksInAir() > missileObj.missileFlightTime / 2.0f && missileObj.missileType == MissileFlightType.PAD_LAUNCHER && (trackingEntity = (world = missileObj.field_70170_p).func_73045_a(missileObj.trackingVar)) != null) {
            if (trackingEntity.equals((Object)missileObj)) {
                missileObj.doExplosion();
            }
            missileObj.targetPos = new Pos(trackingEntity);
            missileObj.missileType = MissileFlightType.HOMING;
            missileObj.deltaPathX = missileObj.targetPos.x() - missileObj.field_70165_t;
            missileObj.deltaPathY = missileObj.targetPos.y() - missileObj.field_70163_u;
            missileObj.deltaPathZ = missileObj.targetPos.z() - missileObj.field_70161_v;
            missileObj.flatDistance = missileObj.sourceOfProjectile.toVector2().distance(missileObj.targetPos.toVector2());
            missileObj.maxHeight = 150 + (int)(missileObj.flatDistance * 1.8);
            missileObj.missileFlightTime = (float)Math.max(100.0, 2.4 * missileObj.flatDistance);
            missileObj.acceleration = (float)missileObj.maxHeight * 2.0f / (missileObj.missileFlightTime * missileObj.missileFlightTime);
            if (missileObj.motionVector == null || missileObj.motionVector.equals(new Pos())) {
                float suDu = 0.3f;
                missileObj.motionVector = new Pos(missileObj.deltaPathX / (double)(missileObj.missileFlightTime * suDu), missileObj.deltaPathY / (double)(missileObj.missileFlightTime * suDu), missileObj.deltaPathZ / (double)(missileObj.missileFlightTime * suDu));
            }
        }
    }

    @Override
    public boolean onInteract(EntityMissile missileObj, EntityPlayer entityPlayer, EnumHand hand) {
        Entity trackingEntity;
        ItemStack heldItem;
        if (!missileObj.field_70170_p.field_72995_K && missileObj.getTicksInAir() <= 0 && (heldItem = entityPlayer.func_184586_b(hand)) != null && heldItem.func_77973_b() instanceof ItemTracker && (trackingEntity = ((ItemTracker)heldItem.func_77973_b()).getTrackingEntity(missileObj.field_70170_p, heldItem)) != null && missileObj.trackingVar != trackingEntity.func_145782_y()) {
            missileObj.trackingVar = trackingEntity.func_145782_y();
            entityPlayer.func_145747_a((ITextComponent)new TextComponentString("Missile target locked to: " + trackingEntity.func_70005_c_()));
            if (missileObj.getLauncher() != null && missileObj.getLauncher().getController() != null) {
                Pos newTarget = new Pos(trackingEntity.field_70165_t, 0.0, trackingEntity.field_70161_v);
                missileObj.getLauncher().getController().setTarget(newTarget);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isCruise() {
        return false;
    }

    @Override
    public void doCreateExplosion(World world, BlockPos pos, Entity entity, float scale) {
        new BlastTNT(world, entity, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 4.0f * scale).setDestroyItems().runBlast();
    }
}

