/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.tile;

import galaxyspace.systems.SolarSystem.planets.overworld.blocks.machines.BlockModernStorageModule;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.item.IItemElectricBase;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectricalSource;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;

public class TileEntityModernStorageModule
extends TileBaseUniversalElectricalSource
implements ISidedInventory,
IConnector {
    private static final float BASE_CAPACITY = 5000000.0f;
    public final Set<EntityPlayer> playersUsing = new HashSet<EntityPlayer>();
    public int scaledEnergyLevel;
    public int lastScaledEnergyLevel;
    private float lastEnergy = 0.0f;

    public TileEntityModernStorageModule() {
        this(1);
    }

    public TileEntityModernStorageModule(int tier) {
        super("tile.modern_storage_module.name");
        this.setTier(tier);
    }

    private void setTier(int tier) {
        this.storage.setCapacity(5000000.0f + 5000000.0f * (float)tier / 10.0f);
        this.storage.setMaxExtract((float)(1800 + 200 * tier));
        this.inventory = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
        this.setTierGC(tier);
    }

    public void func_73660_a() {
        float energy = this.storage.getEnergyStoredGC();
        if (this.getTierGC() == 1 && !this.field_145850_b.field_72995_K && this.lastEnergy - energy > this.storage.getMaxExtract() - 1.0f) {
            this.storage.extractEnergyGC(25.0f, false);
        }
        this.lastEnergy = energy;
        super.func_73660_a();
        this.scaledEnergyLevel = (int)Math.floor((this.getEnergyStoredGC() + 49.0f) * 16.0f / this.getMaxEnergyStoredGC());
        if (this.scaledEnergyLevel != this.lastScaledEnergyLevel) {
            this.field_145850_b.func_175679_n(this.func_174877_v());
        }
        if (!this.field_145850_b.field_72995_K) {
            this.recharge((ItemStack)this.getInventory().get(0));
            this.discharge((ItemStack)this.getInventory().get(1));
        }
        if (!this.field_145850_b.field_72995_K) {
            this.produce();
        }
        this.lastScaledEnergyLevel = this.scaledEnergyLevel;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt, (NonNullList)this.getInventory());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        if (this.tierGC == 1 && this.storage.getEnergyStoredGC() > 5000000.0f) {
            this.storage.setEnergyStored(5000000.0f);
        }
        super.func_189515_b(nbt);
        ItemStackHelper.func_191282_a((NBTTagCompound)nbt, (NonNullList)this.getInventory());
        return nbt;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && par1EntityPlayer.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return ItemElectricBase.isElectricItem((Item)itemstack.func_77973_b());
    }

    public boolean func_180462_a(int slotID, ItemStack itemstack, EnumFacing side) {
        if (itemstack.func_77973_b() instanceof IItemElectricBase) {
            if (slotID == 0) {
                return ((IItemElectricBase)itemstack.func_77973_b()).getTransfer(itemstack) > 0.0f;
            }
            if (slotID == 1) {
                return ((IItemElectricBase)itemstack.func_77973_b()).getElectricityStored(itemstack) > 0.0f;
            }
        }
        return false;
    }

    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        if (itemstack.func_77973_b() instanceof IItemElectricBase) {
            if (slotID == 0) {
                return ((IItemElectricBase)itemstack.func_77973_b()).getTransfer(itemstack) <= 0.0f;
            }
            if (slotID == 1) {
                return ((IItemElectricBase)itemstack.func_77973_b()).getElectricityStored(itemstack) <= 0.0f || this.getEnergyStoredGC() >= this.getMaxEnergyStoredGC();
            }
        }
        return false;
    }

    public EnumSet<EnumFacing> getElectricalInputDirections() {
        return EnumSet.of(this.getElectricInputDirection());
    }

    public EnumSet<EnumFacing> getElectricalOutputDirections() {
        return EnumSet.of(this.getElectricOutputDirection());
    }

    public boolean canConnect(EnumFacing direction, NetworkType type) {
        if (direction == null || type != NetworkType.POWER) {
            return false;
        }
        return this.getElectricalInputDirections().contains(direction) || this.getElectricalOutputDirections().contains(direction);
    }

    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockModernStorageModule) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockModernStorageModule.FACING);
        }
        return EnumFacing.NORTH;
    }

    public EnumFacing getElectricInputDirection() {
        return this.getFront().func_176746_e();
    }

    public EnumFacing getElectricOutputDirection() {
        return this.getFront().func_176735_f();
    }
}

