/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.client.gui.book.pages;

import asmodeuscore.api.dimension.IAdvancedSpace;
import asmodeuscore.core.astronomy.BodiesData;
import asmodeuscore.core.astronomy.BodiesHelper;
import asmodeuscore.core.astronomy.gui.book.Page_WithScroll;
import asmodeuscore.core.utils.BookUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldProvider;
import org.lwjgl.opengl.GL11;

public class Page_Systems
extends Page_WithScroll {
    private static ResourceLocation starTexture = new ResourceLocation("galaxyspace", "textures/gui/book/star_bg.png");
    private Mode current_mode = Mode.LIST;
    private static List<CelestialBody> planets = new LinkedList<CelestialBody>();
    private Minecraft mc = Minecraft.func_71410_x();
    private int maxX = 0;
    private CelestialBody selected_body;
    private Moon selected_moon;
    private Map<CelestialBody, ItemStack[]> resources = new HashMap<CelestialBody, ItemStack[]>();
    private SolarSystem system;

    public Page_Systems(SolarSystem system) {
        this.system = system;
    }

    public String titlePage() {
        return this.system.getUnlocalizedName();
    }

    public ResourceLocation iconTitle() {
        return this.system.getMainStar().getBodyIcon();
    }

    public boolean rawTitle() {
        return true;
    }

    public void drawPage(int x, int y, FontRenderer font, int mouseX, int mouseY) {
        block30: {
            block31: {
                block29: {
                    super.drawPage(x, y, font, mouseX, mouseY);
                    if (this.current_mode != Mode.LIST) break block29;
                    planets.clear();
                    for (Object planet : GalaxyRegistry.getPlanetsForSolarSystem((SolarSystem)this.system)) {
                        planets.add((CelestialBody)planet);
                    }
                    int posY = 0;
                    for (CelestialBody s : planets) {
                        int currX = font.func_78256_a(s.getLocalizedName());
                        this.maxX = this.maxX < currX ? currX : this.maxX;
                    }
                    int offsetX = 21;
                    for (int i = this.getScroll(); i < planets.size(); ++i) {
                        if (i >= 8 + this.getScroll()) continue;
                        int yOffset = i - this.getScroll();
                        this.mc.func_110434_K().func_110577_a(bookPageTexture);
                        posY = 0;
                        if (mouseX >= x + 44 && mouseX < x + 40 + 25 + this.maxX && mouseY >= y + 41 + offsetX * yOffset && mouseY <= y + 41 + offsetX * yOffset + 16) {
                            posY = 17;
                        }
                        this.mc.func_110434_K().func_110577_a(bookPageTexture);
                        this.drawTexturedModalRect(x + 20, y + 41 + offsetX * yOffset, 21.0f, 21.0f, 461.0f, 35.0f, 18.0f, 21.0f, false, false, 512.0f, 256.0f);
                        this.mc.func_110434_K().func_110577_a(planets.get(i).getBodyIcon());
                        this.drawTexturedModalRect(x + 25, y + 45 + offsetX * yOffset, 12.0f, 12.0f, 0.0f, 0.0f, 16.0f, 16.0f, false, false, 16.0f, 16.0f);
                        this.mc.func_110434_K().func_110577_a(bookPageTexture);
                        this.drawTexturedModalRect(x + 40, y + 41 + offsetX * yOffset, 25.0f, 16.0f, 400.0f, posY, 20.0f, 15.0f, false, false, 512.0f, 256.0f);
                        this.drawTexturedModalRect(x + 40 + 16, y + 41 + offsetX * yOffset, this.maxX, 16.0f, 410.0f, posY, 70.0f, 15.0f, false, false, 512.0f, 256.0f);
                        this.drawTexturedModalRect(x + 40 + this.maxX, y + 41 + offsetX * yOffset, 25.0f, 16.0f, 467.0f, posY, 20.0f, 15.0f, false, false, 512.0f, 256.0f);
                        font.func_78276_b(planets.get(i).getLocalizedName(), x + 52, y + 46 + offsetX * yOffset, 0xFFFFFF);
                    }
                    this.mc.func_110434_K().func_110577_a(starTexture);
                    this.drawTexturedModalRect(x + 80 + this.maxX, y + 45, 60.0f, 60.0f, 0.0f, 0.0f, 256.0f, 256.0f, false, false, 256.0f, 256.0f);
                    this.mc.func_110434_K().func_110577_a(this.system.getMainStar().getBodyIcon());
                    this.drawTexturedModalRect(x + 80 + this.maxX + 30 - 6, y + 45 + 30 - 6, 12.0f, 12.0f, 0.0f, 0.0f, 16.0f, 16.0f, false, false, 16.0f, 16.0f);
                    this.drawText(GCCoreUtil.translate((String)("book.page." + this.system.getMainStar().getUnlocalizedName() + ".desc")), x + 110 + this.maxX, y - 40, 0, 200, font);
                    break block30;
                }
                if (this.current_mode != Mode.BODY) break block31;
                int offsetX = 0;
                int posY = 17;
                int i = 1;
                this.mc.func_110434_K().func_110577_a(bookPageTexture);
                this.drawTexturedModalRect(x + 20, y + 41 + offsetX, 21.0f, 21.0f, 461.0f, 35.0f, 18.0f, 21.0f, false, false, 512.0f, 256.0f);
                this.mc.func_110434_K().func_110577_a(this.selected_body.getBodyIcon());
                this.drawTexturedModalRect(x + 25, y + 45 + offsetX, 12.0f, 12.0f, 0.0f, 0.0f, 16.0f, 16.0f, false, false, 16.0f, 16.0f);
                this.mc.func_110434_K().func_110577_a(bookPageTexture);
                this.drawTexturedModalRect(x + 40, y + 41 + offsetX, 25.0f, 16.0f, 400.0f, posY, 20.0f, 15.0f, false, false, 512.0f, 256.0f);
                this.drawTexturedModalRect(x + 40 + 16, y + 41 + offsetX, this.maxX, 16.0f, 410.0f, posY, 70.0f, 15.0f, false, false, 512.0f, 256.0f);
                this.drawTexturedModalRect(x + 40 + this.maxX, y + 41 + offsetX, 25.0f, 16.0f, 467.0f, posY, 20.0f, 15.0f, false, false, 512.0f, 256.0f);
                font.func_78276_b(this.selected_body.getLocalizedName(), x + 52, y + 46 + offsetX, 0xFFFFFF);
                if (this.selected_body instanceof Planet) {
                    offsetX = 21;
                    for (Moon moon : GalaxyRegistry.getMoonsForPlanet((Planet)((Planet)this.selected_body))) {
                        posY = 0;
                        if (mouseX >= x + 44 && mouseX < x + 40 + 25 + this.maxX && mouseY >= y + 41 + offsetX * i && mouseY <= y + 41 + offsetX * i + 16) {
                            posY = 17;
                        }
                        this.mc.func_110434_K().func_110577_a(bookPageTexture);
                        this.drawTexturedModalRect(x + 20, y + 41 + offsetX * i, 21.0f, 21.0f, 461.0f, 35.0f, 18.0f, 21.0f, false, false, 512.0f, 256.0f);
                        this.mc.func_110434_K().func_110577_a(moon.getBodyIcon());
                        this.drawTexturedModalRect(x + 25, y + 45 + offsetX * i, 12.0f, 12.0f, 0.0f, 0.0f, 16.0f, 16.0f, false, false, 16.0f, 16.0f);
                        this.mc.func_110434_K().func_110577_a(bookPageTexture);
                        this.drawTexturedModalRect(x + 40, y + 41 + offsetX * i, 25.0f, 16.0f, 400.0f, posY, 20.0f, 15.0f, false, false, 512.0f, 256.0f);
                        this.drawTexturedModalRect(x + 40 + 16, y + 41 + offsetX * i, this.maxX, 16.0f, 410.0f, posY, 70.0f, 15.0f, false, false, 512.0f, 256.0f);
                        this.drawTexturedModalRect(x + 40 + this.maxX, y + 41 + offsetX * i, 25.0f, 16.0f, 467.0f, posY, 20.0f, 15.0f, false, false, 512.0f, 256.0f);
                        font.func_78279_b(moon.getLocalizedName(), x + 52, y + 46 + offsetX * i, 260, 0xFFFFFF);
                        ++i;
                    }
                }
                if (this.selected_body == null) break block30;
                font.func_78279_b(GCCoreUtil.translate((String)("book.page." + this.system.getUnlocalizedName() + "." + this.selected_body.getName().toLowerCase())), x + 80 + this.maxX, y + 46, 260, 0xFFFFFF);
                int offsetY = font.func_78256_a(GCCoreUtil.translate((String)("book.page." + this.system.getUnlocalizedName() + "." + this.selected_body.getName().toLowerCase()))) / 260 * font.field_78288_b;
                offsetY -= this.getScroll() * 10;
                WorldProvider dim = WorldUtil.getProviderForDimensionClient((int)this.selected_body.getDimensionID());
                int j = 0;
                if (dim instanceof IGalacticraftWorldProvider) {
                    BodiesData data;
                    IGalacticraftWorldProvider gcdim = (IGalacticraftWorldProvider)dim;
                    ArrayList<String> infos = new ArrayList<String>();
                    float grav = (0.1f - ((IGalacticraftWorldProvider)dim).getGravity()) * 1000.0f;
                    if (((IGalacticraftWorldProvider)dim).getGravity() == 0.0f) {
                        grav = 0.0f;
                    }
                    infos.add(GCCoreUtil.translate((String)"gui.message.daylength") + " " + ((WorldProviderSpace)gcdim).getDayLength() / 1000L + "h " + ((WorldProviderSpace)gcdim).getDayLength() % 1000L + "m");
                    infos.add("Distance from star: " + this.selected_body.getRelativeDistanceFromCenter().unScaledDistance);
                    infos.add(GCCoreUtil.translate((String)"gui.message.gravity") + " " + (int)grav + "%");
                    infos.add(GCCoreUtil.translate((String)"gui.message.temperature") + " " + gcdim.getCelestialBody().atmosphere.thermalLevel() * 20.0f + " C");
                    infos.add(GCCoreUtil.translate((String)"gui.message.windspeed") + " " + gcdim.getCelestialBody().atmosphere.windLevel());
                    if (dim instanceof ISolarLevel) {
                        infos.add(GCCoreUtil.translate((String)"gui.message.solarenergy") + " " + (float)Math.round((((ISolarLevel)dim).getSolarEnergyMultiplier() - 1.0) * 1000.0) / 10.0f + "%");
                    }
                    if (gcdim instanceof IAdvancedSpace) {
                        infos.add(GCCoreUtil.translate((String)"gui.message.windenergy") + " " + (float)Math.round(((IAdvancedSpace)dim).getSolarWindMultiplier() * 1000.0) / 1000.0f);
                    }
                    if ((data = (BodiesData)BodiesHelper.getData().get(this.selected_body)) != null) {
                        infos.add(GCCoreUtil.translate((String)"gui.message.atmopressure") + " " + data.getPressurePlanet());
                        infos.add(GCCoreUtil.translate((String)"gui.message.solarradiation") + " " + data.getSolarRadiationPlanet());
                    }
                    infos.add(GCCoreUtil.translate((String)"gui.message.breathableatmo") + " " + gcdim.hasBreathableAtmosphere());
                    infos.add("");
                    infos.add(GCCoreUtil.translate((String)"gui.message.resources"));
                    int k = this.getScroll();
                    while (k < infos.size()) {
                        if (!((String)infos.get(k)).isEmpty() && k < 8 + this.getScroll()) {
                            this.mc.func_110434_K().func_110577_a(bookPageTexture);
                            this.drawTexturedModalRect(x + 78 + this.maxX, y + 80 + k * 12 + offsetY, 136.0f, 13.0f, 401.0f, 119.0f, 85.0f, 15.0f, false, false, 512.0f, 256.0f);
                            font.func_78276_b((String)infos.get(k), x + 84 + this.maxX, y + 82 + k * 12 + offsetY, 0xFFFFFF);
                        }
                        ++k;
                        ++j;
                    }
                    if (this.resources.containsKey(this.selected_body) && this.getScroll() > 3) {
                        k = 0;
                        for (ItemStack stacks : this.resources.get(this.selected_body)) {
                            this.mc.field_71446_o.func_110577_a(bookPageTexture);
                            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            this.drawTexturedModalRect(x + 78 + this.maxX + k * 22, y + 108 + infos.size() * 10 + offsetY, 20.0f, 20.0f, 452.0f, 94.0f, 20.0f, 20.0f, false, false, 576.0f, 250.0f);
                            this.drawItemStack(this.mc, stacks, x + 80 + this.maxX + k++ * 22, y + 110 + infos.size() * 10 + offsetY, mouseX, mouseY, true);
                        }
                    }
                }
                break block30;
            }
            if (this.current_mode == Mode.MOON) {
                this.mc.func_110434_K().func_110577_a(bookPageTexture);
                this.drawTexturedModalRect(x + 20, y + 41, 21.0f, 21.0f, 461.0f, 35.0f, 18.0f, 21.0f, false, false, 512.0f, 256.0f);
                this.mc.func_110434_K().func_110577_a(this.selected_moon.getBodyIcon());
                this.drawTexturedModalRect(x + 25, y + 45, 12.0f, 12.0f, 0.0f, 0.0f, 16.0f, 16.0f, false, false, 16.0f, 16.0f);
                this.mc.func_110434_K().func_110577_a(bookPageTexture);
                this.drawTexturedModalRect(x + 40, y + 41, 25.0f, 16.0f, 400.0f, 17.0f, 20.0f, 15.0f, false, false, 512.0f, 256.0f);
                this.drawTexturedModalRect(x + 40 + 16, y + 41, this.maxX, 16.0f, 410.0f, 17.0f, 70.0f, 15.0f, false, false, 512.0f, 256.0f);
                this.drawTexturedModalRect(x + 40 + this.maxX, y + 41, 25.0f, 16.0f, 467.0f, 17.0f, 20.0f, 15.0f, false, false, 512.0f, 256.0f);
                font.func_78276_b(this.selected_moon.getLocalizedName(), x + 52, y + 46, 0xFFFFFF);
                int j = 0;
                if (this.selected_moon != null) {
                    font.func_78276_b(GCCoreUtil.translate((String)("book.page." + this.system.getUnlocalizedName() + "." + this.selected_moon.getName().toLowerCase())), x + 80 + this.maxX, y + 46, 0xFFFFFF);
                    int offsetY = font.func_78256_a(GCCoreUtil.translate((String)("book.page." + this.system.getUnlocalizedName() + "." + this.selected_moon.getName().toLowerCase()))) / 260 * font.field_78288_b;
                    offsetY -= this.getScroll() * 10;
                    WorldProvider dim = WorldUtil.getProviderForDimensionClient((int)this.selected_moon.getDimensionID());
                    if (dim instanceof IGalacticraftWorldProvider) {
                        BodiesData data;
                        IGalacticraftWorldProvider gcdim = (IGalacticraftWorldProvider)dim;
                        ArrayList<String> infos = new ArrayList<String>();
                        float grav = (0.1f - ((IGalacticraftWorldProvider)dim).getGravity()) * 1000.0f;
                        if (((IGalacticraftWorldProvider)dim).getGravity() == 0.0f) {
                            grav = 0.0f;
                        }
                        infos.add(GCCoreUtil.translate((String)"gui.message.daylength") + " " + ((WorldProviderSpace)gcdim).getDayLength() / 1000L + "h " + ((WorldProviderSpace)gcdim).getDayLength() % 1000L + "m");
                        infos.add("Distance from planet: " + this.selected_moon.getRelativeDistanceFromCenter().unScaledDistance);
                        infos.add(GCCoreUtil.translate((String)"gui.message.gravity") + " " + (int)grav + "%");
                        infos.add(GCCoreUtil.translate((String)"gui.message.temperature") + " " + gcdim.getCelestialBody().atmosphere.thermalLevel() * 20.0f + " C");
                        infos.add(GCCoreUtil.translate((String)"gui.message.windspeed") + " " + gcdim.getCelestialBody().atmosphere.windLevel());
                        if (dim instanceof ISolarLevel) {
                            infos.add(GCCoreUtil.translate((String)"gui.message.solarenergy") + " " + (float)Math.round((((ISolarLevel)dim).getSolarEnergyMultiplier() - 1.0) * 1000.0) / 10.0f + "%");
                        }
                        if (gcdim instanceof IAdvancedSpace) {
                            infos.add(GCCoreUtil.translate((String)"gui.message.windenergy") + " " + (float)Math.round(((IAdvancedSpace)dim).getSolarWindMultiplier() * 1000.0) / 1000.0f);
                        }
                        if ((data = (BodiesData)BodiesHelper.getData().get(this.selected_moon)) != null) {
                            infos.add(GCCoreUtil.translate((String)"gui.message.atmopressure") + " " + data.getPressurePlanet());
                            infos.add(GCCoreUtil.translate((String)"gui.message.solarradiation") + " " + data.getSolarRadiationPlanet());
                        }
                        infos.add(GCCoreUtil.translate((String)"gui.message.breathableatmo") + " " + gcdim.hasBreathableAtmosphere());
                        infos.add("");
                        infos.add(GCCoreUtil.translate((String)"gui.message.resources"));
                        int k = this.getScroll();
                        while (k < infos.size()) {
                            if (!((String)infos.get(k)).isEmpty() && k < 8 + this.getScroll()) {
                                this.mc.func_110434_K().func_110577_a(bookPageTexture);
                                this.drawTexturedModalRect(x + 78 + this.maxX, y + 80 + k * 12 + offsetY, 146.0f, 13.0f, 401.0f, 119.0f, 85.0f, 15.0f, false, false, 512.0f, 256.0f);
                                font.func_78276_b((String)infos.get(k), x + 84 + this.maxX, y + 82 + k * 12 + offsetY, 0xFFFFFF);
                            }
                            ++k;
                            ++j;
                        }
                        if (this.resources.containsKey(this.selected_moon) && this.getScroll() > 3) {
                            k = 0;
                            for (ItemStack stacks : this.resources.get(this.selected_moon)) {
                                this.mc.field_71446_o.func_110577_a(bookPageTexture);
                                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                                if (k < 12) {
                                    this.drawTexturedModalRect(x + 78 + this.maxX + k * 22, y + 108 + infos.size() * 10 + offsetY, 20.0f, 20.0f, 452.0f, 94.0f, 20.0f, 20.0f, false, false, 576.0f, 250.0f);
                                    this.drawItemStack(this.mc, stacks, x + 80 + this.maxX + k * 22, y + 110 + infos.size() * 10 + offsetY, mouseX, mouseY, true);
                                } else {
                                    this.drawTexturedModalRect(x + 78 + this.maxX + (k - 12) * 22, y + 108 + infos.size() * 10 + offsetY + 22, 20.0f, 20.0f, 452.0f, 94.0f, 20.0f, 20.0f, false, false, 576.0f, 250.0f);
                                    this.drawItemStack(this.mc, stacks, x + 80 + this.maxX + (k - 12) * 22, y + 110 + infos.size() * 10 + offsetY + 22, mouseX, mouseY, true);
                                }
                                ++k;
                            }
                        }
                    }
                }
            }
        }
    }

    public void mouseClick(int mouseX, int mouseY, int mouseButton, int x, int y) {
        block3: {
            int offsetX;
            block2: {
                super.mouseClick(mouseX, mouseY, mouseButton, x, y);
                offsetX = 21;
                if (this.current_mode != Mode.LIST) break block2;
                for (int i = this.getScroll(); i < planets.size(); ++i) {
                    if (i >= 8 + this.getScroll()) continue;
                    int yOffset = i - this.getScroll();
                    if (mouseX < x + 44 || mouseX >= x + 40 + 25 + this.maxX || mouseY < y + 41 + offsetX * yOffset || mouseY > y + 41 + offsetX * yOffset + 16) continue;
                    this.selected_body = planets.get(i);
                    this.current_mode = Mode.BODY;
                }
                break block3;
            }
            if (this.current_mode != Mode.BODY) break block3;
            for (int i = 1; i < GalaxyRegistry.getMoonsForPlanet((Planet)((Planet)this.selected_body)).size() + 1; ++i) {
                if (mouseX < x + 44 || mouseX >= x + 40 + 25 + this.maxX || mouseY < y + 41 + offsetX * i || mouseY > y + 41 + offsetX * i + 16) continue;
                this.selected_moon = (Moon)GalaxyRegistry.getMoonsForPlanet((Planet)((Planet)this.selected_body)).get(i - 1);
                this.current_mode = Mode.MOON;
            }
        }
    }

    public boolean hookBackButton() {
        if (this.current_mode == Mode.BODY) {
            this.current_mode = Mode.LIST;
            this.setScroll(0);
            return true;
        }
        if (this.current_mode == Mode.MOON) {
            this.current_mode = Mode.BODY;
            return true;
        }
        return false;
    }

    public String getCategory() {
        return BookUtils.Book_Cateroies.BODIES.getName();
    }

    public int getMaxScroll() {
        if (this.current_mode == Mode.LIST && planets.size() > 8) {
            return planets.size() % 8;
        }
        if (this.current_mode == Mode.BODY || this.current_mode == Mode.MOON) {
            return 5;
        }
        return 0;
    }

    protected void setResources(CelestialBody body, ItemStack ... stack) {
        this.resources.put(body, stack);
    }

    static enum Mode {
        LIST,
        BODY,
        MOON;

    }
}

