/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjw.commands;

import com.gmail.trentech.pjc.help.Help;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.api.world.weather.Weathers;

public class CommandWeather
implements CommandCallable {
    private final Help help = (Help)Help.get((String)"world weather").get();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CommandResult process(CommandSource source, String arguments) throws CommandException {
        String value;
        World world;
        WorldProperties properties;
        block23: {
            int duration;
            block24: {
                String worldName;
                if (arguments.equalsIgnoreCase("weather")) {
                    throw new CommandException(this.getHelp().getUsageText());
                }
                String[] args = arguments.split(" ");
                if (args[args.length - 1].equalsIgnoreCase("--help")) {
                    this.getHelp().execute(source);
                    return CommandResult.success();
                }
                duration = 0;
                try {
                    worldName = args[0];
                }
                catch (Exception e) {
                    throw new CommandException(this.getHelp().getUsageText());
                }
                Optional optionalProperties = Sponge.getServer().getWorldProperties(worldName);
                if (!optionalProperties.isPresent()) {
                    throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, worldName, " does not exist"}), false);
                }
                properties = (WorldProperties)optionalProperties.get();
                Optional optionalWorld = Sponge.getServer().getWorld(properties.getUniqueId());
                if (!optionalWorld.isPresent()) {
                    throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, properties.getWorldName(), " must be loaded"}), false);
                }
                world = (World)optionalWorld.get();
                try {
                    value = args[1];
                }
                catch (Exception e) {
                    if (properties.isRaining()) {
                        source.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "Weather: ", TextColors.WHITE, "rain"}));
                        return CommandResult.success();
                    }
                    if (properties.isThundering()) {
                        source.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "Weather: ", TextColors.WHITE, "thunder"}));
                        return CommandResult.success();
                    }
                    source.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "Weather: ", TextColors.WHITE, "clear"}));
                    return CommandResult.success();
                }
                if (args.length == 3) {
                    try {
                        duration = Integer.parseInt(args[2]);
                    }
                    catch (Exception e) {
                        throw new CommandException(this.getHelp().getUsageText());
                    }
                }
                if (duration != 0) break block24;
                if (value.equalsIgnoreCase("clear")) {
                    world.setWeather(Weathers.CLEAR);
                    break block23;
                } else if (value.equalsIgnoreCase("rain")) {
                    world.setWeather(Weathers.RAIN);
                    break block23;
                } else {
                    if (!value.equalsIgnoreCase("thunder")) {
                        source.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, value, " is not a valid weather type"}));
                        throw new CommandException(this.getHelp().getUsageText());
                    }
                    world.setWeather(Weathers.THUNDER_STORM);
                }
                break block23;
            }
            if (value.equalsIgnoreCase("clear")) {
                world.setWeather(Weathers.CLEAR, (long)duration);
            } else if (value.equalsIgnoreCase("rain")) {
                world.setWeather(Weathers.RAIN, (long)duration);
            } else {
                if (!value.equalsIgnoreCase("thunder")) {
                    source.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, value, " is not a valid weather type"}));
                    throw new CommandException(this.getHelp().getUsageText());
                }
                world.setWeather(Weathers.THUNDER_STORM, (long)duration);
            }
        }
        source.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Set weather of ", properties.getWorldName(), " to ", TextColors.YELLOW, value, TextColors.DARK_GREEN, " for ", TextColors.YELLOW, world.getRemainingDuration()}));
        return CommandResult.success();
    }

    public List<String> getSuggestions(CommandSource source, String arguments, Location<World> targetPosition) throws CommandException {
        ArrayList<String> list = new ArrayList<String>();
        if (arguments.equalsIgnoreCase("weather")) {
            return list;
        }
        String[] args = arguments.split(" ");
        if (args.length == 1) {
            for (WorldProperties world : Sponge.getServer().getAllWorldProperties()) {
                if (world.getWorldName().equalsIgnoreCase(args[0])) {
                    list.add("clear");
                    list.add("thunder");
                    list.add("rain");
                    return list;
                }
                if (!world.getWorldName().toLowerCase().startsWith(args[0].toLowerCase())) continue;
                list.add(world.getWorldName());
            }
        }
        if (args.length == 2) {
            if ("clear".equalsIgnoreCase(args[1]) || "rain".equalsIgnoreCase(args[1]) || "thunder".equalsIgnoreCase(args[1])) {
                return list;
            }
            if ("clear".toLowerCase().startsWith(args[1].toLowerCase())) {
                list.add("clear");
            }
            if ("rain".toLowerCase().startsWith(args[1].toLowerCase())) {
                list.add("rain");
            }
            if ("thunder".toLowerCase().startsWith(args[1].toLowerCase())) {
                list.add("thunder");
            }
        }
        return list;
    }

    public boolean testPermission(CommandSource source) {
        Optional permission = this.getHelp().getPermission();
        if (permission.isPresent()) {
            return source.hasPermission((String)permission.get());
        }
        return true;
    }

    public Optional<Text> getShortDescription(CommandSource source) {
        return Optional.of(Text.of((String)this.getHelp().getDescription()));
    }

    public Optional<Text> getHelp(CommandSource source) {
        return Optional.of(Text.of((String)this.getHelp().getDescription()));
    }

    public Text getUsage(CommandSource source) {
        return this.getHelp().getUsageText();
    }

    public Help getHelp() {
        return this.help;
    }
}

