/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjw.commands;

import com.gmail.trentech.pjc.core.ConfigManager;
import com.gmail.trentech.pjc.help.Help;
import com.gmail.trentech.pjw.Main;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;

public class CommandUnload
implements CommandCallable {
    private final Help help = (Help)Help.get((String)"world unload").get();

    public CommandResult process(CommandSource source, String arguments) throws CommandException {
        if (arguments.equalsIgnoreCase("unload")) {
            throw new CommandException(this.getHelp().getUsageText());
        }
        if (arguments.equalsIgnoreCase("--help")) {
            this.help.execute(source);
            return CommandResult.success();
        }
        Optional optionalProperties = Sponge.getServer().getWorldProperties(arguments);
        if (!optionalProperties.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, arguments, " does not exist"}), false);
        }
        WorldProperties properties = (WorldProperties)optionalProperties.get();
        Optional optionalWorld = Sponge.getServer().getWorld(properties.getWorldName());
        if (!optionalWorld.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, properties.getWorldName(), " is already unloaded"}), false);
        }
        World world = (World)optionalWorld.get();
        if (world.getUniqueId().toString().equals(ConfigManager.get((PluginContainer)Main.getPlugin()).getConfig().getNode(new Object[]{"options", "world_root"}).getString())) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "You cannot unload the default world"}), false);
        }
        CommentedConfigurationNode node = ConfigManager.get((PluginContainer)Main.getPlugin()).getConfig().getNode(new Object[]{"options"});
        World defaultWorld = (World)Sponge.getServer().getWorld(((WorldProperties)Sponge.getServer().getDefaultWorld().get()).getWorldName()).get();
        String joinWorldName = node.getNode(new Object[]{"first_join", "world"}).getString();
        optionalWorld = Sponge.getServer().getWorld(joinWorldName);
        if (optionalWorld.isPresent()) {
            defaultWorld = (World)optionalWorld.get();
        }
        for (Entity entity : world.getEntities()) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            player.setLocationSafely(defaultWorld.getSpawnLocation());
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, properties.getWorldName(), " is being unloaded"}));
        }
        if (!Sponge.getServer().unloadWorld(world)) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "Could not unload ", properties.getWorldName()}), false);
        }
        source.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, properties.getWorldName(), " unloaded successfully"}));
        return CommandResult.success();
    }

    public List<String> getSuggestions(CommandSource source, String arguments, Location<World> targetPosition) throws CommandException {
        ArrayList<String> list = new ArrayList<String>();
        if (arguments.equalsIgnoreCase("unload")) {
            return list;
        }
        for (WorldProperties world : Sponge.getServer().getAllWorldProperties()) {
            if (world.getWorldName().equalsIgnoreCase(arguments)) {
                return list;
            }
            if (!world.getWorldName().toLowerCase().startsWith(arguments.toLowerCase())) continue;
            list.add(world.getWorldName());
        }
        return list;
    }

    public boolean testPermission(CommandSource source) {
        Optional permission = this.getHelp().getPermission();
        if (permission.isPresent()) {
            return source.hasPermission((String)permission.get());
        }
        return true;
    }

    public Optional<Text> getShortDescription(CommandSource source) {
        return Optional.of(Text.of((String)this.getHelp().getDescription()));
    }

    public Optional<Text> getHelp(CommandSource source) {
        return Optional.of(Text.of((String)this.getHelp().getDescription()));
    }

    public Text getUsage(CommandSource source) {
        return this.getHelp().getUsageText();
    }

    public Help getHelp() {
        return this.help;
    }
}

