/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjw.commands;

import com.gmail.trentech.pjc.help.Help;
import com.gmail.trentech.pjw.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;

public class CommandTime
implements CommandCallable {
    private final Help help = (Help)Help.get((String)"world time").get();

    public CommandResult process(CommandSource source, String arguments) throws CommandException {
        String value;
        String worldName;
        if (arguments.equalsIgnoreCase("time")) {
            throw new CommandException(this.getHelp().getUsageText());
        }
        String[] args = arguments.split(" ");
        if (args[args.length - 1].equalsIgnoreCase("--help")) {
            this.getHelp().execute(source);
            return CommandResult.success();
        }
        long time = 0L;
        try {
            worldName = args[0];
        }
        catch (Exception e) {
            throw new CommandException(this.getHelp().getUsageText());
        }
        Optional optionalProperties = Sponge.getServer().getWorldProperties(worldName);
        if (!optionalProperties.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, worldName, " does not exist"}), false);
        }
        WorldProperties world = (WorldProperties)optionalProperties.get();
        try {
            value = args[1];
        }
        catch (Exception e) {
            source.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "Time: ", TextColors.WHITE, Utils.getTime(world.getWorldTime()), TextColors.GREEN, " Ticks: ", TextColors.WHITE, world.getWorldTime() % 24000L}));
            return CommandResult.success();
        }
        try {
            time = Long.parseLong(value);
        }
        catch (Exception e) {
            throw new CommandException(this.getHelp().getUsageText());
        }
        if (time < 0L || time > 24000L) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "Time value must be between 0 - 24000"}), false);
        }
        world.setWorldTime(time);
        Sponge.getServer().saveWorldProperties(world);
        source.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Set time of ", world.getWorldName(), " to ", TextColors.YELLOW, Utils.getTime(world.getWorldTime())}));
        return CommandResult.success();
    }

    public List<String> getSuggestions(CommandSource source, String arguments, Location<World> targetPosition) throws CommandException {
        ArrayList<String> list = new ArrayList<String>();
        if (arguments.equalsIgnoreCase("time")) {
            return list;
        }
        String[] args = arguments.split(" ");
        if (args.length == 1) {
            for (WorldProperties world : Sponge.getServer().getAllWorldProperties()) {
                if (world.getWorldName().equalsIgnoreCase(args[0])) {
                    return list;
                }
                if (!world.getWorldName().toLowerCase().startsWith(args[0].toLowerCase())) continue;
                list.add(world.getWorldName());
            }
        }
        return list;
    }

    public boolean testPermission(CommandSource source) {
        Optional permission = this.getHelp().getPermission();
        if (permission.isPresent()) {
            return source.hasPermission((String)permission.get());
        }
        return true;
    }

    public Optional<Text> getShortDescription(CommandSource source) {
        return Optional.of(Text.of((String)this.getHelp().getDescription()));
    }

    public Optional<Text> getHelp(CommandSource source) {
        return Optional.of(Text.of((String)this.getHelp().getDescription()));
    }

    public Text getUsage(CommandSource source) {
        return this.getHelp().getUsageText();
    }

    public Help getHelp() {
        return this.help;
    }
}

