/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.itemblacklist.client;

import java.lang.reflect.Field;
import net.doubledoordev.itemblacklist.util.ItemBlacklisted;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderItemInFrameEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ClientEventHandlers {
    public static final ClientEventHandlers I = new ClientEventHandlers();
    private static final Field guiLeftField = ReflectionHelper.findField(GuiContainer.class, (String)"guiLeft", (String)"field_147003_i");
    private static final Field guiTopField = ReflectionHelper.findField(GuiContainer.class, (String)"guiTop", (String)"field_147009_r");

    private ClientEventHandlers() {
    }

    public static void init() {
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        renderItem.func_175037_a().func_178086_a((Item)ItemBlacklisted.I, 0, new ModelResourceLocation(ItemBlacklisted.I.getRegistryName(), "inventory"));
    }

    @SubscribeEvent
    public void drawScreenEvent(GuiScreenEvent.DrawScreenEvent.Post event) throws IllegalAccessException {
        if (event.getGui() instanceof GuiContainer) {
            GuiContainer container = (GuiContainer)event.getGui();
            if (container.field_147002_h == null) {
                return;
            }
            int guiLeft = guiLeftField.getInt(container);
            int guiTop = guiTopField.getInt(container);
            for (Slot slot : container.field_147002_h.field_75151_b) {
                ItemStack stack;
                if (slot == null || (stack = slot.func_75211_c()).func_190926_b() || stack.func_77973_b() != ItemBlacklisted.I) continue;
                if (!ItemBlacklisted.canUnpack(stack)) {
                    return;
                }
                ItemStack unpacked = ItemBlacklisted.unpack(stack);
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)guiLeft, (float)guiTop, (float)1.0f);
                GlStateManager.func_179109_b((float)(slot.field_75223_e + 8), (float)(slot.field_75221_f + 8), (float)1.0f);
                GlStateManager.func_179152_a((float)15.0f, (float)-15.0f, (float)10.0f);
                Minecraft.func_71410_x().func_175599_af().func_181564_a(unpacked, ItemCameraTransforms.TransformType.FIXED);
                GlStateManager.func_179121_F();
            }
        }
    }

    @SubscribeEvent
    public void itemTooltipEvent(ItemTooltipEvent event) {
        if (event.getItemStack().func_77973_b() == ItemBlacklisted.I) {
            event.getToolTip().add(1, TextFormatting.RED + "Banned Item");
        }
    }

    @SubscribeEvent
    public void renderItemInFrameEvent(RenderItemInFrameEvent event) {
        ItemStack stack = event.getItem();
        if (stack.func_190926_b() || stack.func_77973_b() != ItemBlacklisted.I) {
            return;
        }
        if (!ItemBlacklisted.canUnpack(stack)) {
            return;
        }
        ItemStack unpacked = ItemBlacklisted.unpack(stack);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.func_179123_a();
        RenderHelper.func_74519_b();
        GlStateManager.func_179137_b((double)0.001, (double)-0.001, (double)0.001);
        Minecraft.func_71410_x().func_175599_af().func_181564_a(unpacked, ItemCameraTransforms.TransformType.FIXED);
        RenderHelper.func_74518_a();
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    public void onRenderGUI(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            Minecraft mc = Minecraft.func_71410_x();
            ScaledResolution res = event.getResolution();
            if (!mc.field_71439_g.func_175149_v()) {
                for (int slot = 0; slot < 9; ++slot) {
                    ItemStack stack = (ItemStack)mc.field_71439_g.field_71071_by.field_70462_a.get(slot);
                    if (stack.func_190926_b() || stack.func_77973_b() != ItemBlacklisted.I) continue;
                    int x = res.func_78326_a() / 2 - 90 + slot * 20 + 2;
                    int y = res.func_78328_b() - 16 - 3;
                    if (!ItemBlacklisted.canUnpack(stack)) continue;
                    ItemStack unpacked = ItemBlacklisted.unpack(stack);
                    mc.func_175599_af().func_175042_a(unpacked, x, y);
                }
            }
        }
    }
}

