/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.utils;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.source.ConsoleSource;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;

public class LogUtils {
    private static Logger LOGGER;
    private static ConsoleSource CONSOLE;

    public static void init(Logger log) {
        LOGGER = log;
        CONSOLE = Sponge.getGame().getServer().getConsole();
    }

    public static void log(Exception exception) {
        LogUtils.log(exception.getStackTrace().toString());
    }

    public static void log(String message) {
        LOGGER.log(Level.INFO, "Universe Guard 2: " + message);
    }

    public static void print(String message, String caller) {
        LogUtils.print(TextColors.YELLOW, message, caller);
    }

    public static void print(TextColor color, String message, String caller) {
        CONSOLE.sendMessage(Text.of((Object[])new Object[]{color, "Universe Guard 2", "[", caller, "]: ", message}));
    }
}

