/*
 * Decompiled with CFR 0.152.
 */
package fr.nocturne123.questionstime.question;

import fr.nocturne123.questionstime.QuestionsTime;
import fr.nocturne123.questionstime.handler.ConfigHandler;
import fr.nocturne123.questionstime.question.Question;
import fr.nocturne123.questionstime.question.QuestionMulti;
import fr.nocturne123.questionstime.question.component.Malus;
import fr.nocturne123.questionstime.question.component.Prize;
import fr.nocturne123.questionstime.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.inventory.ItemStack;

public class QuestionCreator {
    private String question;
    private String answer;
    private String previousResponse;
    private Question.Types questionType;
    private UUID creator;
    private int currentStep;
    private int registerStep;
    private boolean halfConfirm;
    private boolean confirm;
    private List<String> propositions;
    private boolean announcePrize;
    private boolean announceMalus;
    private int moneyPrize;
    private int moneyMalus;
    private List<ItemStack> itemsPrize;
    private int timer;
    private int timeBetweenAnswer;

    public QuestionCreator(UUID uuid) {
        this.creator = uuid;
        this.currentStep = 0;
        this.propositions = new ArrayList<String>();
        this.itemsPrize = new ArrayList<ItemStack>();
    }

    public UUID getCreator() {
        return this.creator;
    }

    public int getCurrentStep() {
        return this.currentStep;
    }

    public void nextStep() {
        switch (this.currentStep) {
            case -1: {
                if (this.previousResponse.equals("yes")) {
                    this.stop();
                    break;
                }
                this.resume();
                break;
            }
            case 0: {
                this.question = this.previousResponse;
                break;
            }
            case 1: {
                if (this.previousResponse.equals("simple")) {
                    this.questionType = Question.Types.SIMPLE;
                    ++this.currentStep;
                    break;
                }
                if (this.previousResponse.equals("proposition")) {
                    this.questionType = Question.Types.MULTI;
                    break;
                }
                QuestionsTime.getInstance().getLogger().error("Error when creating a question > the \"previousResponse\" isn't simple or proposition {\"" + this.previousResponse + "\"");
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.answer = this.previousResponse;
                break;
            }
            case 4: {
                if (!this.previousResponse.equals("no")) break;
                if (!QuestionsTime.getInstance().getEconomy().isPresent()) {
                    this.currentStep += 6;
                    break;
                }
                this.currentStep += 3;
                break;
            }
            case 5: {
                this.announcePrize = this.previousResponse.equals("yes");
                if (QuestionsTime.getInstance().getEconomy().isPresent()) break;
                ++this.currentStep;
                break;
            }
            case 6: {
                if (Integer.valueOf(this.previousResponse) <= 0) {
                    this.moneyPrize = 0;
                    break;
                }
                this.moneyPrize = Integer.valueOf(this.previousResponse);
                break;
            }
            case 7: {
                if (QuestionsTime.getInstance().getEconomy().isPresent()) break;
                this.currentStep += 3;
                break;
            }
            case 8: {
                if (!this.previousResponse.equals("no")) break;
                this.currentStep += 2;
                break;
            }
            case 9: {
                this.announceMalus = this.previousResponse.equals("yes");
                if (QuestionsTime.getInstance().getEconomy().isPresent()) break;
                ++this.currentStep;
                break;
            }
            case 10: {
                if (Integer.valueOf(this.previousResponse) <= 0) {
                    this.moneyMalus = 0;
                    break;
                }
                this.moneyMalus = Integer.valueOf(this.previousResponse);
                break;
            }
            case 11: {
                if (!this.previousResponse.equals("no")) break;
                ++this.currentStep;
                break;
            }
            case 12: {
                String timeHour = StringUtils.substringBefore((String)this.previousResponse, (String)"h");
                String timeMinute = StringUtils.substringBetween((String)this.previousResponse, (String)"h", (String)"m");
                String timeSecond = StringUtils.substringBetween((String)this.previousResponse, (String)"m", (String)"s");
                this.timer = Integer.valueOf(timeHour) * 3600 + Integer.valueOf(timeMinute) * 60 + Integer.valueOf(timeSecond);
                break;
            }
            case 13: {
                if (!this.previousResponse.equals("no")) break;
                ++this.currentStep;
                break;
            }
            case 14: {
                String timeHourAnswer = StringUtils.substringBefore((String)this.previousResponse, (String)"h");
                String timeMinuteAnswer = StringUtils.substringBetween((String)this.previousResponse, (String)"h", (String)"m");
                String timeSecondAnswer = StringUtils.substringBetween((String)this.previousResponse, (String)"m", (String)"s");
                this.timeBetweenAnswer = Integer.valueOf(timeHourAnswer) * 3600 + Integer.valueOf(timeMinuteAnswer) * 60 + Integer.valueOf(timeSecondAnswer);
                break;
            }
            case 15: {
                if (this.previousResponse.equals("start")) {
                    this.finish(true);
                } else if (this.previousResponse.equals("save")) {
                    this.finish(false);
                }
                ((Player)Sponge.getServer().getPlayer(this.creator).get()).sendMessage(TextUtils.creatorNormalWithPrefix("OK, you leaving the Question Creator"));
                QuestionsTime.getInstance().removeCreator(this.creator);
            }
        }
        ++this.currentStep;
        this.confirm = false;
        this.halfConfirm = false;
    }

    public void finish(boolean ask) {
        ItemStack[] items = new ItemStack[this.itemsPrize.size()];
        items = this.itemsPrize.toArray(items);
        Prize prize = new Prize(this.moneyPrize, this.announcePrize, items);
        Malus malus = new Malus(this.moneyMalus, this.announceMalus);
        if (this.questionType == Question.Types.MULTI) {
            QuestionMulti multiQ = ((QuestionMulti.QuestionMultiBuilder)((QuestionMulti.QuestionMultiBuilder)((QuestionMulti.QuestionMultiBuilder)((QuestionMulti.QuestionMultiBuilder)((QuestionMulti.QuestionMultiBuilder)QuestionMulti.builder().setAnswer(Byte.valueOf(this.answer)).setQuestion(this.question)).setPrize(prize)).setMalus(malus)).setTimer(this.timer)).addPropositions(this.propositions).setTimeBetweenAnswer(this.timeBetweenAnswer)).build();
            if (ask) {
                QuestionsTime.getInstance().addQuestion(multiQ);
            }
            ConfigHandler.serializeQuestion(multiQ);
        } else {
            Question q = ((Question.QuestionBuilder)((Question.QuestionBuilder)((Question.QuestionBuilder)((Question.QuestionBuilder)((Question.QuestionBuilder)((Question.QuestionBuilder)Question.builder().setQuestion(this.question)).setAnswer(this.answer)).setPrize(prize)).setMalus(malus)).setTimer(this.timer)).setTimeBetweenAnswer(this.timeBetweenAnswer)).build();
            if (ask) {
                QuestionsTime.getInstance().addQuestion(q);
            }
            ConfigHandler.serializeQuestion(q);
        }
    }

    public void setStop() {
        this.registerStep = this.currentStep;
        this.currentStep = -1;
        this.halfConfirm = false;
        this.confirm = false;
    }

    public void resume() {
        this.currentStep = this.registerStep - 1;
        this.registerStep = 0;
        this.halfConfirm = false;
        this.confirm = false;
    }

    public void stop() {
        this.currentStep = -42;
        ((Player)Sponge.getServer().getPlayer(this.creator).get()).sendMessage(TextUtils.creatorNormalWithPrefix("OK, you leaving the Question Creator"));
        QuestionsTime.getInstance().removeCreator(this.creator);
    }

    public boolean isConfirm() {
        return this.confirm;
    }

    public void setConfirm() {
        this.confirm = true;
    }

    public void setPreviousResponse(String previousResponse) {
        this.previousResponse = previousResponse;
    }

    public Question.Types getQuestionType() {
        return this.questionType;
    }

    public void setHalfConfirm() {
        this.halfConfirm = true;
        this.confirm = false;
    }

    public boolean isHalfConfirm() {
        return this.halfConfirm;
    }

    public List<String> getPropositions() {
        return this.propositions;
    }

    public void addItemPrize(ItemStack is) {
        for (ItemStack itemStack : this.itemsPrize) {
            if (!itemStack.equalTo(is)) continue;
            itemStack.setQuantity(itemStack.getQuantity() + is.getQuantity());
            return;
        }
        this.itemsPrize.add(is);
    }
}

