/*
 * Decompiled with CFR 0.152.
 */
package fr.nocturne123.questionstime.handler;

import fr.nocturne123.questionstime.QuestionsTime;
import fr.nocturne123.questionstime.message.Message;
import fr.nocturne123.questionstime.util.TextUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.api.command.source.ConsoleSource;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextTemplate;

public class MessageHandler {
    private static HashMap<String, TextTemplate> messages;
    private static ConsoleSource console;

    public static void init(Path path) {
        try {
            MessageHandler.loadDefaultMessages();
            if (path != null) {
                console.sendMessage(TextUtils.Console.creatorNormalWithPrefix("Loading messages..."));
                if (Files.notExists(Paths.get(path.toString(), "message.conf"), new LinkOption[0])) {
                    QuestionsTime.getInstance().getContainer().getAsset("message.conf").ifPresent(asset -> {
                        try {
                            asset.copyToDirectory(path, false, true);
                            console.sendMessage(TextUtils.Console.creatorNormalWithPrefix("The message file was not found, the default message file has been created"));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    });
                } else {
                    MessageHandler.loadMessages(Paths.get(path.toString(), "message.conf"));
                }
            } else {
                console.sendMessage(TextUtils.Console.creatorNormalWithPrefix("The message.conf was not found, the default messages will be used"));
            }
        }
        catch (Exception e) {
            console.sendMessage(TextUtils.Console.creatorError("Error when loading the message.conf"));
            e.printStackTrace();
        }
    }

    private static void loadMessages(Path path) {
        CommentedConfigurationNode root;
        int changedMessages = 0;
        HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(path)).build();
        try {
            root = (CommentedConfigurationNode)loader.load();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        for (Map.Entry<String, TextTemplate> entry : messages.entrySet()) {
            try {
                String section = entry.getKey();
                TextTemplate defaultValue = entry.getValue();
                CommentedConfigurationNode node = root.getNode((Object[])section.split("\\."));
                String value = node.getString();
                if (value != null) {
                    TreeSet componentsText;
                    if (defaultValue.toText().toPlain().equals(value)) continue;
                    TreeSet componentsDefault = new TreeSet(defaultValue.getArguments().keySet());
                    if (((Object)componentsDefault).equals(componentsText = new TreeSet(MessageHandler.messageToTextTemplate(value).getArguments().keySet()))) {
                        messages.put(section, MessageHandler.messageToTextTemplate(value));
                        ++changedMessages;
                        continue;
                    }
                    if (componentsDefault.isEmpty()) {
                        console.sendMessage(TextUtils.Console.creatorError("  The section \"" + section + "\" shall not have components"));
                        continue;
                    }
                    if (componentsText.size() > componentsDefault.size()) {
                        console.sendMessage(TextUtils.Console.creatorError("  The section \"" + section + "\" have more component(s) that needed, he only need : " + componentsDefault));
                        continue;
                    }
                    if (componentsText.size() == componentsDefault.size()) {
                        console.sendMessage(TextUtils.Console.creatorError("  The section \"" + section + "\" doesn't have the right component(s), he need : " + componentsDefault));
                        continue;
                    }
                    if (componentsText.size() >= componentsDefault.size()) continue;
                    console.sendMessage(TextUtils.Console.creatorError("  The section \"" + section + "\" have less component(s) that needed, he need : " + componentsDefault));
                    continue;
                }
                console.sendMessage(TextUtils.Console.creatorError("  Error when reading the text for the section \"" + section + "\". does it exist ?"));
            }
            catch (Exception e) {
                console.sendMessage(TextUtils.Console.creatorError("Error when reading \"messages.conf\""));
                e.printStackTrace();
            }
        }
        console.sendMessage(TextUtils.Console.creatorNormalWithPrefix("Messages loaded, " + changedMessages + "/" + messages.size() + " replaced"));
    }

    private static void loadDefaultMessages() {
        messages = new HashMap();
        for (Messages message : Messages.values()) {
            messages.put(message.section, MessageHandler.messageToTextTemplate(message.message));
        }
    }

    public static Text get(Messages message) {
        if (messages.containsKey(message.getSection())) {
            TextTemplate messageRegistered = messages.get(message.getSection());
            if (messageRegistered.getArguments().isEmpty()) {
                return Text.of((Object[])new Object[]{messageRegistered});
            }
            return Text.EMPTY;
        }
        return Text.EMPTY;
    }

    public static Text get(Message message) {
        if (messages.containsKey(message.getSection())) {
            TextTemplate messageRegistered = messages.get(message.getSection());
            int componentSize = messageRegistered.getArguments().size();
            if (message.getComponentSize() == componentSize) {
                return message.getFormattedMessage();
            }
            QuestionsTime.getInstance().getLogger().warn("The message \"" + message.getSection() + "\" required " + componentSize + " components but " + message.getComponentSize() + " was give,");
        }
        return Text.EMPTY;
    }

    private static TextTemplate messageToTextTemplate(String message) {
        String[] splitArg = message.split("(?=\\{)|(?<=})");
        Object[] template = new Object[splitArg.length];
        for (int i = 0; i < splitArg.length; ++i) {
            String str = splitArg[i];
            template[i] = str.startsWith("{") && str.endsWith("}") ? TextTemplate.arg((String)str.substring(1, str.length() - 1)).build() : str;
        }
        return TextTemplate.of((Object[])template);
    }

    public static TextTemplate getTextTemplate(Messages message) {
        return messages.get(message.getSection());
    }

    static {
        console = QuestionsTime.getInstance().getConsole();
    }

    public static enum Messages {
        QUESTION_NEW("question.new", "\u00a7eIt's Question Time !"),
        QUESTION_ASK("question.ask", "\u00a7e\u00a7l{question}"),
        QUESTION_PROPOSITION("question.proposition", "\u00a7b\u2022{position}] {proposition}"),
        QUESTION_END("question.end", "\u00a7eMay the best win !"),
        QUESTION_TIMER_END("question.timer.end", "\u00a7eYou have \u00a79\u00a7l{timer}\u00a7r\u00a7e to answer ! May the best win !"),
        QUESTION_TIMER_LEFT("question.timer.left", "\u00a7eYou have \u00a79\u00a7l{timer}\u00a7r\u00a7e to answer !"),
        QUESTION_TIMER_OUT("question.timer.out", "\u00a7cNobody have found the answer, maybe a next time"),
        PRIZE_ANNOUNCE("prize.announce", "\u00a7eThe winner win :"),
        PRIZE_MONEY("prize.money", "\u00a79\u2022{money} \u00a7r{currency}"),
        PRIZE_ITEM("prize.item", "\u00a79\u2022 {quantity} * {modid}\u00a7f{item} \u00a7b{metadata}"),
        MALUS_ANNOUNCE("malus.announce", "\u00a7cBut a wrong answer :"),
        MALUS_MONEY("malus.money", "\u00a74\u2022 -{money} \u00a7r{currency}"),
        ANSWER_ANNOUNCE("answer.announce", "\u00a7eAnswer with : \"\u00a7bqt>answer\u00a7e\""),
        ANSWER_WIN("answer.win", "\u00a7e\u00a7lYou win !"),
        ANSWER_WIN_ANNOUNCE("answer.win-announce", "\u00a7e\u00a7l{name} win !"),
        ANSWER_FALSE("answer.false", "\u00a7e\u00a7l{answer} \u00a7cisn't the right answer :("),
        ANSWER_MALUS("answer.malus", "\u00a7cYou lose \u00a74{money} \u00a7r{currency}"),
        ANSWER_COOLDOWN("answer.cooldown", "\u00a7cYou have to wait {timer} to suggest an another answer"),
        REWARD_ANNOUNCE("reward.announce", "\u00a7e\u00a7lHere's your reward :"),
        REWARD_PRIZE("reward.prize", "\u00a79\u2022 {quantity} * {modid}\u00a7f{item} \u00a7b{metadata}"),
        REWARD_MONEY("reward.money", "\u00a79\u2022{money} \u00a7r{currency}");

        private String section;
        private String message;

        private Messages(String path, String message) {
            this.section = path;
            this.message = message;
        }

        public String getSection() {
            return this.section;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

