/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import com.raoulvdberge.refinedstorage.api.network.item.INetworkItem;
import com.raoulvdberge.refinedstorage.api.network.item.INetworkItemHandler;
import com.raoulvdberge.refinedstorage.apiimpl.network.item.NetworkItemWirelessGrid;
import javax.annotation.Nonnull;
import net.machinemuse.numina.config.NuminaConfig;
import net.machinemuse.numina.energy.ElectricItemUtils;
import net.machinemuse.numina.item.MuseItemUtils;
import net.machinemuse.numina.math.MuseMathUtils;
import net.machinemuse.numina.misc.ModCompatibility;
import net.machinemuse.numina.module.EnumModuleCategory;
import net.machinemuse.numina.module.EnumModuleTarget;
import net.machinemuse.numina.module.IRightClickModule;
import net.machinemuse.powersuits.common.ModuleManager;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RefinedStorageWirelessModule
extends PowerModuleBase
implements IRightClickModule {
    public static final ResourceLocation wirelessGridRegName = new ResourceLocation("refinedstorage", "wireless_grid");
    public static final ResourceLocation wirelessCraftingGridRegName = new ResourceLocation("refinedstorage", "wireless_crafting_grid");

    public RefinedStorageWirelessModule(EnumModuleTarget moduleTarget) {
        super(moduleTarget);
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize((ItemStack)ItemComponent.controlCircuit, (int)1));
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), RefinedStorageWirelessModule.getEmulatedTool());
    }

    public static NBTTagCompound getModululeTag(ItemStack itemStackIn) {
        return itemStackIn.func_77978_p().func_74775_l("mmmpsmod").func_74775_l("Refined Storage Wireless Grid");
    }

    @Nonnull
    public static INetworkItem provide(INetworkItemHandler handler, EntityPlayer player, ItemStack itemStackIn) {
        ItemStack emulatedTool = RefinedStorageWirelessModule.getEmulatedTool();
        NBTTagCompound tag = RefinedStorageWirelessModule.getModululeTag(itemStackIn);
        emulatedTool.func_77982_d(tag);
        return new NetworkItemWirelessGrid(handler, player, emulatedTool);
    }

    static ItemStack getEmulatedTool() {
        if (ModCompatibility.isWirelessCraftingGridLoaded()) {
            return new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)wirelessCraftingGridRegName), 1, 0);
        }
        return new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)wirelessGridRegName), 1, 0);
    }

    public EnumModuleCategory getCategory() {
        return EnumModuleCategory.CATEGORY_TOOL;
    }

    public String getDataName() {
        return "refinedStorageWirelessGrid";
    }

    public ActionResult onItemRightClick(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        NBTTagCompound tag = RefinedStorageWirelessModule.getModululeTag(itemStackIn);
        ItemStack emulatedTool = RefinedStorageWirelessModule.getEmulatedTool();
        if (tag != null) {
            if (!this.isModuleTagValid(tag)) {
                tag = this.initializeDefaults(tag);
            }
            if (!this.isModuleTagSet(tag)) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
            }
            int energy = (int)MuseMathUtils.clampDouble((double)((double)ElectricItemUtils.getPlayerEnergy((EntityPlayer)playerIn) * NuminaConfig.INSTANCE.getRSRatio()), (double)0.0, (double)3500.0);
            tag.func_74768_a("Energy", energy);
            emulatedTool.func_77982_d(tag);
            ActionResult result = emulatedTool.func_77973_b().func_77659_a(worldIn, playerIn, hand);
            double energyUsed = (double)(energy - emulatedTool.func_77978_p().func_74762_e("Energy")) * NuminaConfig.INSTANCE.getRSRatio();
            ElectricItemUtils.drainPlayerEnergy((EntityPlayer)playerIn, (int)((int)energyUsed));
            return ActionResult.newResult((EnumActionResult)result.func_188397_a(), (Object)itemStackIn);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
    }

    public EnumActionResult onItemUse(ItemStack itemStackIn, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        NBTTagCompound tag = RefinedStorageWirelessModule.getModululeTag(itemStackIn);
        ItemStack emulatedTool = RefinedStorageWirelessModule.getEmulatedTool();
        emulatedTool.func_77982_d(tag);
        EnumActionResult result = emulatedTool.func_179546_a(playerIn, worldIn, pos, hand, facing, hitX, hitY, hitZ);
        NBTTagCompound tag2 = emulatedTool.func_77978_p();
        if (tag2 != null) {
            if (tag2.func_74764_b("Initialized")) {
                tag.func_74768_a("Initialized", 1);
            }
            if (tag2.func_74764_b("SearchBoxMode")) {
                tag.func_74768_a("SearchBoxMode", tag2.func_74762_e("SearchBoxMode"));
            }
            if (tag2.func_74764_b("SortingType")) {
                tag.func_74768_a("SortingType", tag2.func_74762_e("SortingType"));
            }
            if (tag2.func_74764_b("DimensionID")) {
                tag.func_74768_a("DimensionID", tag2.func_74762_e("DimensionID"));
            }
            if (tag2.func_74764_b("ViewType")) {
                tag.func_74768_a("ViewType", tag2.func_74762_e("ViewType"));
            }
            if (tag2.func_74764_b("GridX")) {
                tag.func_74768_a("GridX", tag2.func_74762_e("GridX"));
            }
            if (tag2.func_74764_b("GridY")) {
                tag.func_74768_a("GridY", tag2.func_74762_e("GridY"));
            }
            if (tag2.func_74764_b("GridZ")) {
                tag.func_74768_a("GridZ", tag2.func_74762_e("GridZ"));
            }
            if (tag2.func_74764_b("ControllerX")) {
                tag.func_74768_a("ControllerX", tag2.func_74762_e("ControllerX"));
            }
            if (tag2.func_74764_b("ControllerY")) {
                tag.func_74768_a("ControllerY", tag2.func_74762_e("ControllerY"));
            }
            if (tag2.func_74764_b("ControllerZ")) {
                tag.func_74768_a("ControllerZ", tag2.func_74762_e("ControllerZ"));
            }
        }
        return result;
    }

    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return EnumActionResult.PASS;
    }

    public void onPlayerStoppedUsing(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
    }

    public int getEnergyUsage(@Nonnull ItemStack itemStack) {
        return 0;
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(RefinedStorageWirelessModule.getEmulatedTool()).func_177554_e();
    }

    private NBTTagCompound initializeDefaults(NBTTagCompound nbt) {
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        if (!nbt.func_74764_b("ViewType")) {
            nbt.func_74768_a("ViewType", 0);
        }
        if (!nbt.func_74764_b("SortingDirection")) {
            nbt.func_74768_a("SortingDirection", 1);
        }
        if (!nbt.func_74764_b("SortingType")) {
            nbt.func_74768_a("SortingType", 0);
        }
        if (!nbt.func_74764_b("SearchBoxMode")) {
            nbt.func_74768_a("SearchBoxMode", 0);
        }
        return nbt;
    }

    public boolean isModuleTagSet(NBTTagCompound nbt) {
        if (nbt == null) {
            return false;
        }
        return nbt.func_74764_b("ControllerY") && nbt.func_74764_b("ControllerY") && nbt.func_74764_b("ControllerZ") && nbt.func_74764_b("DimensionID");
    }

    public boolean isModuleTagValid(NBTTagCompound nbt) {
        if (nbt == null) {
            return false;
        }
        return nbt.func_74764_b("ViewType") && nbt.func_74764_b("SortingDirection") && nbt.func_74764_b("SortingType") && nbt.func_74764_b("SearchBoxMode");
    }
}

