/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.builders;

import com.google.common.base.Preconditions;
import net.minecraft.world.gen.feature.WorldGenDesertWells;
import org.spongepowered.api.world.gen.PopulatorObject;
import org.spongepowered.api.world.gen.populator.DesertWell;

public class DesertWellBuilder
implements DesertWell.Builder {
    private double p;
    private PopulatorObject obj;

    public DesertWellBuilder() {
        this.reset();
    }

    @Override
    public DesertWell.Builder probability(double p) {
        Preconditions.checkArgument((!Double.isNaN(p) ? 1 : 0) != 0, (Object)"The probability must be a number.");
        Preconditions.checkArgument((!Double.isInfinite(p) ? 1 : 0) != 0, (Object)"The probability cannot be infinite.");
        this.p = p;
        return this;
    }

    @Override
    public DesertWell.Builder wellObject(PopulatorObject obj) {
        this.obj = (PopulatorObject)Preconditions.checkNotNull((Object)obj);
        return this;
    }

    @Override
    public DesertWell.Builder from(DesertWell value) {
        this.probability(value.getSpawnProbability());
        this.wellObject(value.getWellObject());
        return this;
    }

    @Override
    public DesertWell.Builder reset() {
        this.p = 0.001;
        return this;
    }

    @Override
    public DesertWell build() throws IllegalStateException {
        Preconditions.checkState((this.obj != null ? 1 : 0) != 0);
        DesertWell populator = (DesertWell)new WorldGenDesertWells();
        populator.setSpawnProbability(this.p);
        populator.setWellObject(this.obj);
        return populator;
    }
}

