/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.user;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.common.service.user.UserDiscoverer;

public class SpongeUserStorageService
implements UserStorageService {
    public static final UUID FAKEPLAYER_UUID = UUID.fromString("41C82C87-7AfB-4024-BA57-13D2C99CAE77");
    public static final GameProfile FAKEPLAYER_PROFILE = (GameProfile)new com.mojang.authlib.GameProfile(FAKEPLAYER_UUID, null);

    @Override
    public Optional<User> get(UUID uniqueId) {
        try {
            return Optional.ofNullable(UserDiscoverer.findByProfile(Sponge.getServer().getGameProfileManager().get((UUID)Preconditions.checkNotNull((Object)uniqueId, (Object)"uniqueId")).get()));
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Error looking up GameProfile!", e);
        }
    }

    @Override
    public Optional<User> get(String lastKnownName) {
        Preconditions.checkNotNull((Object)lastKnownName, (Object)"lastKnownName");
        Preconditions.checkArgument((lastKnownName.length() > 0 && lastKnownName.length() <= 16 ? 1 : 0) != 0, (String)"Invalid username %s", (Object)lastKnownName);
        Preconditions.checkState((boolean)Sponge.isServerAvailable(), (Object)"Server is not available!");
        return Optional.ofNullable(UserDiscoverer.findByUsername(lastKnownName));
    }

    @Override
    public Optional<User> get(GameProfile profile) {
        return Optional.ofNullable(UserDiscoverer.findByProfile(profile));
    }

    @Override
    public User getOrCreate(GameProfile profile) {
        Optional<User> user;
        if (profile.getUniqueId() == null) {
            String name = profile.getName().orElse(null);
            profile = (GameProfile)new com.mojang.authlib.GameProfile(FAKEPLAYER_UUID, name);
        }
        if ((user = this.get(profile)).isPresent()) {
            return user.get();
        }
        return UserDiscoverer.create((com.mojang.authlib.GameProfile)profile);
    }

    public User forceRecreateUser(GameProfile profile) {
        return UserDiscoverer.forceRecreate((com.mojang.authlib.GameProfile)profile);
    }

    @Override
    public Collection<GameProfile> getAll() {
        return UserDiscoverer.getAllProfiles();
    }

    @Override
    public boolean delete(GameProfile profile) {
        Preconditions.checkState((boolean)Sponge.isServerAvailable(), (Object)"Server is not available!");
        return UserDiscoverer.delete(((GameProfile)Preconditions.checkNotNull((Object)profile, (Object)"profile")).getUniqueId());
    }

    @Override
    public boolean delete(User user) {
        Preconditions.checkState((boolean)Sponge.isServerAvailable(), (Object)"Server is not available!");
        return UserDiscoverer.delete(((User)Preconditions.checkNotNull((Object)user, (Object)"user")).getUniqueId());
    }

    @Override
    public Collection<GameProfile> match(String lastKnownName) {
        lastKnownName = ((String)Preconditions.checkNotNull((Object)lastKnownName, (Object)"lastKnownName")).toLowerCase(Locale.ROOT);
        Collection<GameProfile> allProfiles = UserDiscoverer.getAllProfiles();
        HashSet matching = Sets.newHashSet();
        for (GameProfile profile : allProfiles) {
            if (!profile.getName().isPresent() || !profile.getName().get().startsWith(lastKnownName)) continue;
            matching.add(profile);
        }
        return matching;
    }
}

