/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.ban;

import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.server.management.UserListIPBans;
import net.minecraft.server.management.UserListIPBansEntry;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.service.ban.BanService;
import org.spongepowered.api.util.ban.Ban;
import org.spongepowered.common.util.NetworkUtil;

public class SpongeIPBanList
extends UserListIPBans {
    public SpongeIPBanList(File bansFile) {
        super(bansFile);
    }

    private static BanService getService() {
        return Sponge.getServiceManager().provideUnchecked(BanService.class);
    }

    protected boolean hasEntry(String entry) {
        if (entry.equals("local")) {
            return false;
        }
        try {
            return SpongeIPBanList.getService().isBanned(InetAddress.getByName(entry));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Error parsing Ban IP address!", e);
        }
    }

    @Nullable
    public UserListIPBansEntry getEntry(String obj) {
        if (obj.equals("local")) {
            return null;
        }
        try {
            return SpongeIPBanList.getService().getBanFor(InetAddress.getByName(obj)).orElse(null);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Error parsing Ban IP address!", e);
        }
    }

    public void removeEntry(String entry) {
        if (entry.equals("local")) {
            return;
        }
        try {
            SpongeIPBanList.getService().pardon(InetAddress.getByName(entry));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Error parsing Ban IP address!", e);
        }
    }

    public String[] func_152685_a() {
        ArrayList<String> ips = new ArrayList<String>();
        for (Ban.Ip ban : SpongeIPBanList.getService().getIpBans()) {
            ips.add(this.func_152707_c(new InetSocketAddress(ban.getAddress(), 0)));
        }
        return ips.toArray(new String[ips.size()]);
    }

    public void addEntry(UserListIPBansEntry entry) {
        SpongeIPBanList.getService().addBan((Ban)entry);
    }

    public boolean func_152690_d() {
        return SpongeIPBanList.getService().getIpBans().isEmpty();
    }

    public String func_152707_c(SocketAddress address) {
        return NetworkUtil.getHostString(address);
    }
}

