/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.world.gen.feature;

import com.flowpowered.math.vector.Vector3i;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.spongepowered.api.data.type.ShrubType;
import org.spongepowered.api.data.type.ShrubTypes;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.PopulatorTypes;
import org.spongepowered.api.world.gen.populator.Shrub;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.util.VecHelper;

@Mixin(value={WorldGenTallGrass.class})
public abstract class WorldGenTallGrassMixin_API
extends WorldGenerator
implements Shrub {
    @Shadow
    @Final
    @Mutable
    private IBlockState field_175907_a;
    private final WeightedTable<ShrubType> types = new WeightedTable();
    @Nullable
    private Function<Location<Extent>, ShrubType> override = null;
    private VariableAmount count = VariableAmount.fixed(128.0);

    @Override
    public PopulatorType getType() {
        return PopulatorTypes.SHRUB;
    }

    @Override
    public void populate(org.spongepowered.api.world.World worldIn, Extent extent, Random random) {
        Vector3i min = extent.getBlockMin();
        Vector3i size = extent.getBlockSize();
        World world = (World)worldIn;
        BlockPos position = new BlockPos(min.getX(), min.getY(), min.getZ());
        ShrubType stype = ShrubTypes.TALL_GRASS;
        int n = (int)Math.ceil((float)this.count.getFlooredAmount(random) / 128.0f);
        for (int i = 0; i < n; ++i) {
            BlockPos pos = position.func_177982_a(random.nextInt(size.getX()), 0, random.nextInt(size.getZ()));
            pos = world.func_175672_r(pos).func_177982_a(0, 1, 0);
            if (this.override != null) {
                Location<Extent> pos2 = new Location<Extent>(extent, VecHelper.toVector3i(pos));
                stype = this.override.apply(pos2);
            } else {
                List<ShrubType> result = this.types.get(random);
                if (result.isEmpty()) continue;
                stype = result.get(0);
            }
            BlockTallGrass.EnumType type = (BlockTallGrass.EnumType)stype;
            this.field_175907_a = Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)type);
            this.func_180709_b(world, random, pos);
        }
    }

    @Override
    public WeightedTable<ShrubType> getTypes() {
        return this.types;
    }

    @Override
    public VariableAmount getShrubsPerChunk() {
        return this.count;
    }

    @Override
    public void setShrubsPerChunk(VariableAmount count) {
        this.count = count;
    }

    @Override
    public Optional<Function<Location<Extent>, ShrubType>> getSupplierOverride() {
        return Optional.ofNullable(this.override);
    }

    @Override
    public void setSupplierOverride(@Nullable Function<Location<Extent>, ShrubType> override) {
        this.override = override;
    }
}

