/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.entity.player;

import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.network.play.server.SPacketChat;
import net.minecraft.network.play.server.SPacketCustomSound;
import net.minecraft.network.play.server.SPacketResourcePackSend;
import net.minecraft.network.play.server.SPacketSoundEffect;
import net.minecraft.network.play.server.SPacketWorldBorder;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.border.IBorderListener;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.advancement.AdvancementProgress;
import org.spongepowered.api.advancement.AdvancementTree;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.mutable.entity.GameModeData;
import org.spongepowered.api.data.manipulator.mutable.entity.JoinData;
import org.spongepowered.api.data.type.SkinPart;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.sound.SoundCategory;
import org.spongepowered.api.effect.sound.SoundType;
import org.spongepowered.api.effect.sound.record.RecordType;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.CooldownTracker;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.tab.TabList;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.message.MessageChannelEvent;
import org.spongepowered.api.event.message.MessageEvent;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.api.network.PlayerConnection;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.resourcepack.ResourcePack;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.text.BookView;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.chat.ChatType;
import org.spongepowered.api.text.chat.ChatTypes;
import org.spongepowered.api.text.chat.ChatVisibility;
import org.spongepowered.api.text.title.Title;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.WorldBorder;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.advancements.AdvancementBridge;
import org.spongepowered.common.bridge.advancements.PlayerAdvancementsBridge;
import org.spongepowered.common.bridge.entity.EntityBridge;
import org.spongepowered.common.bridge.entity.player.EntityPlayerMPBridge;
import org.spongepowered.common.bridge.inventory.ContainerBridge;
import org.spongepowered.common.bridge.network.NetHandlerPlayServerBridge;
import org.spongepowered.common.bridge.packet.SPacketResourcePackSendBridge;
import org.spongepowered.common.bridge.scoreboard.ServerScoreboardBridge;
import org.spongepowered.common.bridge.text.TitleBridge;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeGameModeData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeJoinData;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.effect.particle.SpongeParticleEffect;
import org.spongepowered.common.effect.particle.SpongeParticleHelper;
import org.spongepowered.common.effect.record.SpongeRecordType;
import org.spongepowered.common.effect.sound.SoundEffectHelper;
import org.spongepowered.common.entity.player.tab.SpongeTabList;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhase;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.mixin.api.mcp.entity.player.EntityPlayerMixin_API;
import org.spongepowered.common.mixin.core.network.play.server.SPacketBlockChangeAccessor;
import org.spongepowered.common.mixin.core.util.SoundEventsAccessor;
import org.spongepowered.common.mixin.core.world.border.WorldBorderAccessor;
import org.spongepowered.common.text.SpongeTexts;
import org.spongepowered.common.util.BookFaker;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.LocaleCache;
import org.spongepowered.common.util.NetworkUtil;
import org.spongepowered.common.world.storage.SpongePlayerDataHandler;

@Mixin(value={EntityPlayerMP.class})
@Implements(value={@Interface(iface=Player.class, prefix="api$")})
public abstract class EntityPlayerMPMixin_API
extends EntityPlayerMixin_API
implements Player {
    @Shadow
    @Final
    public MinecraftServer field_71133_b;
    @Shadow
    @Final
    public PlayerInteractionManager field_71134_c;
    @Shadow
    @Final
    private PlayerAdvancements field_192042_bX;
    @Shadow
    private String field_71148_cg;
    @Shadow
    public NetHandlerPlayServer field_71135_a;
    @Shadow
    private EntityPlayer.EnumChatVisibility field_71143_cn = EntityPlayer.EnumChatVisibility.FULL;
    @Shadow
    private boolean field_71140_co;
    private boolean api$sleepingIgnored;
    private TabList api$tabList = new SpongeTabList((EntityPlayerMP)this);
    @Nullable
    private WorldBorder api$worldBorder;

    @Shadow
    public abstract net.minecraft.entity.Entity func_175398_C();

    @Shadow
    public abstract void func_175399_e(net.minecraft.entity.Entity var1);

    @Override
    public GameProfile getProfile() {
        return ((EntityPlayerMPBridge)((Object)this)).bridge$getUser().getProfile();
    }

    @Override
    public boolean isOnline() {
        return ((EntityPlayerMPBridge)((Object)this)).bridge$getUser().isOnline();
    }

    @Override
    public Optional<Player> getPlayer() {
        return Optional.of(this);
    }

    @Override
    public Locale getLocale() {
        return LocaleCache.getLocale(this.field_71148_cg);
    }

    @Override
    public int getViewDistance() {
        return ((EntityPlayerMPBridge)((Object)this)).bridge$getViewDistance();
    }

    @Override
    public ChatVisibility getChatVisibility() {
        return (ChatVisibility)this.field_71143_cn;
    }

    @Override
    public boolean isChatColorsEnabled() {
        return this.field_71140_co;
    }

    @Override
    public Set<SkinPart> getDisplayedSkinParts() {
        return ((EntityPlayerMPBridge)((Object)this)).bridge$getSkinParts();
    }

    @Override
    public void sendMessage(ChatType type, Text message) {
        if (this.impl$isFake) {
            return;
        }
        Preconditions.checkNotNull((Object)type, (Object)"type");
        Preconditions.checkNotNull((Object)message, (Object)"message");
        ITextComponent component = SpongeTexts.toComponent(message);
        if (type == ChatTypes.ACTION_BAR) {
            component = SpongeTexts.fixActionBarFormatting(component);
        }
        this.field_71135_a.func_147359_a((Packet)new SPacketChat(component, (net.minecraft.util.text.ChatType)type));
    }

    @Override
    public void sendBookView(BookView bookView) {
        if (this.impl$isFake) {
            return;
        }
        BookFaker.fakeBookView(bookView, this);
    }

    @Override
    public void sendTitle(Title title) {
        if (this.impl$isFake) {
            return;
        }
        ((TitleBridge)((Object)title)).bridge$send((EntityPlayerMP)this);
    }

    @Override
    public void spawnParticles(ParticleEffect particleEffect, Vector3d position) {
        if (this.impl$isFake) {
            return;
        }
        this.spawnParticles(particleEffect, position, Integer.MAX_VALUE);
    }

    @Override
    public void spawnParticles(ParticleEffect particleEffect, Vector3d position, int radius) {
        if (this.impl$isFake) {
            return;
        }
        Preconditions.checkNotNull((Object)particleEffect, (Object)"The particle effect cannot be null!");
        Preconditions.checkNotNull((Object)position, (Object)"The position cannot be null");
        Preconditions.checkArgument((radius > 0 ? 1 : 0) != 0, (Object)"The radius has to be greater then zero!");
        List<Packet<?>> packets = SpongeParticleHelper.toPackets((SpongeParticleEffect)particleEffect, position);
        if (!packets.isEmpty() && position.sub(this.field_70165_t, this.field_70163_u, this.field_70161_v).lengthSquared() < (double)((long)radius * (long)radius)) {
            for (Packet<?> packet : packets) {
                this.field_71135_a.func_147359_a(packet);
            }
        }
    }

    @Override
    public PlayerConnection getConnection() {
        return (PlayerConnection)this.field_71135_a;
    }

    @Overwrite
    public String func_71114_r() {
        return NetworkUtil.getHostString(this.field_71135_a.field_147371_a.func_74430_c());
    }

    @Override
    public String getIdentifier() {
        return ((EntityPlayerMPBridge)((Object)this)).bridge$getUser().getIdentifier();
    }

    @Override
    public Optional<Container> getOpenInventory() {
        return Optional.ofNullable((Container)this.field_71070_bA);
    }

    @Override
    public Optional<Container> openInventory(Inventory inventory) throws IllegalArgumentException {
        return this.openInventory(inventory, null);
    }

    @Override
    public Optional<Container> openInventory(Inventory inventory, Text displayName) {
        if (((ContainerBridge)this.field_71070_bA).bridge$isInUse()) {
            Cause cause = Sponge.getCauseStackManager().getCurrentCause();
            SpongeImpl.getLogger().warn("This player is currently modifying an open container. This action will be delayed.");
            Sponge.getScheduler().createTaskBuilder().delayTicks(0L).execute(() -> {
                try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                    cause.all().forEach(frame::pushCause);
                    cause.getContext().asMap().forEach((key, value) -> frame.addContext(key, value));
                    this.closeInventory();
                    this.openInventory(inventory);
                }
            }).submit(SpongeImpl.getPlugin());
            return this.getOpenInventory();
        }
        return Optional.ofNullable((Container)SpongeCommonEventFactory.displayContainer((EntityPlayerMP)this, inventory, displayName));
    }

    @Override
    public boolean closeInventory() throws IllegalArgumentException {
        if (((ContainerBridge)this.field_71070_bA).bridge$isInUse()) {
            Cause cause = Sponge.getCauseStackManager().getCurrentCause();
            SpongeImpl.getLogger().warn("This player is currently modifying an open container. This action will be delayed.");
            Sponge.getScheduler().createTaskBuilder().delayTicks(0L).execute(() -> {
                try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                    cause.all().forEach(frame::pushCause);
                    cause.getContext().asMap().forEach((key, value) -> frame.addContext(key, value));
                    this.closeInventory();
                }
            }).submit(SpongeImpl.getPlugin());
            return false;
        }
        try (BasicPacketContext ctx = ((BasicPacketContext)((BasicPacketContext)PacketPhase.General.CLOSE_WINDOW.createPhaseContext().source(this)).packetPlayer((EntityPlayerMP)this)).openContainer(this.field_71070_bA);){
            ctx.buildAndSwitch();
            ItemStackSnapshot cursor = ItemStackUtil.snapshotOf(this.field_71071_by.func_70445_o());
            boolean bl = !SpongeCommonEventFactory.callInteractInventoryCloseEvent(this.field_71070_bA, (EntityPlayerMP)this, cursor, cursor, false).isCancelled();
            return bl;
        }
    }

    @Override
    public void setScoreboard(Scoreboard scoreboard) {
        if (((EntityPlayerMPBridge)((Object)this)).bridge$hasDelegate()) {
            ((Player)((EntityPlayerMPBridge)((Object)this)).bridge$getDelegate()).setScoreboard(scoreboard);
        }
        ((ServerScoreboardBridge)((Object)((EntityPlayerMPBridge)((Object)this)).bridge$getScoreboard())).bridge$removePlayer((EntityPlayerMP)this, true);
        ((EntityPlayerMPBridge)((Object)this)).bridge$replaceScoreboard(scoreboard);
        ((ServerScoreboardBridge)((Object)((EntityPlayerMPBridge)((Object)this)).bridge$getScoreboard())).bridge$addPlayer((EntityPlayerMP)this, true);
    }

    @Override
    public Text getTeamRepresentation() {
        return Text.of(this.shadow$func_70005_c_());
    }

    @Override
    public Scoreboard getScoreboard() {
        return ((EntityPlayerMPBridge)((Object)this)).bridge$getScoreboard();
    }

    @Override
    public void kick() {
        this.kick(Text.of(SpongeImpl.getGame().getRegistry().getTranslationById("disconnect.disconnected").get(), new Object[0]));
    }

    @Override
    public void kick(Text message) {
        ITextComponent component = SpongeTexts.toComponent(message);
        this.field_71135_a.func_194028_b(component);
    }

    @Override
    public void playSound(SoundType sound, SoundCategory category, Vector3d position, double volume) {
        this.playSound(sound, category, position, volume, 1.0);
    }

    @Override
    public void playSound(SoundType sound, SoundCategory category, Vector3d position, double volume, double pitch) {
        this.playSound(sound, category, position, volume, pitch, 0.0);
    }

    @Override
    public void playSound(SoundType sound, SoundCategory category, Vector3d position, double volume, double pitch, double minVolume) {
        SoundEvent event;
        try {
            event = SoundEventsAccessor.accessor$getRegisteredSoundEvent(sound.getId());
        }
        catch (IllegalStateException e) {
            this.field_71135_a.func_147359_a((Packet)new SPacketCustomSound(sound.getId(), (net.minecraft.util.SoundCategory)category, position.getX(), position.getY(), position.getZ(), (float)Math.max(minVolume, volume), (float)pitch));
            return;
        }
        this.field_71135_a.func_147359_a((Packet)new SPacketSoundEffect(event, (net.minecraft.util.SoundCategory)category, position.getX(), position.getY(), position.getZ(), (float)Math.max(minVolume, volume), (float)pitch));
    }

    @Override
    public void stopSounds() {
        this.stopSounds0(null, null);
    }

    @Override
    public void stopSounds(SoundType sound) {
        this.stopSounds0((SoundType)Preconditions.checkNotNull((Object)sound, (Object)"sound"), null);
    }

    @Override
    public void stopSounds(SoundCategory category) {
        this.stopSounds0(null, (SoundCategory)Preconditions.checkNotNull((Object)category, (Object)"category"));
    }

    @Override
    public void stopSounds(SoundType sound, SoundCategory category) {
        this.stopSounds0((SoundType)Preconditions.checkNotNull((Object)sound, (Object)"sound"), (SoundCategory)Preconditions.checkNotNull((Object)category, (Object)"category"));
    }

    private void stopSounds0(@Nullable SoundType sound, @Nullable SoundCategory category) {
        this.field_71135_a.func_147359_a((Packet)SoundEffectHelper.createStopSoundPacket(sound, category));
    }

    @Override
    public void playRecord(Vector3i position, RecordType recordType) {
        this.playRecord0(position, (RecordType)Preconditions.checkNotNull((Object)recordType, (Object)"recordType"));
    }

    @Override
    public void stopRecord(Vector3i position) {
        this.playRecord0(position, null);
    }

    private void playRecord0(Vector3i position, @Nullable RecordType recordType) {
        this.field_71135_a.func_147359_a((Packet)SpongeRecordType.createPacket(position, recordType));
    }

    @Override
    public void sendResourcePack(ResourcePack pack) {
        SPacketResourcePackSend packet = new SPacketResourcePackSend();
        ((SPacketResourcePackSendBridge)packet).bridge$setSpongePack(pack);
        this.field_71135_a.func_147359_a((Packet)packet);
    }

    @Inject(method={"markPlayerActive()V"}, at={@At(value="HEAD")})
    private void onPlayerActive(CallbackInfo ci) {
        ((NetHandlerPlayServerBridge)this.field_71135_a).bridge$resendLatestResourcePackRequest();
    }

    @Override
    public boolean isSleepingIgnored() {
        return this.api$sleepingIgnored;
    }

    @Override
    public void setSleepingIgnored(boolean sleepingIgnored) {
        this.api$sleepingIgnored = sleepingIgnored;
    }

    @Override
    public Vector3d getVelocity() {
        if (((EntityPlayerMPBridge)((Object)this)).bridge$getVelocityOverride() != null) {
            return ((EntityPlayerMPBridge)((Object)this)).bridge$getVelocityOverride();
        }
        return super.getVelocity();
    }

    @Override
    public CarriedInventory<? extends Carrier> getInventory() {
        return (CarriedInventory)this.field_71071_by;
    }

    @Override
    public TabList getTabList() {
        return this.api$tabList;
    }

    @Override
    public JoinData getJoinData() {
        return new SpongeJoinData(SpongePlayerDataHandler.getFirstJoined(this.func_110124_au()).get(), Instant.now());
    }

    @Override
    public Value<Instant> firstPlayed() {
        return new SpongeValue<Instant>(Keys.FIRST_DATE_PLAYED, Instant.EPOCH, SpongePlayerDataHandler.getFirstJoined(this.func_110124_au()).get());
    }

    @Override
    public Value<Instant> lastPlayed() {
        return new SpongeValue<Instant>(Keys.LAST_DATE_PLAYED, Instant.EPOCH, Instant.now());
    }

    @Override
    public boolean hasPlayedBefore() {
        Instant instant = SpongePlayerDataHandler.getFirstJoined(this.getUniqueId()).get();
        Instant toTheMinute = instant.truncatedTo(ChronoUnit.MINUTES);
        Instant now = Instant.now().truncatedTo(ChronoUnit.MINUTES);
        Duration timeSinceFirstJoined = Duration.of(now.minusMillis(toTheMinute.toEpochMilli()).toEpochMilli(), ChronoUnit.MINUTES);
        return timeSinceFirstJoined.getSeconds() > 0L;
    }

    @Override
    public GameModeData getGameModeData() {
        return new SpongeGameModeData((GameMode)this.field_71134_c.func_73081_b());
    }

    @Override
    public Value<GameMode> gameMode() {
        return new SpongeValue<GameMode>(Keys.GAME_MODE, Constants.Catalog.DEFAULT_GAMEMODE, (GameMode)this.field_71134_c.func_73081_b());
    }

    @Override
    public void spongeApi$supplyVanillaManipulators(Collection<? super DataManipulator<?, ?>> manipulators) {
        super.spongeApi$supplyVanillaManipulators(manipulators);
        manipulators.add(this.getJoinData());
        manipulators.add(this.getGameModeData());
    }

    public void sendBlockChange(BlockPos pos, IBlockState state) {
        SPacketBlockChange packet = new SPacketBlockChange();
        ((SPacketBlockChangeAccessor)packet).accessor$setBlockPosition(pos);
        ((SPacketBlockChangeAccessor)packet).accessor$setBlockState(state);
        this.field_71135_a.func_147359_a((Packet)packet);
    }

    @Override
    public void sendBlockChange(int x, int y, int z, BlockState state) {
        Preconditions.checkNotNull((Object)state, (Object)"state");
        this.sendBlockChange(new BlockPos(x, y, z), (IBlockState)state);
    }

    @Override
    public void resetBlockChange(int x, int y, int z) {
        SPacketBlockChange packet = new SPacketBlockChange(this.field_70170_p, new BlockPos(x, y, z));
        this.field_71135_a.func_147359_a((Packet)packet);
    }

    @Override
    public Inventory getEnderChestInventory() {
        return (Inventory)this.field_71078_a;
    }

    @Override
    public boolean respawnPlayer() {
        if (this.func_110143_aJ() > 0.0f) {
            return false;
        }
        this.field_71135_a.field_147369_b = this.field_71133_b.func_184103_al().func_72368_a((EntityPlayerMP)this, this.field_71093_bK, false);
        return true;
    }

    @Override
    public Optional<Entity> getSpectatorTarget() {
        net.minecraft.entity.Entity entity = this.func_175398_C();
        return entity == this ? Optional.empty() : Optional.of((Entity)entity);
    }

    @Override
    public void setSpectatorTarget(@Nullable Entity entity) {
        this.func_175399_e((net.minecraft.entity.Entity)entity);
    }

    @Override
    public MessageChannelEvent.Chat simulateChat(Text message, Cause cause) {
        Preconditions.checkNotNull((Object)message, (Object)"message");
        TextComponentTranslation component = new TextComponentTranslation("chat.type.text", new Object[]{SpongeTexts.toComponent(((EntityBridge)((Object)this)).bridge$getDisplayNameText()), SpongeTexts.toComponent(message)});
        Text[] messages = SpongeTexts.splitChatMessage((ITextComponent)component);
        MessageChannel originalChannel = this.getMessageChannel();
        MessageChannelEvent.Chat event = SpongeEventFactory.createMessageChannelEventChat(cause, originalChannel, Optional.of(originalChannel), new MessageEvent.MessageFormatter(messages[0], messages[1]), message, false);
        if (!SpongeImpl.postEvent(event) && !event.isMessageCancelled()) {
            event.getChannel().ifPresent(channel -> channel.send(this, event.getMessage(), ChatTypes.CHAT));
        }
        return event;
    }

    @Override
    public Optional<WorldBorder> getWorldBorder() {
        return Optional.ofNullable(this.api$worldBorder);
    }

    @Override
    public void setWorldBorder(@Nullable WorldBorder border, Cause cause) {
        if (this.api$worldBorder == border) {
            return;
        }
        if (!SpongeImpl.postEvent(SpongeEventFactory.createChangeWorldBorderEventTargetPlayer(cause, Optional.ofNullable(this.api$worldBorder), Optional.ofNullable(border), this))) {
            if (this.api$worldBorder != null) {
                ((WorldBorderAccessor)((Object)this.api$worldBorder)).accessor$getListeners().remove(((EntityPlayerMPBridge)((Object)this)).bridge$getWorldBorderListener());
            }
            this.api$worldBorder = border;
            if (this.api$worldBorder != null) {
                ((net.minecraft.world.border.WorldBorder)this.api$worldBorder).func_177737_a((IBorderListener)((EntityPlayerMPBridge)((Object)this)).bridge$getWorldBorderListener());
                this.field_71135_a.func_147359_a((Packet)new SPacketWorldBorder((net.minecraft.world.border.WorldBorder)this.api$worldBorder, SPacketWorldBorder.Action.INITIALIZE));
            } else {
                this.field_71135_a.func_147359_a((Packet)new SPacketWorldBorder(this.field_70170_p.func_175723_af(), SPacketWorldBorder.Action.INITIALIZE));
            }
        }
    }

    @Override
    public CooldownTracker getCooldownTracker() {
        return (CooldownTracker)this.shadow$func_184811_cZ();
    }

    @Override
    public AdvancementProgress getProgress(org.spongepowered.api.advancement.Advancement advancement) {
        Preconditions.checkNotNull((Object)advancement, (Object)"advancement");
        Preconditions.checkState((boolean)((AdvancementBridge)((Object)advancement)).bridge$isRegistered(), (Object)"The advancement must be registered");
        return (AdvancementProgress)this.field_192042_bX.func_192747_a((Advancement)advancement);
    }

    @Override
    public Collection<AdvancementTree> getUnlockedAdvancementTrees() {
        return ((PlayerAdvancementsBridge)this.field_192042_bX).bridge$getAdvancementTrees();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This is an internal method not intended for use with Players as it causes the player to be placed into an undefined state. Consider putting them through the normal death process instead.");
    }

    @Override
    public Optional<UUID> getWorldUniqueId() {
        return Optional.of(this.getWorld().getUniqueId());
    }

    @Override
    public boolean setLocation(Vector3d position, UUID world) {
        WorldProperties prop = Sponge.getServer().getWorldProperties(world).orElseThrow(() -> new IllegalArgumentException("Invalid World: No world found for UUID"));
        World loaded = Sponge.getServer().loadWorld(prop).orElseThrow(() -> new IllegalArgumentException("Invalid World: Could not load world for UUID"));
        return this.setLocation(new Location<World>(loaded, position));
    }
}

