/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable.entity;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableBodyPartRotationalData;
import org.spongepowered.api.data.manipulator.mutable.entity.BodyPartRotationalData;
import org.spongepowered.api.data.type.BodyPart;
import org.spongepowered.api.data.type.BodyParts;
import org.spongepowered.api.data.value.immutable.ImmutableMapValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.common.data.manipulator.immutable.common.AbstractImmutableData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeBodyPartRotationalData;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeMapValue;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.util.Constants;

public class ImmutableSpongeBodyPartRotationalData
extends AbstractImmutableData<ImmutableBodyPartRotationalData, BodyPartRotationalData>
implements ImmutableBodyPartRotationalData {
    private final Map<BodyPart, Vector3d> rotations;
    private final ImmutableMapValue<BodyPart, Vector3d> rotationsValue;
    private final ImmutableValue<Vector3d> headRotationValue;
    private final ImmutableValue<Vector3d> chestRotationValue;
    private final ImmutableValue<Vector3d> leftArmRotationValue;
    private final ImmutableValue<Vector3d> rightArmRotationValue;
    private final ImmutableValue<Vector3d> leftLegRotationValue;
    private final ImmutableValue<Vector3d> rightLegRotationValue;

    public ImmutableSpongeBodyPartRotationalData(Map<BodyPart, Vector3d> rotations) {
        super(ImmutableBodyPartRotationalData.class);
        this.rotations = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(rotations, (Object)"rotations")));
        this.rotationsValue = new ImmutableSpongeMapValue<BodyPart, Vector3d>(Keys.BODY_ROTATIONS, this.rotations);
        this.headRotationValue = new ImmutableSpongeValue<Vector3d>(Keys.HEAD_ROTATION, Optional.ofNullable(this.rotations.get(BodyParts.HEAD)).orElse(Constants.Entity.ArmorStand.DEFAULT_HEAD_ROTATION));
        this.chestRotationValue = new ImmutableSpongeValue<Vector3d>(Keys.CHEST_ROTATION, Optional.ofNullable(this.rotations.get(BodyParts.CHEST)).orElse(Constants.Entity.ArmorStand.DEFAULT_CHEST_ROTATION));
        this.leftArmRotationValue = new ImmutableSpongeValue<Vector3d>(Keys.LEFT_ARM_ROTATION, Optional.ofNullable(this.rotations.get(BodyParts.LEFT_ARM)).orElse(Constants.Entity.ArmorStand.DEFAULT_LEFT_ARM_ROTATION));
        this.rightArmRotationValue = new ImmutableSpongeValue<Vector3d>(Keys.RIGHT_ARM_ROTATION, Optional.ofNullable(this.rotations.get(BodyParts.RIGHT_ARM)).orElse(Constants.Entity.ArmorStand.DEFAULT_RIGHT_ARM_ROTATION));
        this.leftLegRotationValue = new ImmutableSpongeValue<Vector3d>(Keys.LEFT_LEG_ROTATION, Optional.ofNullable(this.rotations.get(BodyParts.LEFT_LEG)).orElse(Constants.Entity.ArmorStand.DEFAULT_LEFT_LEG_ROTATION));
        this.rightLegRotationValue = new ImmutableSpongeValue<Vector3d>(Keys.RIGHT_LEG_ROTATION, Optional.ofNullable(this.rotations.get(BodyParts.RIGHT_LEG)).orElse(Constants.Entity.ArmorStand.DEFAULT_RIGHT_LEG_ROTATION));
        this.registerGetters();
    }

    @Override
    public BodyPartRotationalData asMutable() {
        return new SpongeBodyPartRotationalData(this.rotations);
    }

    @Override
    public DataContainer toContainer() {
        Vector3d headRotation = this.rotations.get(BodyParts.HEAD);
        Vector3d chestRotation = this.rotations.get(BodyParts.CHEST);
        Vector3d leftArmRotation = this.rotations.get(BodyParts.LEFT_ARM);
        Vector3d rightArmRotation = this.rotations.get(BodyParts.RIGHT_ARM);
        Vector3d leftLegRotation = this.rotations.get(BodyParts.LEFT_LEG);
        Vector3d rightLegRotation = this.rotations.get(BodyParts.RIGHT_LEG);
        return super.toContainer().set(Keys.BODY_ROTATIONS, (Object)this.rotations).set(Keys.HEAD_ROTATION.getQuery().then(Queries.POSITION_X), (Object)headRotation.getX()).set(Keys.HEAD_ROTATION.getQuery().then(Queries.POSITION_Y), (Object)headRotation.getY()).set(Keys.HEAD_ROTATION.getQuery().then(Queries.POSITION_Z), (Object)headRotation.getZ()).set(Keys.CHEST_ROTATION.getQuery().then(Queries.POSITION_X), (Object)chestRotation.getX()).set(Keys.CHEST_ROTATION.getQuery().then(Queries.POSITION_Y), (Object)chestRotation.getY()).set(Keys.CHEST_ROTATION.getQuery().then(Queries.POSITION_Z), (Object)chestRotation.getZ()).set(Keys.LEFT_ARM_ROTATION.getQuery().then(Queries.POSITION_X), (Object)leftArmRotation.getX()).set(Keys.LEFT_ARM_ROTATION.getQuery().then(Queries.POSITION_Y), (Object)leftArmRotation.getY()).set(Keys.LEFT_ARM_ROTATION.getQuery().then(Queries.POSITION_Z), (Object)leftArmRotation.getZ()).set(Keys.RIGHT_ARM_ROTATION.getQuery().then(Queries.POSITION_X), (Object)rightArmRotation.getX()).set(Keys.RIGHT_ARM_ROTATION.getQuery().then(Queries.POSITION_Y), (Object)rightArmRotation.getY()).set(Keys.RIGHT_ARM_ROTATION.getQuery().then(Queries.POSITION_Z), (Object)rightArmRotation.getZ()).set(Keys.LEFT_LEG_ROTATION.getQuery().then(Queries.POSITION_X), (Object)leftLegRotation.getX()).set(Keys.LEFT_LEG_ROTATION.getQuery().then(Queries.POSITION_Y), (Object)leftLegRotation.getY()).set(Keys.LEFT_LEG_ROTATION.getQuery().then(Queries.POSITION_Z), (Object)leftLegRotation.getZ()).set(Keys.RIGHT_LEG_ROTATION.getQuery().then(Queries.POSITION_X), (Object)rightLegRotation.getX()).set(Keys.RIGHT_LEG_ROTATION.getQuery().then(Queries.POSITION_Y), (Object)rightLegRotation.getY()).set(Keys.RIGHT_LEG_ROTATION.getQuery().then(Queries.POSITION_Z), (Object)rightLegRotation.getZ());
    }

    @Override
    public ImmutableMapValue<BodyPart, Vector3d> partRotation() {
        return this.rotationsValue;
    }

    @Override
    public ImmutableValue<Vector3d> headDirection() {
        return this.headRotationValue;
    }

    @Override
    public ImmutableValue<Vector3d> bodyRotation() {
        return this.chestRotationValue;
    }

    @Override
    public ImmutableValue<Vector3d> leftArmDirection() {
        return this.leftArmRotationValue;
    }

    @Override
    public ImmutableValue<Vector3d> rightArmDirection() {
        return this.rightArmRotationValue;
    }

    @Override
    public ImmutableValue<Vector3d> leftLegDirection() {
        return this.leftLegRotationValue;
    }

    @Override
    public ImmutableValue<Vector3d> rightLegDirection() {
        return this.rightLegRotationValue;
    }

    @Override
    protected void registerGetters() {
        this.registerFieldGetter(Keys.BODY_ROTATIONS, () -> this.rotations);
        this.registerKeyValue(Keys.BODY_ROTATIONS, this::partRotation);
        this.registerFieldGetter(Keys.HEAD_ROTATION, () -> this.rotations.get(BodyParts.HEAD));
        this.registerKeyValue(Keys.HEAD_ROTATION, this::headDirection);
        this.registerFieldGetter(Keys.CHEST_ROTATION, () -> this.rotations.get(BodyParts.CHEST));
        this.registerKeyValue(Keys.CHEST_ROTATION, this::bodyRotation);
        this.registerFieldGetter(Keys.LEFT_ARM_ROTATION, () -> this.rotations.get(BodyParts.LEFT_ARM));
        this.registerKeyValue(Keys.LEFT_ARM_ROTATION, this::leftArmDirection);
        this.registerFieldGetter(Keys.RIGHT_ARM_ROTATION, () -> this.rotations.get(BodyParts.RIGHT_ARM));
        this.registerKeyValue(Keys.RIGHT_ARM_ROTATION, this::rightArmDirection);
        this.registerFieldGetter(Keys.LEFT_LEG_ROTATION, () -> this.rotations.get(BodyParts.LEFT_LEG));
        this.registerKeyValue(Keys.LEFT_LEG_ROTATION, this::leftLegDirection);
        this.registerFieldGetter(Keys.RIGHT_LEG_ROTATION, () -> this.rotations.get(BodyParts.RIGHT_LEG));
        this.registerKeyValue(Keys.RIGHT_LEG_ROTATION, this::rightLegDirection);
    }
}

