/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world;

import com.flowpowered.math.vector.Vector3d;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.util.ResettableBuilder;
import org.spongepowered.api.world.ChunkPreGenerate;
import org.spongepowered.api.world.World;

public interface WorldBorder {
    public static Builder builder() {
        return Sponge.getRegistry().createBuilder(Builder.class);
    }

    public double getNewDiameter();

    public double getDiameter();

    public void setDiameter(double var1);

    public void setDiameter(double var1, long var3);

    public void setDiameter(double var1, double var3, long var5);

    public long getTimeRemaining();

    public void setCenter(double var1, double var3);

    public Vector3d getCenter();

    public int getWarningTime();

    public void setWarningTime(int var1);

    public int getWarningDistance();

    public void setWarningDistance(int var1);

    public double getDamageThreshold();

    public void setDamageThreshold(double var1);

    public double getDamageAmount();

    public void setDamageAmount(double var1);

    public ChunkPreGenerate.Builder newChunkPreGenerate(World var1);

    default public void copyPropertiesFrom(WorldBorder border) {
        this.setCenter(border.getCenter().getX(), border.getCenter().getZ());
        this.setDamageAmount(border.getDamageAmount());
        this.setDamageThreshold(border.getDamageThreshold());
        this.setDiameter(border.getDiameter(), border.getNewDiameter(), border.getTimeRemaining());
        this.setWarningDistance(border.getWarningDistance());
        this.setWarningTime(border.getWarningTime());
    }

    public static interface Builder
    extends ResettableBuilder<WorldBorder, Builder> {
        @Override
        public Builder from(WorldBorder var1);

        public Builder diameter(double var1);

        public Builder center(double var1, double var3);

        public Builder warningTime(int var1);

        public Builder warningDistance(int var1);

        public Builder damageThreshold(double var1);

        public Builder damageAmount(double var1);

        public WorldBorder build();
    }
}

