/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.service.proxy.api6;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import me.lucko.luckperms.api.Tristate;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.sponge.service.model.LPPermissionDescription;
import me.lucko.luckperms.sponge.service.model.LPPermissionService;
import me.lucko.luckperms.sponge.service.model.LPSubject;
import me.lucko.luckperms.sponge.service.model.LPSubjectCollection;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.service.permission.PermissionDescription;
import org.spongepowered.api.text.Text;

public final class DescriptionBuilder
implements PermissionDescription.Builder {
    private final @NonNull LPPermissionService service;
    private final @NonNull PluginContainer container;
    private final @NonNull Map<String, Tristate> roles = new HashMap<String, Tristate>();
    private @Nullable String id = null;
    private @Nullable Text description = null;

    public DescriptionBuilder(@NonNull LPPermissionService service, @NonNull PluginContainer container) {
        this.service = Objects.requireNonNull(service, "service");
        this.container = Objects.requireNonNull(container, "container");
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull PermissionDescription.Builder id(@NonNull String id) {
        this.id = Objects.requireNonNull(id, "id");
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull PermissionDescription.Builder description(@NonNull Text description) {
        this.description = Objects.requireNonNull(description, "description");
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull PermissionDescription.Builder assign(@NonNull String role, boolean value) {
        Objects.requireNonNull(role, "role");
        this.roles.put(role, Tristate.fromBoolean(value));
        return this;
    }

    public @NonNull PermissionDescription register() throws IllegalStateException {
        if (this.id == null) {
            throw new IllegalStateException("id cannot be null");
        }
        LPPermissionDescription description = this.service.registerPermissionDescription(this.id, this.description, this.container);
        LPSubjectCollection subjects = this.service.getCollection("role-template");
        for (Map.Entry<String, Tristate> assignment : this.roles.entrySet()) {
            LPSubject roleSubject = subjects.loadSubject(assignment.getKey()).join();
            roleSubject.getTransientSubjectData().setPermission(ContextSet.empty(), this.id, assignment.getValue());
        }
        this.roles.clear();
        this.id = null;
        this.description = null;
        return description.sponge();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DescriptionBuilder)) {
            return false;
        }
        DescriptionBuilder other = (DescriptionBuilder)o;
        return this.container.equals(other.container) && this.roles.equals(other.roles) && (this.id == null ? other.id == null : this.id.equals(other.id)) && (this.description == null ? other.description == null : this.description.equals((Object)other.description));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.container.hashCode();
        result = result * 59 + this.roles.hashCode();
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        return result;
    }

    public String toString() {
        return "SimpleDescriptionBuilder(container=" + this.container + ", roles=" + this.roles + ", id=" + this.id + ", description=" + this.description + ")";
    }
}

