/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.service.internal;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import me.lucko.luckperms.api.Contexts;
import me.lucko.luckperms.api.Tristate;
import me.lucko.luckperms.api.context.ImmutableContextSet;
import me.lucko.luckperms.common.caching.type.MetaCache;
import me.lucko.luckperms.common.graph.TraversalAlgorithm;
import me.lucko.luckperms.common.inheritance.InheritanceGraph;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.NodeMapType;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.node.factory.NodeFactory;
import me.lucko.luckperms.common.verbose.CheckOrigin;
import me.lucko.luckperms.sponge.LPSpongePlugin;
import me.lucko.luckperms.sponge.model.SpongeGroup;
import me.lucko.luckperms.sponge.service.LuckPermsService;
import me.lucko.luckperms.sponge.service.internal.HolderSubjectData;
import me.lucko.luckperms.sponge.service.model.LPSubject;
import me.lucko.luckperms.sponge.service.model.LPSubjectReference;
import me.lucko.luckperms.sponge.service.proxy.ProxyFactory;
import org.spongepowered.api.service.permission.Subject;

public abstract class HolderSubject<T extends PermissionHolder>
implements LPSubject {
    protected final T parent;
    protected final LPSpongePlugin plugin;
    private final HolderSubjectData subjectData;
    private final HolderSubjectData transientSubjectData;
    private Subject spongeSubject = null;

    HolderSubject(LPSpongePlugin plugin, T parent) {
        this.parent = parent;
        this.plugin = plugin;
        this.subjectData = new HolderSubjectData(plugin.getService(), NodeMapType.ENDURING, (PermissionHolder)parent, this);
        this.transientSubjectData = new HolderSubjectData(plugin.getService(), NodeMapType.TRANSIENT, (PermissionHolder)parent, this);
    }

    public void fireUpdateEvent() {
        this.plugin.getUpdateEventHandler().fireUpdateEvent(this.subjectData);
        this.plugin.getUpdateEventHandler().fireUpdateEvent(this.transientSubjectData);
    }

    public T getParent() {
        return this.parent;
    }

    @Override
    public synchronized Subject sponge() {
        if (this.spongeSubject == null) {
            this.spongeSubject = ProxyFactory.toSponge(this);
        }
        return this.spongeSubject;
    }

    @Override
    public LuckPermsService getService() {
        return this.plugin.getService();
    }

    @Override
    public LPSubject getDefaults() {
        return this.plugin.getService().getDefaultSubjects().getTypeDefaults(this.getParentCollection().getIdentifier());
    }

    @Override
    public HolderSubjectData getSubjectData() {
        return this.subjectData;
    }

    @Override
    public HolderSubjectData getTransientSubjectData() {
        return this.transientSubjectData;
    }

    @Override
    public Tristate getPermissionValue(ImmutableContextSet contexts, String permission) {
        Contexts lookupContexts = this.plugin.getContextManager().formContexts(contexts);
        return ((PermissionHolder)this.parent).getCachedData().getPermissionData(lookupContexts).getPermissionValue(permission, CheckOrigin.PLATFORM_LOOKUP_CHECK);
    }

    @Override
    public boolean isChildOf(ImmutableContextSet contexts, LPSubjectReference parent) {
        return parent.getCollectionIdentifier().equals("group") && this.getPermissionValue(contexts, NodeFactory.groupNode(parent.getSubjectIdentifier())).asBoolean();
    }

    @Override
    public ImmutableList<LPSubjectReference> getParents(ImmutableContextSet contexts) {
        InheritanceGraph graph = this.plugin.getInheritanceHandler().getGraph(this.plugin.getContextManager().formContexts(contexts));
        Iterable<T> traversal = graph.traverse(TraversalAlgorithm.DEPTH_FIRST_PRE_ORDER, this.parent);
        ImmutableList.Builder subjects = ImmutableList.builder();
        for (PermissionHolder parent : traversal) {
            if (!(parent instanceof Group)) continue;
            subjects.add((Object)((SpongeGroup)parent).sponge().toReference());
        }
        return subjects.build();
    }

    @Override
    public Optional<String> getOption(ImmutableContextSet contexts, String s) {
        MetaCache data = ((PermissionHolder)this.parent).getCachedData().getMetaData(this.plugin.getContextManager().formContexts(contexts));
        if (s.equalsIgnoreCase("prefix") && data.getPrefix() != null) {
            return Optional.of(data.getPrefix());
        }
        if (s.equalsIgnoreCase("suffix") && data.getSuffix() != null) {
            return Optional.of(data.getSuffix());
        }
        String val = data.getMeta().get(s);
        if (val != null) {
            return Optional.of(val);
        }
        Optional<String> v = this.getParentCollection().getDefaults().getOption(contexts, s);
        if (v.isPresent()) {
            return v;
        }
        return this.plugin.getService().getRootDefaults().getOption(contexts, s);
    }

    @Override
    public void invalidateCaches() {
        ((PermissionHolder)this.parent).invalidateCachedData();
    }
}

